/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.exceptions.ResouceTableException;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

public class ResourceTableValidator
extends SubValidator {
    @Override
    public void validateModule(BundleModule module) {
        Resources.ResourceTable resourceTable = module.getResourceTable().orElse(Resources.ResourceTable.getDefaultInstance());
        String moduleName = module.getName().getName();
        ImmutableSet resFiles = (ImmutableSet)module.findEntriesUnderPath(BundleModule.RESOURCES_DIRECTORY).map(ModuleEntry::getPath).collect(ImmutableSet.toImmutableSet());
        if (!resFiles.isEmpty() && !module.getResourceTable().isPresent()) {
            throw new ResouceTableException.ResourceTableMissingException(moduleName);
        }
        ImmutableSet<ZipPath> referencedFiles = ResourcesUtils.getAllFileReferences(resourceTable);
        for (ZipPath referencedFile : referencedFiles) {
            if (referencedFile.startsWith(BundleModule.RESOURCES_DIRECTORY)) continue;
            throw new ResouceTableException.ReferencesFileOutsideOfResException(moduleName, referencedFile, BundleModule.RESOURCES_DIRECTORY);
        }
        ImmutableSet nonReferencedFiles = ImmutableSet.copyOf((Collection)Sets.difference((Set)resFiles, referencedFiles));
        if (!nonReferencedFiles.isEmpty()) {
            throw new ResouceTableException.UnreferencedResourcesException(moduleName, (ImmutableSet<ZipPath>)nonReferencedFiles);
        }
        ImmutableSet nonExistingFiles = ImmutableSet.copyOf((Collection)Sets.difference(referencedFiles, (Set)resFiles));
        if (!nonExistingFiles.isEmpty()) {
            throw new ResouceTableException.ReferencesMissingFilesException(moduleName, (ImmutableSet<ZipPath>)nonExistingFiles);
        }
    }
}

