/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_GeneratedApks;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@AutoValue
public abstract class GeneratedApks {
    public abstract ImmutableList<ModuleSplit> getInstantApks();

    public abstract ImmutableList<ModuleSplit> getSplitApks();

    public abstract ImmutableList<ModuleSplit> getStandaloneApks();

    public int size() {
        return this.getInstantApks().size() + this.getSplitApks().size() + this.getStandaloneApks().size();
    }

    public Stream<ModuleSplit> getAllApksStream() {
        return Stream.of(this.getStandaloneApks(), this.getInstantApks(), this.getSplitApks()).flatMap(Collection::stream);
    }

    public static Builder builder() {
        return new AutoValue_GeneratedApks.Builder().setInstantApks((ImmutableList<ModuleSplit>)ImmutableList.of()).setSplitApks((ImmutableList<ModuleSplit>)ImmutableList.of()).setStandaloneApks((ImmutableList<ModuleSplit>)ImmutableList.of());
    }

    public static GeneratedApks fromModuleSplits(ImmutableList<ModuleSplit> moduleSplits) {
        Map groups = moduleSplits.stream().collect(Collectors.groupingBy(ModuleSplit::getSplitType, ImmutableList.toImmutableList()));
        return GeneratedApks.builder().setInstantApks((ImmutableList<ModuleSplit>)groups.getOrDefault((Object)ModuleSplit.SplitType.INSTANT, ImmutableList.of())).setSplitApks((ImmutableList<ModuleSplit>)groups.getOrDefault((Object)ModuleSplit.SplitType.SPLIT, ImmutableList.of())).setStandaloneApks((ImmutableList<ModuleSplit>)groups.getOrDefault((Object)ModuleSplit.SplitType.STANDALONE, ImmutableList.of())).build();
    }

    public static abstract class Builder {
        public abstract Builder setInstantApks(ImmutableList<ModuleSplit> var1);

        public abstract Builder setSplitApks(ImmutableList<ModuleSplit> var1);

        public abstract Builder setStandaloneApks(ImmutableList<ModuleSplit> var1);

        public abstract GeneratedApks build();
    }
}

