/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.AutoValue_ModuleConditions;
import com.android.tools.build.bundletool.model.DeviceFeatureCondition;
import com.android.tools.build.bundletool.utils.TargetingProtoUtils;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Optional;

@AutoValue
public abstract class ModuleConditions {
    public abstract ImmutableList<DeviceFeatureCondition> getDeviceFeatureConditions();

    public abstract Optional<Integer> getMinSdkVersion();

    public boolean isEmpty() {
        return this.toTargeting().equals(Targeting.ModuleTargeting.getDefaultInstance());
    }

    public static Builder builder() {
        return new AutoValue_ModuleConditions.Builder();
    }

    public Targeting.ModuleTargeting toTargeting() {
        Targeting.ModuleTargeting.Builder moduleTargeting = Targeting.ModuleTargeting.newBuilder();
        for (DeviceFeatureCondition condition : this.getDeviceFeatureConditions()) {
            moduleTargeting.addDeviceFeatureTargeting(Targeting.DeviceFeatureTargeting.newBuilder().setRequiredFeature(Targeting.DeviceFeature.newBuilder().setFeatureName(condition.getFeatureName())));
        }
        if (this.getMinSdkVersion().isPresent()) {
            moduleTargeting.setSdkVersionTargeting(TargetingProtoUtils.sdkVersionTargeting(TargetingProtoUtils.sdkVersionFrom(this.getMinSdkVersion().get())));
        }
        return moduleTargeting.build();
    }

    public static abstract class Builder {
        abstract ImmutableList.Builder<DeviceFeatureCondition> deviceFeatureConditionsBuilder();

        public Builder addDeviceFeatureCondition(DeviceFeatureCondition deviceFeatureCondition) {
            this.deviceFeatureConditionsBuilder().add((Object)deviceFeatureCondition);
            return this;
        }

        public abstract Builder setMinSdkVersion(int var1);

        public abstract ModuleConditions build();
    }
}

