/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Objects;
import shadow.bundletool.com.android.tools.r8.dex.DebugBytecodeWriter;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.dex.MixedSectionCollection;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugEventVisitor;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.ObjectToOffsetMapping;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;

public abstract class DexDebugEvent
extends DexItem {
    @Override
    public void collectIndexedItems(IndexedItemCollection collection) {
    }

    @Override
    public void collectMixedSectionItems(MixedSectionCollection collection) {
    }

    public abstract String toString();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract void writeOn(DebugBytecodeWriter var1, ObjectToOffsetMapping var2);

    public abstract void accept(DexDebugEventVisitor var1);

    public static class Default
    extends DexDebugEvent {
        final int value;

        Default(int value) {
            assert (value >= 10 && value <= 255);
            this.value = value;
        }

        @Override
        public void writeOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping) {
            writer.putByte(this.value);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        public int getPCDelta() {
            int adjustedOpcode = this.value - 10;
            return adjustedOpcode / 15;
        }

        public int getLineDelta() {
            int adjustedOpcode = this.value - 10;
            return -4 + adjustedOpcode % 15;
        }

        @Override
        public String toString() {
            return String.format("DEFAULT %d (dpc %d, dline %d)", this.value, this.getPCDelta(), this.getLineDelta());
        }

        @Override
        public int hashCode() {
            return 10 + this.value * 7;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof Default && this.value == ((Default)other).value;
        }
    }

    public static class SetInlineFrame
    extends DexDebugEvent {
        final DexMethod callee;
        final Position caller;

        SetInlineFrame(DexMethod callee, Position caller) {
            assert (callee != null);
            this.callee = callee;
            this.caller = caller;
        }

        @Override
        public void writeOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping) {
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return String.format("SET_INLINE_FRAME %s %s", this.callee, this.caller);
        }

        @Override
        public int hashCode() {
            return 31 * this.callee.hashCode() + Objects.hashCode(this.caller);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof SetInlineFrame)) {
                return false;
            }
            SetInlineFrame o = (SetInlineFrame)other;
            return this.callee == o.callee && Objects.equals(this.caller, o.caller);
        }
    }

    public static class SetFile
    extends DexDebugEvent {
        DexString fileName;

        SetFile(DexString fileName) {
            this.fileName = fileName;
        }

        @Override
        public void writeOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping) {
            writer.putByte(9);
            writer.putString(this.fileName);
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection collection) {
            this.fileName.collectIndexedItems(collection);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "SET_FILE " + this.fileName.toString();
        }

        @Override
        public int hashCode() {
            return 9 + this.fileName.hashCode() * 7;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof SetFile && this.fileName.equals(((SetFile)other).fileName);
        }
    }

    public static class RestartLocal
    extends DexDebugEvent {
        final int registerNum;

        RestartLocal(int registerNum) {
            this.registerNum = registerNum;
        }

        @Override
        public void writeOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping) {
            writer.putByte(6);
            writer.putUleb128(this.registerNum);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "RESTART_LOCAL " + this.registerNum;
        }

        @Override
        public int hashCode() {
            return 6 + this.registerNum * 7;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof RestartLocal && this.registerNum == ((RestartLocal)other).registerNum;
        }
    }

    public static class EndLocal
    extends DexDebugEvent {
        final int registerNum;

        EndLocal(int registerNum) {
            this.registerNum = registerNum;
        }

        @Override
        public void writeOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping) {
            writer.putByte(5);
            writer.putUleb128(this.registerNum);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "END_LOCAL " + this.registerNum;
        }

        @Override
        public int hashCode() {
            return 5 + this.registerNum * 7;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof EndLocal && this.registerNum == ((EndLocal)other).registerNum;
        }
    }

    public static class StartLocal
    extends DexDebugEvent {
        final int registerNum;
        final DexString name;
        final DexType type;
        final DexString signature;

        public StartLocal(int registerNum, DexString name, DexType type, DexString signature) {
            this.registerNum = registerNum;
            this.name = name;
            this.type = type;
            this.signature = signature;
        }

        public StartLocal(int registerNum, DebugLocalInfo local) {
            this(registerNum, local.name, local.type, local.signature);
        }

        @Override
        public void writeOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping) {
            writer.putByte(this.signature == null ? 3 : 4);
            writer.putUleb128(this.registerNum);
            writer.putString(this.name);
            writer.putType(this.type);
            if (this.signature != null) {
                writer.putString(this.signature);
            }
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection collection) {
            this.name.collectIndexedItems(collection);
            this.type.collectIndexedItems(collection);
            if (this.signature != null) {
                this.signature.collectIndexedItems(collection);
            }
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "START_LOCAL " + this.registerNum;
        }

        @Override
        public int hashCode() {
            return 3 + this.registerNum * 7 + this.name.hashCode() * 13 + this.type.hashCode() * 17 + Objects.hashCode(this.signature) * 19;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof StartLocal)) {
                return false;
            }
            StartLocal o = (StartLocal)other;
            if (this.registerNum != o.registerNum) {
                return false;
            }
            if (!this.name.equals(o.name)) {
                return false;
            }
            if (!this.type.equals(o.type)) {
                return false;
            }
            return Objects.equals(this.signature, o.signature);
        }
    }

    public static class AdvanceLine
    extends DexDebugEvent {
        final int delta;

        AdvanceLine(int delta) {
            this.delta = delta;
        }

        @Override
        public void writeOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping) {
            writer.putByte(2);
            writer.putSleb128(this.delta);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "ADVANCE_LINE " + this.delta;
        }

        @Override
        public int hashCode() {
            return 2 + this.delta * 7;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof AdvanceLine && this.delta == ((AdvanceLine)other).delta;
        }
    }

    public static class SetEpilogueBegin
    extends DexDebugEvent {
        SetEpilogueBegin() {
        }

        @Override
        public void writeOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping) {
            writer.putByte(8);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "SET_EPILOGUE_BEGIN";
        }

        @Override
        public int hashCode() {
            return 8;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof SetEpilogueBegin;
        }
    }

    public static class SetPrologueEnd
    extends DexDebugEvent {
        SetPrologueEnd() {
        }

        @Override
        public void writeOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping) {
            writer.putByte(7);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "SET_PROLOGUE_END";
        }

        @Override
        public int hashCode() {
            return 7;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof SetPrologueEnd;
        }
    }

    public static class AdvancePC
    extends DexDebugEvent {
        public final int delta;

        @Override
        public void writeOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping) {
            writer.putByte(1);
            writer.putUleb128(this.delta);
        }

        AdvancePC(int delta) {
            this.delta = delta;
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            assert (this.delta >= 0);
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "ADVANCE_PC " + this.delta;
        }

        @Override
        public int hashCode() {
            return 1 + this.delta * 7;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof AdvancePC && this.delta == ((AdvancePC)other).delta;
        }
    }
}

