/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.ApiLevelException;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeCustom;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaClass;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaDescriptor;

public class LambdaRewriter {
    private static final String METAFACTORY_TYPE_DESCR = "Ljava/lang/invoke/LambdaMetafactory;";
    private static final String CALLSITE_TYPE_DESCR = "Ljava/lang/invoke/CallSite;";
    private static final String LOOKUP_TYPE_DESCR = "Ljava/lang/invoke/MethodHandles$Lookup;";
    private static final String METHODTYPE_TYPE_DESCR = "Ljava/lang/invoke/MethodType;";
    private static final String METHODHANDLE_TYPE_DESCR = "Ljava/lang/invoke/MethodHandle;";
    private static final String SERIALIZABLE_TYPE_DESCR = "Ljava/io/Serializable;";
    private static final String SERIALIZED_LAMBDA_TYPE_DESCR = "Ljava/lang/invoke/SerializedLambda;";
    private static final String METAFACTORY_METHOD_NAME = "metafactory";
    private static final String METAFACTORY_ALT_METHOD_NAME = "altMetafactory";
    private static final String DESERIALIZE_LAMBDA_METHOD_NAME = "$deserializeLambda$";
    public static final String LAMBDA_CLASS_NAME_PREFIX = "-$$Lambda$";
    static final String EXPECTED_LAMBDA_METHOD_PREFIX = "lambda$";
    static final String LAMBDA_INSTANCE_FIELD_NAME = "INSTANCE";
    final IRConverter converter;
    final AppInfo appInfo;
    final DexItemFactory factory;
    final DexMethod metafactoryMethod;
    final DexMethod objectInitMethod;
    final DexMethod metafactoryAltMethod;
    final DexType serializableType;
    final DexString constructorName;
    final DexString classConstructorName;
    final DexString instanceFieldName;
    final DexString deserializeLambdaMethodName;
    final DexProto deserializeLambdaMethodProto;
    private final Map<DexCallSite, LambdaDescriptor> knownCallSites = new IdentityHashMap<DexCallSite, LambdaDescriptor>();
    private final Map<DexType, LambdaClass> knownLambdaClasses = new IdentityHashMap<DexType, LambdaClass>();

    public static boolean hasLambdaClassPrefix(DexType clazz) {
        return clazz.getName().startsWith(LAMBDA_CLASS_NAME_PREFIX);
    }

    public LambdaRewriter(IRConverter converter) {
        assert (converter != null);
        this.converter = converter;
        this.factory = converter.appInfo.dexItemFactory;
        this.appInfo = converter.appInfo;
        DexType metafactoryType = this.factory.createType(METAFACTORY_TYPE_DESCR);
        DexType callSiteType = this.factory.createType(CALLSITE_TYPE_DESCR);
        DexType lookupType = this.factory.createType(LOOKUP_TYPE_DESCR);
        DexType methodTypeType = this.factory.createType(METHODTYPE_TYPE_DESCR);
        DexType methodHandleType = this.factory.createType(METHODHANDLE_TYPE_DESCR);
        this.metafactoryMethod = this.factory.createMethod(metafactoryType, this.factory.createProto(callSiteType, lookupType, this.factory.stringType, methodTypeType, methodTypeType, methodHandleType, methodTypeType), this.factory.createString(METAFACTORY_METHOD_NAME));
        this.metafactoryAltMethod = this.factory.createMethod(metafactoryType, this.factory.createProto(callSiteType, lookupType, this.factory.stringType, methodTypeType, this.factory.objectArrayType), this.factory.createString(METAFACTORY_ALT_METHOD_NAME));
        this.constructorName = this.factory.createString("<init>");
        DexProto initProto = this.factory.createProto(this.factory.voidType, new DexType[0]);
        this.objectInitMethod = this.factory.createMethod(this.factory.objectType, initProto, this.constructorName);
        this.classConstructorName = this.factory.createString("<clinit>");
        this.instanceFieldName = this.factory.createString(LAMBDA_INSTANCE_FIELD_NAME);
        this.serializableType = this.factory.createType(SERIALIZABLE_TYPE_DESCR);
        this.deserializeLambdaMethodName = this.factory.createString(DESERIALIZE_LAMBDA_METHOD_NAME);
        this.deserializeLambdaMethodProto = this.factory.createProto(this.factory.objectType, this.factory.createType(SERIALIZED_LAMBDA_TYPE_DESCR));
    }

    public void desugarLambdas(DexEncodedMethod encodedMethod, IRCode code) {
        DexType currentType = encodedMethod.method.holder;
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator instructions = block.listIterator();
            while (instructions.hasNext()) {
                LambdaDescriptor descriptor;
                Instruction instruction = (Instruction)instructions.next();
                if (!instruction.isInvokeCustom() || (descriptor = this.inferLambdaDescriptor(instruction.asInvokeCustom().getCallSite())) == LambdaDescriptor.MATCH_FAILED) continue;
                LambdaClass lambdaClass = this.getOrCreateLambdaClass(descriptor, currentType);
                assert (lambdaClass != null);
                this.patchInstruction(lambdaClass, code, blocks, instructions);
            }
        }
    }

    public void removeLambdaDeserializationMethods(Iterable<DexProgramClass> classes) {
        block0: for (DexProgramClass clazz : classes) {
            DexEncodedMethod[] directMethods = clazz.directMethods();
            if (directMethods == null) continue;
            int methodCount = directMethods.length;
            for (int i = 0; i < methodCount; ++i) {
                DexEncodedMethod encoded = directMethods[i];
                DexMethod method = encoded.method;
                if (method.name != this.deserializeLambdaMethodName || method.proto != this.deserializeLambdaMethodProto) continue;
                assert (encoded.accessFlags.isStatic());
                assert (encoded.accessFlags.isPrivate());
                assert (encoded.accessFlags.isSynthetic());
                DexEncodedMethod[] newMethods = new DexEncodedMethod[methodCount - 1];
                System.arraycopy(directMethods, 0, newMethods, 0, i);
                System.arraycopy(directMethods, i + 1, newMethods, i, methodCount - i - 1);
                clazz.setDirectMethods(newMethods);
                continue block0;
            }
        }
    }

    public void adjustAccessibility() throws ApiLevelException {
        for (LambdaClass lambdaClass : this.knownLambdaClasses.values()) {
            lambdaClass.target.ensureAccessibility();
        }
    }

    public void synthesizeLambdaClasses(DexApplication.Builder<?> builder) throws ApiLevelException {
        for (LambdaClass lambdaClass : this.knownLambdaClasses.values()) {
            DexProgramClass synthesizedClass = lambdaClass.synthesizeLambdaClass();
            this.converter.optimizeSynthesizedClass(synthesizedClass);
            builder.addSynthesizedClass(synthesizedClass, lambdaClass.addToMainDexList.get());
        }
    }

    private LambdaDescriptor inferLambdaDescriptor(DexCallSite callSite) {
        LambdaDescriptor descriptor = this.getKnown(this.knownCallSites, callSite);
        return descriptor != null ? descriptor : this.putIfAbsent(this.knownCallSites, callSite, LambdaDescriptor.infer(this, callSite));
    }

    private boolean isInMainDexList(DexType type) {
        return this.converter.appInfo.isInMainDexList(type);
    }

    private LambdaClass getOrCreateLambdaClass(LambdaDescriptor descriptor, DexType accessedFrom) {
        DexType lambdaClassType = LambdaClass.createLambdaClassType(this, accessedFrom, descriptor);
        LambdaClass lambdaClass = this.getKnown(this.knownLambdaClasses, lambdaClassType);
        if (lambdaClass == null) {
            lambdaClass = this.putIfAbsent(this.knownLambdaClasses, lambdaClassType, new LambdaClass(this, accessedFrom, lambdaClassType, descriptor));
        }
        lambdaClass.addSynthesizedFrom(this.appInfo.definitionFor(accessedFrom).asProgramClass());
        if (this.isInMainDexList(accessedFrom)) {
            lambdaClass.addToMainDexList.set(true);
        }
        return lambdaClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> V getKnown(Map<K, V> map, K key) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> V putIfAbsent(Map<K, V> map, K key, V value) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            V known = map.get(key);
            if (known != null) {
                return known;
            }
            map.put(key, value);
            return value;
        }
    }

    private void patchInstruction(LambdaClass lambdaClass, IRCode code, ListIterator<BasicBlock> blocks, InstructionListIterator instructions) {
        assert (lambdaClass != null);
        assert (instructions != null);
        assert (instructions.peekPrevious().isInvokeCustom());
        InvokeCustom invoke = ((Instruction)instructions.previous()).asInvokeCustom();
        Value lambdaInstanceValue = invoke.outValue();
        if (lambdaInstanceValue == null) {
            lambdaInstanceValue = code.createValue(ValueType.OBJECT);
        }
        if (lambdaClass.isStateless()) {
            instructions.replaceCurrentInstruction(new StaticGet(MemberType.OBJECT, lambdaInstanceValue, lambdaClass.instanceField));
            return;
        }
        NewInstance newInstance = new NewInstance(lambdaClass.type, lambdaInstanceValue);
        instructions.replaceCurrentInstruction(newInstance);
        ArrayList<Value> arguments = new ArrayList<Value>();
        arguments.add(lambdaInstanceValue);
        arguments.addAll(invoke.arguments());
        InvokeDirect constructorCall = new InvokeDirect(lambdaClass.constructor, null, arguments);
        instructions.add(constructorCall);
        constructorCall.setPosition(newInstance.getPosition());
        if (!constructorCall.getBlock().hasCatchHandlers()) {
            return;
        }
        instructions.previous();
        assert (instructions.peekNext().isInvokeDirect());
        BasicBlock currentBlock = newInstance.getBlock();
        BasicBlock nextBlock = instructions.split(code, blocks);
        assert (!instructions.hasNext());
        nextBlock.copyCatchHandlers(code, blocks, currentBlock);
    }
}

