/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.DebugLocalsChange;
import shadow.bundletool.com.android.tools.r8.ir.code.Goto;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.JumpInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.BasicBlockInstructionsEquivalence;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InstructionEquivalence;
import shadow.bundletool.com.android.tools.r8.ir.optimize.MoveEliminator;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.LiveIntervals;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;

public class PeepholeOptimizer {
    public static void optimize(IRCode code, LinearScanRegisterAllocator allocator) {
        PeepholeOptimizer.removeIdenticalPredecessorBlocks(code, allocator);
        PeepholeOptimizer.removeRedundantInstructions(code, allocator);
        PeepholeOptimizer.shareIdenticalBlockSuffix(code, allocator);
        assert (code.isConsistentGraph());
    }

    private static void shareIdenticalBlockSuffix(IRCode code, RegisterAllocator allocator) {
        IdentityHashMap<BasicBlock, BasicBlock> newBlocks;
        Collection<BasicBlock> blocks = code.blocks;
        BasicBlock normalExit = null;
        ImmutableList<BasicBlock> normalExits = code.computeNormalExitBlocks();
        if (normalExits.size() > 1) {
            normalExit = new BasicBlock();
            normalExit.getPredecessors().addAll((Collection<BasicBlock>)normalExits);
            blocks = new ArrayList<BasicBlock>(code.blocks);
            blocks.add(normalExit);
        }
        do {
            int startNumberOfNewBlock = code.getHighestBlockNumber() + 1;
            newBlocks = new IdentityHashMap<BasicBlock, BasicBlock>();
            for (BasicBlock block : blocks) {
                InstructionEquivalence equivalence = new InstructionEquivalence(allocator);
                HashMap<Equivalence.Wrapper, List> lastInstructionToBlocks = new HashMap<Equivalence.Wrapper, List>();
                for (BasicBlock pred : block.getPredecessors()) {
                    if (pred.exit().isGoto() && pred.getSuccessors().size() == 1 && pred.getInstructions().size() > 1) {
                        LinkedList<Instruction> instructions = pred.getInstructions();
                        Instruction lastInstruction = (Instruction)instructions.get(instructions.size() - 2);
                        List value = lastInstructionToBlocks.computeIfAbsent(equivalence.wrap(lastInstruction), k -> new ArrayList());
                        value.add(pred);
                        continue;
                    }
                    if (!pred.exit().isReturn() || !pred.getSuccessors().isEmpty() || pred.getInstructions().size() <= 2) continue;
                    JumpInstruction lastInstruction = pred.exit();
                    List value = lastInstructionToBlocks.computeIfAbsent(equivalence.wrap(lastInstruction), k -> new ArrayList());
                    value.add(pred);
                }
                for (List predsWithSameLastInstruction : lastInstructionToBlocks.values()) {
                    if (predsWithSameLastInstruction.size() < 2) continue;
                    BasicBlock firstPred = (BasicBlock)predsWithSameLastInstruction.get(0);
                    int commonSuffixSize = firstPred.getInstructions().size();
                    for (int i = 1; i < predsWithSameLastInstruction.size(); ++i) {
                        BasicBlock pred = (BasicBlock)predsWithSameLastInstruction.get(i);
                        assert (pred.exit().isGoto() || pred.exit().isReturn());
                        commonSuffixSize = Math.min(commonSuffixSize, PeepholeOptimizer.sharedSuffixSize(firstPred, pred, allocator));
                    }
                    if (commonSuffixSize <= 1) continue;
                    int blockNumber = startNumberOfNewBlock + newBlocks.size();
                    BasicBlock newBlock = PeepholeOptimizer.createAndInsertBlockForSuffix(blockNumber, commonSuffixSize, predsWithSameLastInstruction, block == normalExit ? null : block);
                    newBlocks.put((BasicBlock)predsWithSameLastInstruction.get(0), newBlock);
                }
            }
            ListIterator<BasicBlock> blockIterator = code.listIterator();
            while (blockIterator.hasNext()) {
                BasicBlock block;
                block = blockIterator.next();
                if (!newBlocks.containsKey(block)) continue;
                blockIterator.add((BasicBlock)newBlocks.get(block));
            }
        } while (!(blocks = newBlocks.values()).isEmpty());
    }

    private static BasicBlock createAndInsertBlockForSuffix(int blockNumber, int suffixSize, List<BasicBlock> preds, BasicBlock successorBlock) {
        int offsetFromEnd;
        BasicBlock newBlock = BasicBlock.createGotoBlock(blockNumber);
        BasicBlock first = preds.get(0);
        assert (successorBlock != null && first.exit().isGoto() || successorBlock == null && first.exit().isReturn());
        int n = offsetFromEnd = successorBlock == null ? 0 : 1;
        if (successorBlock == null) {
            newBlock.getInstructions().removeLast();
        }
        InstructionListIterator from = first.listIterator(first.getInstructions().size() - offsetFromEnd);
        Int2ReferenceOpenHashMap newBlockEntryLocals = successorBlock == null || successorBlock.getLocalsAtEntry() == null ? new Int2ReferenceOpenHashMap() : new Int2ReferenceOpenHashMap(successorBlock.getLocalsAtEntry());
        boolean movedThrowingInstruction = false;
        for (int i = offsetFromEnd; i < suffixSize; ++i) {
            Instruction instruction = (Instruction)from.previous();
            movedThrowingInstruction = movedThrowingInstruction || instruction.instructionTypeCanThrow();
            newBlock.getInstructions().addFirst(instruction);
            instruction.setBlock(newBlock);
            if (!instruction.isDebugLocalsChange()) continue;
            DebugLocalsChange change = instruction.asDebugLocalsChange();
            IntIterator intIterator = change.getStarting().keySet().iterator();
            while (intIterator.hasNext()) {
                int starting = (Integer)intIterator.next();
                newBlockEntryLocals.remove(starting);
            }
            for (Int2ReferenceMap.Entry ending : change.getEnding().int2ReferenceEntrySet()) {
                newBlockEntryLocals.put(ending.getIntKey(), (Object)((DebugLocalInfo)ending.getValue()));
            }
        }
        if (movedThrowingInstruction && first.hasCatchHandlers()) {
            newBlock.transferCatchHandlers(first);
        }
        for (BasicBlock pred : preds) {
            LinkedList<Instruction> instructions = pred.getInstructions();
            for (int i = 0; i < suffixSize; ++i) {
                instructions.removeLast();
            }
            Goto jump = new Goto();
            jump.setBlock(pred);
            instructions.add(jump);
            newBlock.getPredecessors().add(pred);
            if (successorBlock != null) {
                pred.replaceSuccessor(successorBlock, newBlock);
                successorBlock.getPredecessors().remove(pred);
            } else {
                pred.getSuccessors().add(newBlock);
            }
            if (!movedThrowingInstruction) continue;
            pred.clearCatchHandlers();
        }
        newBlock.setLocalsAtEntry((Int2ReferenceMap<DebugLocalInfo>)newBlockEntryLocals);
        if (successorBlock != null) {
            newBlock.link(successorBlock);
        }
        return newBlock;
    }

    private static int sharedSuffixSize(BasicBlock block0, BasicBlock block1, RegisterAllocator allocator) {
        assert (block0.exit().isGoto() || block0.exit().isReturn());
        InstructionListIterator it0 = block0.listIterator(block0.getInstructions().size());
        InstructionListIterator it1 = block1.listIterator(block1.getInstructions().size());
        int suffixSize = 0;
        while (it0.hasPrevious() && it1.hasPrevious()) {
            Instruction i1;
            Instruction i0 = (Instruction)it0.previous();
            if (!i0.identicalAfterRegisterAllocation(i1 = (Instruction)it1.previous(), allocator)) {
                return suffixSize;
            }
            ++suffixSize;
        }
        return suffixSize;
    }

    private static void removeIdenticalPredecessorBlocks(IRCode code, RegisterAllocator allocator) {
        boolean changed;
        BasicBlockInstructionsEquivalence equivalence = new BasicBlockInstructionsEquivalence(code, allocator);
        do {
            changed = false;
            for (BasicBlock block : code.blocks) {
                HashMap<Equivalence.Wrapper, Integer> blockToIndex = new HashMap<Equivalence.Wrapper, Integer>();
                for (int predIndex = 0; predIndex < block.getPredecessors().size(); ++predIndex) {
                    BasicBlock pred = block.getPredecessors().get(predIndex);
                    if (pred.getInstructions().size() == 1) continue;
                    Equivalence.Wrapper wrapper = equivalence.wrap(pred);
                    if (blockToIndex.containsKey(wrapper)) {
                        changed = true;
                        int otherPredIndex = (Integer)blockToIndex.get(wrapper);
                        BasicBlock otherPred = block.getPredecessors().get(otherPredIndex);
                        pred.clearCatchHandlers();
                        pred.getInstructions().clear();
                        equivalence.clearComputedHash(pred);
                        for (BasicBlock succ : pred.getSuccessors()) {
                            succ.removePredecessor(pred);
                        }
                        pred.getSuccessors().clear();
                        pred.getSuccessors().add(otherPred);
                        assert (!otherPred.getPredecessors().contains(pred));
                        otherPred.getPredecessors().add(pred);
                        Goto exit = new Goto();
                        exit.setBlock(pred);
                        pred.getInstructions().add(exit);
                        continue;
                    }
                    blockToIndex.put(wrapper, predIndex);
                }
            }
        } while (changed);
    }

    private static void removeRedundantInstructions(IRCode code, LinearScanRegisterAllocator allocator) {
        for (BasicBlock block : code.blocks) {
            HashMap<Integer, ConstNumber> registerToNumber = new HashMap<Integer, ConstNumber>();
            MoveEliminator moveEliminator = new MoveEliminator(allocator);
            ListIterator iterator = block.getInstructions().listIterator();
            while (iterator.hasNext()) {
                int outRegister;
                Instruction current = (Instruction)iterator.next();
                if (moveEliminator.shouldBeEliminated(current)) {
                    iterator.remove();
                    continue;
                }
                if (current.outValue() == null || !current.outValue().needsRegister()) continue;
                Value outValue = current.outValue();
                int instructionNumber = current.getNumber();
                if (outValue.isConstant() && current.isConstNumber()) {
                    if (PeepholeOptimizer.constantSpilledAtDefinition(current.asConstNumber())) {
                        iterator.remove();
                        continue;
                    }
                    outRegister = allocator.getRegisterForValue(outValue, instructionNumber);
                    ConstNumber numberInRegister = (ConstNumber)registerToNumber.get(outRegister);
                    if (numberInRegister != null && numberInRegister.identicalNonValueNonPositionParts(current)) {
                        iterator.remove();
                        continue;
                    }
                    registerToNumber.put(outRegister, current.asConstNumber());
                    if (current.outType().isWide()) {
                        registerToNumber.remove(outRegister + 1);
                        continue;
                    }
                    PeepholeOptimizer.removeWideConstantCovering(registerToNumber, outRegister);
                    continue;
                }
                outRegister = allocator.getRegisterForValue(outValue, instructionNumber);
                for (int i = 0; i < outValue.requiredRegisters(); ++i) {
                    registerToNumber.remove(outRegister + i);
                }
                PeepholeOptimizer.removeWideConstantCovering(registerToNumber, outRegister);
            }
        }
    }

    private static void removeWideConstantCovering(Map<Integer, ConstNumber> registerToNumber, int register) {
        ConstNumber number = registerToNumber.get(register - 1);
        if (number != null && number.outType().isWide()) {
            registerToNumber.remove(register - 1);
        }
    }

    private static boolean constantSpilledAtDefinition(ConstNumber constNumber) {
        if (constNumber.outValue().isFixedRegisterValue()) {
            return false;
        }
        LiveIntervals definitionIntervals = constNumber.outValue().getLiveIntervals().getSplitCovering(constNumber.getNumber());
        return definitionIntervals.isSpilledAndRematerializable();
    }
}

