/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardClassNameList;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardClassType;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepRuleType;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardMemberRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardMemberType;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardTypeMatcher;

public class ProguardConfigurationUtils {
    public static ProguardKeepRule buildDefaultInitializerKeepRule(DexClass clazz) {
        ProguardKeepRule.Builder builder = ProguardKeepRule.builder();
        builder.setType(ProguardKeepRuleType.KEEP);
        builder.getModifiersBuilder().allowsObfuscation = true;
        builder.getModifiersBuilder().allowsOptimization = true;
        builder.getClassAccessFlags().setPublic();
        builder.setClassType(ProguardClassType.CLASS);
        ProguardClassNameList.Builder classNameListBuilder = ProguardClassNameList.builder();
        classNameListBuilder.addClassName(false, ProguardTypeMatcher.create(clazz.type));
        builder.setClassNames(classNameListBuilder.build());
        if (clazz.hasDefaultInitializer()) {
            ProguardMemberRule.Builder memberRuleBuilder = ProguardMemberRule.builder();
            memberRuleBuilder.setRuleType(ProguardMemberType.INIT);
            memberRuleBuilder.setName("<init>");
            memberRuleBuilder.setArguments((List<ProguardTypeMatcher>)ImmutableList.of());
            builder.getMemberRules().add(memberRuleBuilder.build());
        }
        return builder.build();
    }

    public static ProguardKeepRule buildDefaultMethodKeepRule(DexClass clazz, DexEncodedMethod method) {
        assert (clazz.type == method.method.holder);
        ProguardKeepRule.Builder builder = ProguardKeepRule.builder();
        builder.setType(ProguardKeepRuleType.KEEP);
        builder.getModifiersBuilder().allowsObfuscation = true;
        builder.getModifiersBuilder().allowsOptimization = true;
        builder.getClassAccessFlags().setPublic();
        builder.setClassType(ProguardClassType.INTERFACE);
        builder.setClassNames(ProguardClassNameList.singletonList(ProguardTypeMatcher.create(clazz.type)));
        ProguardMemberRule.Builder memberRuleBuilder = ProguardMemberRule.builder();
        memberRuleBuilder.setRuleType(ProguardMemberType.METHOD);
        memberRuleBuilder.setName(method.method.name.toString());
        memberRuleBuilder.setTypeMatcher(ProguardTypeMatcher.create(method.method.proto.returnType));
        List<ProguardTypeMatcher> arguments = Arrays.stream(method.method.proto.parameters.values).map(ProguardTypeMatcher::create).collect(Collectors.toList());
        memberRuleBuilder.setArguments(arguments);
        builder.getMemberRules().add(memberRuleBuilder.build());
        return builder.build();
    }
}

