/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.io.ApkPathManager;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.util.Optional;

public class StandaloneApkSerializer {
    public static final String STANDALONE_APKS_SUB_DIR = "standalones";
    private final ApkPathManager apkPathManager;
    private final ApkSerializerHelper apkSerializerHelper;

    public StandaloneApkSerializer(ApkPathManager apkPathManager, Aapt2Command aapt2Command, Optional<SigningConfiguration> signingConfig, Config.Compression compression) {
        this.apkPathManager = apkPathManager;
        this.apkSerializerHelper = new ApkSerializerHelper(aapt2Command, signingConfig, compression);
    }

    public Commands.ApkDescription writeToDisk(ModuleSplit standaloneSplit, Path outputDirectory) {
        ZipPath apkPath = this.apkPathManager.getApkPath(standaloneSplit);
        return this.writeToDiskInternal(standaloneSplit, outputDirectory, apkPath);
    }

    public Commands.ApkDescription writeToDiskAsUniversal(ModuleSplit standaloneSplit, Path outputDirectory) {
        return this.writeToDiskInternal(standaloneSplit, outputDirectory, ZipPath.create("universal.apk"));
    }

    @VisibleForTesting
    Commands.ApkDescription writeToDiskInternal(ModuleSplit standaloneSplit, Path outputDirectory, ZipPath apkPath) {
        this.apkSerializerHelper.writeToZipFile(standaloneSplit, outputDirectory.resolve(apkPath.toString()));
        return Commands.ApkDescription.newBuilder().setPath(apkPath.toString()).setStandaloneApkMetadata(Commands.StandaloneApkMetadata.newBuilder().addAllFusedModuleName((Iterable<String>)standaloneSplit.getAndroidManifest().getFusedModuleNames())).setTargeting(standaloneSplit.getApkTargeting()).build();
    }
}

