/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils;

import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class ConcurrencyUtils {
    public static <T> ImmutableList<T> waitForAll(Iterable<ListenableFuture<T>> futures) {
        return ImmutableList.copyOf((Collection)((Collection)ConcurrencyUtils.waitFor(Futures.allAsList(futures))));
    }

    public static <K, V> ImmutableMap<K, V> waitForAll(Map<K, ListenableFuture<V>> futures) {
        ImmutableMap.Builder finishedMap = ImmutableMap.builder();
        for (Map.Entry<K, ListenableFuture<V>> entry : futures.entrySet()) {
            finishedMap.put(entry.getKey(), ConcurrencyUtils.waitFor((Future)entry.getValue()));
        }
        return finishedMap.build();
    }

    public static <T> T waitFor(Future<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw new UncheckedIOException(e.getCause().getMessage(), (IOException)e.getCause());
            }
            if (e.getCause() instanceof UncheckedIOException) {
                throw new UncheckedIOException(e.getCause().getMessage(), ((UncheckedIOException)e.getCause()).getCause());
            }
            if (e.getCause() instanceof CommandExecutionException) {
                throw new CommandExecutionException(e.getCause().getMessage(), e.getCause());
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("One operation was interrupted.", e);
        }
    }

    private ConcurrencyUtils() {
    }
}

