/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils;

import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.utils.OsPlatform;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Stream;

public final class SdkToolsLocator {
    private static final String ADB_GLOB = "glob:**/platform-tools/{adb,adb.exe}";
    private static final BiPredicate<Path, BasicFileAttributes> AAPT2_MATCHER = (file, attrs) -> file.getFileName().toString().matches("aapt2(\\.exe)?");
    private final PathMatcher adbPathMatcher;

    public SdkToolsLocator() {
        this(FileSystems.getDefault());
    }

    SdkToolsLocator(FileSystem fileSystem) {
        this.adbPathMatcher = fileSystem.getPathMatcher(ADB_GLOB);
    }

    public Optional<Path> extractAapt2(Path tempDir) {
        Path aapt2;
        String osDir = SdkToolsLocator.getOsSpecificJarDirectory();
        URL osDirUrl = SdkToolsLocator.class.getResource(osDir);
        if (osDirUrl == null || !"jar".equals(osDirUrl.getProtocol())) {
            return Optional.empty();
        }
        try {
            Path outputDir = tempDir.resolve("output");
            this.extractFilesFromJar(outputDir, osDirUrl, osDir);
            try (Stream<Path> aapt2Binaries = Files.find(outputDir, 3, AAPT2_MATCHER, new FileVisitOption[0]);){
                aapt2 = (Path)aapt2Binaries.collect(MoreCollectors.onlyElement());
            }
        }
        catch (NoSuchElementException e) {
            throw new CommandExecutionException("Unable to locate aapt2 inside jar.", e);
        }
        catch (IOException | URISyntaxException e) {
            throw new CommandExecutionException("Unable to extract aapt2 from jar.", e);
        }
        Preconditions.checkState((boolean)Files.exists(aapt2, new LinkOption[0]));
        try {
            aapt2.toFile().setExecutable(true);
        }
        catch (SecurityException e) {
            throw new CommandExecutionException("Unable to make aapt2 executable. This may be a permission issue. If it persists, consider passing the path to aapt2 using the flag --aapt2.", e);
        }
        return Optional.of(aapt2);
    }

    private void extractFilesFromJar(Path outputDir, URL directoryUrl, String startDir) throws IOException, URISyntaxException {
        try (FileSystem fs = FileSystems.newFileSystem(directoryUrl.toURI(), ImmutableMap.of());
             Stream<Path> paths = Files.walk(fs.getPath(startDir, new String[0]), new FileVisitOption[0]);){
            for (Path path : (ImmutableList)paths.collect(ImmutableList.toImmutableList())) {
                String pathStr = path.toString();
                InputStream is = SdkToolsLocator.sanitize(this.getClass().getResourceAsStream(pathStr));
                Throwable throwable = null;
                try {
                    if (is.available() == 0) continue;
                    Path target = outputDir.resolve(pathStr.replaceFirst("^/", ""));
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(is, target, new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    private static String getOsSpecificJarDirectory() {
        switch (OsPlatform.getCurrentPlatform()) {
            case WINDOWS: {
                return "/windows";
            }
            case MACOS: {
                return "/macos";
            }
            case LINUX: {
                return "/linux";
            }
            case OTHER: {
                return "/linux";
            }
        }
        throw new IllegalStateException();
    }

    private static InputStream sanitize(InputStream is) throws IOException {
        try {
            is.available();
            return is;
        }
        catch (NullPointerException e) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Path> locateAdb(Path sdkDir) {
        Path platformToolsDir = sdkDir.resolve("platform-tools");
        if (!Files.isDirectory(platformToolsDir, new LinkOption[0])) {
            return Optional.empty();
        }
        try (Stream<Path> pathStream = Files.find(platformToolsDir, 1, (path, attributes) -> this.adbPathMatcher.matches((Path)path) && Files.isExecutable(path), new FileVisitOption[0]);){
            Optional<Path> optional = pathStream.findFirst();
            return optional;
        }
        catch (IOException e) {
            throw CommandExecutionException.builder().withCause(e).withMessage("Error while trying to locate adb in SDK dir '%s'.", sdkDir).build();
        }
    }
}

