/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import com.google.common.base.Equivalence;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.KeyedDexItem;
import shadow.bundletool.com.android.tools.r8.graph.PresortedComparable;
import shadow.bundletool.com.android.tools.r8.optimize.InvokeSingleTargetExtractor;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.utils.FieldSignatureEquivalence;
import shadow.bundletool.com.android.tools.r8.utils.MethodSignatureEquivalence;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class SimpleClassMerger {
    private final DexApplication application;
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final GraphLense graphLense;
    private final GraphLense.Builder renamedMembersLense = GraphLense.builder();
    private final Map<DexType, DexType> mergedClasses = new IdentityHashMap<DexType, DexType>();
    private final Timing timing;
    private Collection<DexMethod> invokes;
    private int numberOfMerges = 0;

    public SimpleClassMerger(DexApplication application, Enqueuer.AppInfoWithLiveness appInfo, GraphLense graphLense, Timing timing) {
        this.application = application;
        this.appInfo = appInfo;
        this.graphLense = graphLense;
        this.timing = timing;
    }

    private boolean isMergeCandidate(DexProgramClass clazz) {
        return !clazz.isLibraryClass() && !this.appInfo.instantiatedTypes.contains(clazz.type) && !this.appInfo.isPinned(clazz.type) && clazz.type.getSingleSubtype() != null;
    }

    private void addProgramMethods(Set<Equivalence.Wrapper<DexMethod>> set, DexMethod method, Equivalence<DexMethod> equivalence) {
        DexClass definition = this.appInfo.definitionFor(method.holder);
        if (definition != null && definition.isProgramClass()) {
            set.add((Equivalence.Wrapper<DexMethod>)equivalence.wrap((Object)method));
        }
    }

    private Collection<DexMethod> getInvokes() {
        if (this.invokes == null) {
            HashSet filteredInvokes = new HashSet();
            MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
            this.appInfo.targetedMethods.forEach(m -> this.addProgramMethods(filteredInvokes, (DexMethod)m, equivalence));
            this.invokes = filteredInvokes.stream().map(Equivalence.Wrapper::get).filter(this::removeNonProgram).collect(Collectors.toList());
        }
        return this.invokes;
    }

    private boolean isProgramClass(DexType type) {
        DexClass clazz;
        if (type.isArrayType()) {
            type = type.toBaseType(this.appInfo.dexItemFactory);
        }
        return type.isClassType() && (clazz = this.appInfo.definitionFor(type)) != null && clazz.isProgramClass();
    }

    private boolean removeNonProgram(DexMethod dexMethod) {
        for (DexType type : dexMethod.proto.parameters.values) {
            if (!this.isProgramClass(type)) continue;
            return true;
        }
        return this.isProgramClass(dexMethod.proto.returnType);
    }

    public GraphLense run() {
        this.timing.begin("merge");
        GraphLense mergingGraphLense = this.mergeClasses(this.graphLense);
        this.timing.end();
        this.timing.begin("fixup");
        GraphLense result = new TreeFixer().fixupTypeReferences(mergingGraphLense);
        this.timing.end();
        return result;
    }

    private GraphLense mergeClasses(GraphLense graphLense) {
        for (DexProgramClass clazz : this.application.classes()) {
            if (!this.isMergeCandidate(clazz)) continue;
            DexClass targetClass = this.appInfo.definitionFor(clazz.type.getSingleSubtype());
            if (this.appInfo.isPinned(targetClass.type) || this.mergedClasses.containsKey(targetClass.type) || clazz.hasClassInitializer() && targetClass.hasClassInitializer() || new CollisionDetector(clazz.type, targetClass.type, this.getInvokes(), this.mergedClasses).mayCollide()) continue;
            boolean bl = new ClassMerger(clazz, targetClass).merge();
        }
        return this.renamedMembersLense.build(this.application.dexItemFactory, graphLense);
    }

    public Collection<DexType> getRemovedClasses() {
        return Collections.unmodifiableCollection(this.mergedClasses.keySet());
    }

    private static class CollisionDetector {
        private static final int NOT_FOUND = Integer.MIN_VALUE;
        private final Map<DexString, Int2IntMap> seenPositions = new IdentityHashMap<DexString, Int2IntMap>();
        private final Reference2IntMap<DexProto> targetProtoCache;
        private final Reference2IntMap<DexProto> sourceProtoCache;
        private final DexType source;
        private final DexType target;
        private final Collection<DexMethod> invokes;
        private final Map<DexType, DexType> substituions;

        private CollisionDetector(DexType source, DexType target, Collection<DexMethod> invokes, Map<DexType, DexType> substitutions) {
            this.source = source;
            this.target = target;
            this.invokes = invokes;
            this.substituions = substitutions;
            this.targetProtoCache = new Reference2IntOpenHashMap(invokes.size() / 2);
            this.targetProtoCache.defaultReturnValue(Integer.MIN_VALUE);
            this.sourceProtoCache = new Reference2IntOpenHashMap(invokes.size() / 2);
            this.sourceProtoCache.defaultReturnValue(Integer.MIN_VALUE);
        }

        boolean mayCollide() {
            this.fillSeenPositions(this.invokes);
            if (this.seenPositions.isEmpty()) {
                return false;
            }
            for (DexMethod method : this.invokes) {
                int arity;
                int previous;
                Int2IntMap positionsMap = this.seenPositions.get(method.name);
                if (positionsMap == null || (previous = positionsMap.get(arity = method.getArity())) == Integer.MIN_VALUE) continue;
                assert (previous != 0);
                int positions = this.computePositionsFor(method.proto, this.source, this.sourceProtoCache, this.substituions);
                if ((positions & previous) == 0) continue;
                return true;
            }
            return false;
        }

        private void fillSeenPositions(Collection<DexMethod> invokes) {
            for (DexMethod method : invokes) {
                DexType[] parameters = method.proto.parameters.values;
                int arity = parameters.length;
                int positions = this.computePositionsFor(method.proto, this.target, this.targetProtoCache, this.substituions);
                if (positions == 0) continue;
                Int2IntMap positionsMap = this.seenPositions.computeIfAbsent(method.name, k -> {
                    Int2IntOpenHashMap result = new Int2IntOpenHashMap();
                    result.defaultReturnValue(Integer.MIN_VALUE);
                    return result;
                });
                int value = 0;
                int previous = positionsMap.get(arity);
                if (previous != Integer.MIN_VALUE) {
                    value = previous;
                }
                positionsMap.put(arity, value |= positions);
            }
        }

        private int computePositionsFor(DexProto proto, DexType type, Reference2IntMap<DexProto> cache, Map<DexType, DexType> substitutions) {
            int result = cache.getInt((Object)proto);
            if (result != Integer.MIN_VALUE) {
                return result;
            }
            result = 0;
            int bitsUsed = 0;
            int accumulator = 0;
            for (DexType aType : proto.parameters.values) {
                if (substitutions != null) {
                    while (substitutions.containsKey(aType)) {
                        aType = substitutions.get(aType);
                    }
                }
                accumulator <<= 1;
                ++bitsUsed;
                if (aType == type) {
                    accumulator |= 1;
                }
                if (bitsUsed != 31) continue;
                result |= accumulator;
                accumulator = 0;
                bitsUsed = 0;
            }
            DexType returnType = proto.returnType;
            if (substitutions != null) {
                while (substitutions.containsKey(returnType)) {
                    returnType = substitutions.get(returnType);
                }
            }
            accumulator <<= 1;
            if (returnType == type) {
                accumulator |= 1;
            }
            cache.put((Object)proto, result |= accumulator);
            return result;
        }
    }

    private class TreeFixer {
        private final GraphLense.Builder lense = GraphLense.builder();
        Map<DexProto, DexProto> protoFixupCache = new IdentityHashMap<DexProto, DexProto>();

        private TreeFixer() {
        }

        private GraphLense fixupTypeReferences(GraphLense graphLense) {
            for (DexProgramClass clazz : SimpleClassMerger.this.appInfo.classes()) {
                clazz.setDirectMethods(this.substituteTypesIn(clazz.directMethods()));
                clazz.setVirtualMethods(this.substituteTypesIn(clazz.virtualMethods()));
                clazz.setVirtualMethods(this.removeDupes(clazz.virtualMethods()));
                clazz.setStaticFields(this.substituteTypesIn(clazz.staticFields()));
                clazz.setInstanceFields(this.substituteTypesIn(clazz.instanceFields()));
            }
            for (DexType type : SimpleClassMerger.this.mergedClasses.keySet()) {
                DexType fixed = this.fixupType(type);
                this.lense.map(type, fixed);
            }
            return this.lense.build(((SimpleClassMerger)SimpleClassMerger.this).application.dexItemFactory, graphLense);
        }

        private DexEncodedMethod[] removeDupes(DexEncodedMethod[] methods) {
            if (methods == null) {
                return null;
            }
            IdentityHashMap<DexMethod, DexEncodedMethod> filtered = new IdentityHashMap<DexMethod, DexEncodedMethod>();
            for (DexEncodedMethod method : methods) {
                DexEncodedMethod previous = filtered.put(method.method, method);
                if (previous == null || previous.accessFlags.isBridge()) continue;
                if (!method.accessFlags.isBridge()) {
                    throw new CompilationError("Class merging produced invalid result on: " + previous.toSourceString());
                }
                filtered.put(previous.method, previous);
            }
            if (filtered.size() == methods.length) {
                return methods;
            }
            return filtered.values().toArray(new DexEncodedMethod[filtered.size()]);
        }

        private DexEncodedMethod[] substituteTypesIn(DexEncodedMethod[] methods) {
            if (methods == null) {
                return null;
            }
            for (int i = 0; i < methods.length; ++i) {
                DexEncodedMethod encodedMethod = methods[i];
                DexMethod method = encodedMethod.method;
                DexProto newProto = this.getUpdatedProto(method.proto);
                DexType newHolder = this.fixupType(method.holder);
                DexMethod newMethod = ((SimpleClassMerger)SimpleClassMerger.this).application.dexItemFactory.createMethod(newHolder, newProto, method.name);
                if (newMethod == encodedMethod.method) continue;
                this.lense.map(encodedMethod.method, newMethod);
                methods[i] = encodedMethod.toTypeSubstitutedMethod(newMethod);
            }
            return methods;
        }

        private DexEncodedField[] substituteTypesIn(DexEncodedField[] fields) {
            if (fields == null) {
                return null;
            }
            for (int i = 0; i < fields.length; ++i) {
                DexEncodedField encodedField = fields[i];
                DexField field = encodedField.field;
                DexType newType = this.fixupType(field.type);
                DexType newHolder = this.fixupType(field.clazz);
                DexField newField = ((SimpleClassMerger)SimpleClassMerger.this).application.dexItemFactory.createField(newHolder, newType, field.name);
                if (newField == encodedField.field) continue;
                this.lense.map(encodedField.field, newField);
                fields[i] = encodedField.toTypeSubstitutedField(newField);
            }
            return fields;
        }

        private DexProto getUpdatedProto(DexProto proto) {
            DexProto result = this.protoFixupCache.get(proto);
            if (result == null) {
                DexType returnType = this.fixupType(proto.returnType);
                DexType[] arguments = this.fixupTypes(proto.parameters.values);
                result = ((SimpleClassMerger)SimpleClassMerger.this).application.dexItemFactory.createProto(returnType, arguments);
                this.protoFixupCache.put(proto, result);
            }
            return result;
        }

        private DexType fixupType(DexType type) {
            if (type.isArrayType()) {
                DexType fixed;
                DexType base = type.toBaseType(((SimpleClassMerger)SimpleClassMerger.this).application.dexItemFactory);
                if (base == (fixed = this.fixupType(base))) {
                    return type;
                }
                return type.replaceBaseType(fixed, ((SimpleClassMerger)SimpleClassMerger.this).application.dexItemFactory);
            }
            while (SimpleClassMerger.this.mergedClasses.containsKey(type)) {
                type = (DexType)SimpleClassMerger.this.mergedClasses.get(type);
            }
            return type;
        }

        private DexType[] fixupTypes(DexType[] types) {
            DexType[] result = new DexType[types.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.fixupType(types[i]);
            }
            return result;
        }
    }

    private class ClassMerger {
        private static final String CONSTRUCTOR_NAME = "constructor";
        private final DexClass source;
        private final DexClass target;
        private final Map<DexEncodedMethod, DexEncodedMethod> deferredRenamings = new HashMap<DexEncodedMethod, DexEncodedMethod>();
        private boolean abortMerge = false;

        private ClassMerger(DexClass source, DexClass target) {
            this.source = source;
            this.target = target;
        }

        public boolean merge() {
            if (this.source.getEnclosingMethod() != null || !this.source.getInnerClasses().isEmpty() || this.target.getEnclosingMethod() != null || !this.target.getInnerClasses().isEmpty()) {
                return false;
            }
            HashSet existingMethods = new HashSet();
            this.addAll(existingMethods, this.target.directMethods(), MethodSignatureEquivalence.get());
            this.addAll(existingMethods, this.target.virtualMethods(), MethodSignatureEquivalence.get());
            Collection mergedDirectMethods = this.mergeItems(Iterators.transform((Iterator)Iterators.forArray((Object[])this.source.directMethods()), this::renameConstructors), this.target.directMethods(), MethodSignatureEquivalence.get(), existingMethods, this::renameMethod);
            Object methods = Iterators.forArray((Object[])this.source.virtualMethods());
            if (this.source.accessFlags.isInterface()) {
                methods = Iterators.transform((Iterator)methods, this::filterShadowedInterfaceMethods);
            }
            Collection mergedVirtualMethods = this.mergeItems((Iterator)methods, this.target.virtualMethods(), MethodSignatureEquivalence.get(), existingMethods, this::abortOnNonAbstract);
            if (this.abortMerge) {
                return false;
            }
            HashSet existingFields = new HashSet();
            this.addAll(existingFields, this.target.instanceFields(), FieldSignatureEquivalence.get());
            this.addAll(existingFields, this.target.staticFields(), FieldSignatureEquivalence.get());
            Collection mergedStaticFields = this.mergeItems((Iterator)Iterators.forArray((Object[])this.source.staticFields()), this.target.staticFields(), FieldSignatureEquivalence.get(), existingFields, this::renameField);
            Collection mergedInstanceFields = this.mergeItems((Iterator)Iterators.forArray((Object[])this.source.instanceFields()), this.target.instanceFields(), FieldSignatureEquivalence.get(), existingFields, this::renameField);
            Set<DexType> interfaces = this.mergeArrays(this.target.interfaces.values, this.source.interfaces.values);
            if (this.source.isInterface()) {
                interfaces.remove(this.source.type);
            } else {
                assert (!this.target.isInterface());
                this.target.superType = this.source.superType;
            }
            this.target.interfaces = interfaces.isEmpty() ? DexTypeList.empty() : new DexTypeList(interfaces.toArray(new DexType[interfaces.size()]));
            this.target.setDirectMethods(mergedDirectMethods.toArray(new DexEncodedMethod[mergedDirectMethods.size()]));
            this.target.setVirtualMethods(mergedVirtualMethods.toArray(new DexEncodedMethod[mergedVirtualMethods.size()]));
            this.target.setStaticFields(mergedStaticFields.toArray(new DexEncodedField[mergedStaticFields.size()]));
            this.target.setInstanceFields(mergedInstanceFields.toArray(new DexEncodedField[mergedInstanceFields.size()]));
            this.source.superType = ((SimpleClassMerger)SimpleClassMerger.this).application.dexItemFactory.objectType;
            this.source.setDirectMethods(null);
            this.source.setVirtualMethods(null);
            this.source.setInstanceFields(null);
            this.source.setStaticFields(null);
            this.source.interfaces = DexTypeList.empty();
            SimpleClassMerger.this.mergedClasses.put(this.source.type, this.target.type);
            this.deferredRenamings.forEach((from, to) -> SimpleClassMerger.this.renamedMembersLense.map(from.method, to.method));
            return true;
        }

        private DexEncodedMethod filterShadowedInterfaceMethods(DexEncodedMethod m) {
            DexEncodedMethod actual = SimpleClassMerger.this.appInfo.resolveMethod(this.target.type, m.method).asSingleTarget();
            assert (actual != null);
            if (actual != m) {
                this.deferredRenamings.put(m, actual);
                return null;
            }
            assert (this.target.accessFlags.isAbstract());
            return m;
        }

        private <T extends KeyedDexItem<S>, S extends PresortedComparable<S>> void addAll(Collection<Equivalence.Wrapper<S>> collection, T[] items, Equivalence<S> equivalence) {
            for (T item : items) {
                collection.add(equivalence.wrap(((KeyedDexItem)item).getKey()));
            }
        }

        private <T> Set<T> mergeArrays(T[] one, T[] other) {
            LinkedHashSet merged = new LinkedHashSet();
            Collections.addAll(merged, one);
            Collections.addAll(merged, other);
            return merged;
        }

        private <T extends PresortedComparable<T>, S extends KeyedDexItem<T>> Collection<S> mergeItems(Iterator<S> fromItems, S[] toItems, Equivalence<T> equivalence, Set<Equivalence.Wrapper<T>> existing, BiFunction<S, S, S> onConflict) {
            HashMap<Equivalence.Wrapper, S> methods = new HashMap<Equivalence.Wrapper, S>();
            for (S item : toItems) {
                methods.put(equivalence.wrap(((KeyedDexItem)item).getKey()), item);
            }
            this.addNonShadowed(fromItems, methods, equivalence, existing, onConflict);
            return methods.values();
        }

        private <T extends PresortedComparable<T>, S extends KeyedDexItem<T>> void addNonShadowed(Iterator<S> items, HashMap<Equivalence.Wrapper<T>, S> map, Equivalence<T> equivalence, Set<Equivalence.Wrapper<T>> existing, BiFunction<S, S, S> onConflict) {
            while (items.hasNext()) {
                KeyedDexItem item = (KeyedDexItem)items.next();
                if (item == null) continue;
                Equivalence.Wrapper wrapped = equivalence.wrap(item.getKey());
                if (existing.contains(wrapped)) {
                    KeyedDexItem resolved = (KeyedDexItem)onConflict.apply((KeyedDexItem)map.get(wrapped), item);
                    wrapped = equivalence.wrap(resolved.getKey());
                    map.put(wrapped, resolved);
                    continue;
                }
                map.put(wrapped, item);
            }
        }

        private DexString makeMergedName(String nameString, DexType holder) {
            return ((SimpleClassMerger)SimpleClassMerger.this).application.dexItemFactory.createString(nameString + "$" + holder.toSourceString().replace('.', '$'));
        }

        private DexEncodedMethod abortOnNonAbstract(DexEncodedMethod existing, DexEncodedMethod method) {
            if (existing == null) {
                this.abortMerge = true;
                return method;
            }
            if (method.accessFlags.isAbstract()) {
                this.deferredRenamings.put(method, existing);
                return existing;
            }
            if (existing.accessFlags.isBridge()) {
                InvokeSingleTargetExtractor extractor = new InvokeSingleTargetExtractor();
                existing.getCode().registerInstructionsReferences(extractor);
                if (extractor.getTarget() != method.method) {
                    this.abortMerge = true;
                }
                return method;
            }
            this.abortMerge = true;
            return existing;
        }

        private DexEncodedMethod renameConstructors(DexEncodedMethod method) {
            if (!method.isInstanceInitializer()) {
                return method;
            }
            DexType holder = method.method.holder;
            DexEncodedMethod result = method.toRenamedMethod(this.makeMergedName(CONSTRUCTOR_NAME, holder), ((SimpleClassMerger)SimpleClassMerger.this).application.dexItemFactory);
            result.markForceInline();
            this.deferredRenamings.put(method, result);
            result.accessFlags.unsetConstructor();
            result.accessFlags.unsetPublic();
            result.accessFlags.unsetProtected();
            result.accessFlags.setPrivate();
            return result;
        }

        private DexEncodedMethod renameMethod(DexEncodedMethod existing, DexEncodedMethod method) {
            assert (!method.accessFlags.isConstructor());
            DexType holder = method.method.holder;
            String name = method.method.name.toSourceString();
            DexEncodedMethod result = method.toRenamedMethod(this.makeMergedName(name, holder), ((SimpleClassMerger)SimpleClassMerger.this).application.dexItemFactory);
            SimpleClassMerger.this.renamedMembersLense.map(method.method, result.method);
            return result;
        }

        private DexEncodedField renameField(DexEncodedField existing, DexEncodedField field) {
            DexString oldName = field.field.name;
            DexType holder = field.field.clazz;
            DexEncodedField result = field.toRenamedField(this.makeMergedName(oldName.toSourceString(), holder), ((SimpleClassMerger)SimpleClassMerger.this).application.dexItemFactory);
            SimpleClassMerger.this.renamedMembersLense.map(field.field, result.field);
            return result;
        }
    }
}

