
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Devices;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_GetSizeCommand extends GetSizeCommand {

  private final Path apksArchivePath;
  private final Devices.DeviceSpec deviceSpec;
  private final Optional<ImmutableSet<String>> modules;
  private final ImmutableSet<GetSizeCommand.Dimension> dimensions;
  private final boolean instant;

  private AutoValue_GetSizeCommand(
      Path apksArchivePath,
      Devices.DeviceSpec deviceSpec,
      Optional<ImmutableSet<String>> modules,
      ImmutableSet<GetSizeCommand.Dimension> dimensions,
      boolean instant) {
    this.apksArchivePath = apksArchivePath;
    this.deviceSpec = deviceSpec;
    this.modules = modules;
    this.dimensions = dimensions;
    this.instant = instant;
  }

  @Override
  public Path getApksArchivePath() {
    return apksArchivePath;
  }

  @Override
  public Devices.DeviceSpec getDeviceSpec() {
    return deviceSpec;
  }

  @Override
  public Optional<ImmutableSet<String>> getModules() {
    return modules;
  }

  @Override
  public ImmutableSet<GetSizeCommand.Dimension> getDimensions() {
    return dimensions;
  }

  @Override
  public boolean getInstant() {
    return instant;
  }

  @Override
  public String toString() {
    return "GetSizeCommand{"
        + "apksArchivePath=" + apksArchivePath + ", "
        + "deviceSpec=" + deviceSpec + ", "
        + "modules=" + modules + ", "
        + "dimensions=" + dimensions + ", "
        + "instant=" + instant
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GetSizeCommand) {
      GetSizeCommand that = (GetSizeCommand) o;
      return (this.apksArchivePath.equals(that.getApksArchivePath()))
           && (this.deviceSpec.equals(that.getDeviceSpec()))
           && (this.modules.equals(that.getModules()))
           && (this.dimensions.equals(that.getDimensions()))
           && (this.instant == that.getInstant());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.apksArchivePath.hashCode();
    h *= 1000003;
    h ^= this.deviceSpec.hashCode();
    h *= 1000003;
    h ^= this.modules.hashCode();
    h *= 1000003;
    h ^= this.dimensions.hashCode();
    h *= 1000003;
    h ^= this.instant ? 1231 : 1237;
    return h;
  }

  static final class Builder extends GetSizeCommand.Builder {
    private Path apksArchivePath;
    private Devices.DeviceSpec deviceSpec;
    private Optional<ImmutableSet<String>> modules = Optional.empty();
    private ImmutableSet<GetSizeCommand.Dimension> dimensions;
    private Boolean instant;
    Builder() {
    }
    @Override
    public GetSizeCommand.Builder setApksArchivePath(Path apksArchivePath) {
      if (apksArchivePath == null) {
        throw new NullPointerException("Null apksArchivePath");
      }
      this.apksArchivePath = apksArchivePath;
      return this;
    }
    @Override
    public GetSizeCommand.Builder setDeviceSpec(Devices.DeviceSpec deviceSpec) {
      if (deviceSpec == null) {
        throw new NullPointerException("Null deviceSpec");
      }
      this.deviceSpec = deviceSpec;
      return this;
    }
    @Override
    public GetSizeCommand.Builder setModules(ImmutableSet<String> modules) {
      if (modules == null) {
        throw new NullPointerException("Null modules");
      }
      this.modules = Optional.of(modules);
      return this;
    }
    @Override
    public GetSizeCommand.Builder setDimensions(ImmutableSet<GetSizeCommand.Dimension> dimensions) {
      if (dimensions == null) {
        throw new NullPointerException("Null dimensions");
      }
      this.dimensions = dimensions;
      return this;
    }
    @Override
    public GetSizeCommand.Builder setInstant(boolean instant) {
      this.instant = instant;
      return this;
    }
    @Override
    public GetSizeCommand build() {
      String missing = "";
      if (this.apksArchivePath == null) {
        missing += " apksArchivePath";
      }
      if (this.deviceSpec == null) {
        missing += " deviceSpec";
      }
      if (this.dimensions == null) {
        missing += " dimensions";
      }
      if (this.instant == null) {
        missing += " instant";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GetSizeCommand(
          this.apksArchivePath,
          this.deviceSpec,
          this.modules,
          this.dimensions,
          this.instant);
    }
  }

}
