
package com.android.tools.build.bundletool.commands;

import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_DumpCommand extends DumpCommand {

  private final Path bundlePath;
  private final PrintStream outputStream;
  private final DumpCommand.DumpTarget dumpTarget;
  private final String moduleName;
  private final Optional<String> XPathExpression;

  private AutoValue_DumpCommand(
      Path bundlePath,
      PrintStream outputStream,
      DumpCommand.DumpTarget dumpTarget,
      String moduleName,
      Optional<String> XPathExpression) {
    this.bundlePath = bundlePath;
    this.outputStream = outputStream;
    this.dumpTarget = dumpTarget;
    this.moduleName = moduleName;
    this.XPathExpression = XPathExpression;
  }

  @Override
  public Path getBundlePath() {
    return bundlePath;
  }

  @Override
  public PrintStream getOutputStream() {
    return outputStream;
  }

  @Override
  public DumpCommand.DumpTarget getDumpTarget() {
    return dumpTarget;
  }

  @Override
  public String getModuleName() {
    return moduleName;
  }

  @Override
  public Optional<String> getXPathExpression() {
    return XPathExpression;
  }

  @Override
  public String toString() {
    return "DumpCommand{"
        + "bundlePath=" + bundlePath + ", "
        + "outputStream=" + outputStream + ", "
        + "dumpTarget=" + dumpTarget + ", "
        + "moduleName=" + moduleName + ", "
        + "XPathExpression=" + XPathExpression
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DumpCommand) {
      DumpCommand that = (DumpCommand) o;
      return (this.bundlePath.equals(that.getBundlePath()))
           && (this.outputStream.equals(that.getOutputStream()))
           && (this.dumpTarget.equals(that.getDumpTarget()))
           && (this.moduleName.equals(that.getModuleName()))
           && (this.XPathExpression.equals(that.getXPathExpression()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.bundlePath.hashCode();
    h *= 1000003;
    h ^= this.outputStream.hashCode();
    h *= 1000003;
    h ^= this.dumpTarget.hashCode();
    h *= 1000003;
    h ^= this.moduleName.hashCode();
    h *= 1000003;
    h ^= this.XPathExpression.hashCode();
    return h;
  }

  static final class Builder extends DumpCommand.Builder {
    private Path bundlePath;
    private PrintStream outputStream;
    private DumpCommand.DumpTarget dumpTarget;
    private String moduleName;
    private Optional<String> XPathExpression = Optional.empty();
    Builder() {
    }
    @Override
    public DumpCommand.Builder setBundlePath(Path bundlePath) {
      if (bundlePath == null) {
        throw new NullPointerException("Null bundlePath");
      }
      this.bundlePath = bundlePath;
      return this;
    }
    @Override
    public DumpCommand.Builder setOutputStream(PrintStream outputStream) {
      if (outputStream == null) {
        throw new NullPointerException("Null outputStream");
      }
      this.outputStream = outputStream;
      return this;
    }
    @Override
    public DumpCommand.Builder setDumpTarget(DumpCommand.DumpTarget dumpTarget) {
      if (dumpTarget == null) {
        throw new NullPointerException("Null dumpTarget");
      }
      this.dumpTarget = dumpTarget;
      return this;
    }
    @Override
    public DumpCommand.Builder setModuleName(String moduleName) {
      if (moduleName == null) {
        throw new NullPointerException("Null moduleName");
      }
      this.moduleName = moduleName;
      return this;
    }
    @Override
    public DumpCommand.Builder setXPathExpression(String XPathExpression) {
      if (XPathExpression == null) {
        throw new NullPointerException("Null XPathExpression");
      }
      this.XPathExpression = Optional.of(XPathExpression);
      return this;
    }
    @Override
    public DumpCommand build() {
      String missing = "";
      if (this.bundlePath == null) {
        missing += " bundlePath";
      }
      if (this.outputStream == null) {
        missing += " outputStream";
      }
      if (this.dumpTarget == null) {
        missing += " dumpTarget";
      }
      if (this.moduleName == null) {
        missing += " moduleName";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DumpCommand(
          this.bundlePath,
          this.outputStream,
          this.dumpTarget,
          this.moduleName,
          this.XPathExpression);
    }
  }

}
