
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_ModuleSplit extends ModuleSplit {

  private final Targeting.ApkTargeting apkTargeting;
  private final Targeting.VariantTargeting variantTargeting;
  private final ModuleSplit.SplitType splitType;
  private final ImmutableList<ModuleEntry> entries;
  private final Optional<Resources.ResourceTable> resourceTable;
  private final AndroidManifest androidManifest;
  private final ImmutableList<ManifestMutator> masterManifestMutators;
  private final BundleModuleName moduleName;
  private final boolean masterSplit;
  private final Optional<Files.NativeLibraries> nativeConfig;
  private final Optional<Files.Assets> assetsConfig;

  private AutoValue_ModuleSplit(
      Targeting.ApkTargeting apkTargeting,
      Targeting.VariantTargeting variantTargeting,
      ModuleSplit.SplitType splitType,
      ImmutableList<ModuleEntry> entries,
      Optional<Resources.ResourceTable> resourceTable,
      AndroidManifest androidManifest,
      ImmutableList<ManifestMutator> masterManifestMutators,
      BundleModuleName moduleName,
      boolean masterSplit,
      Optional<Files.NativeLibraries> nativeConfig,
      Optional<Files.Assets> assetsConfig) {
    this.apkTargeting = apkTargeting;
    this.variantTargeting = variantTargeting;
    this.splitType = splitType;
    this.entries = entries;
    this.resourceTable = resourceTable;
    this.androidManifest = androidManifest;
    this.masterManifestMutators = masterManifestMutators;
    this.moduleName = moduleName;
    this.masterSplit = masterSplit;
    this.nativeConfig = nativeConfig;
    this.assetsConfig = assetsConfig;
  }

  @Override
  public Targeting.ApkTargeting getApkTargeting() {
    return apkTargeting;
  }

  @Override
  public Targeting.VariantTargeting getVariantTargeting() {
    return variantTargeting;
  }

  @Override
  public ModuleSplit.SplitType getSplitType() {
    return splitType;
  }

  @Override
  public ImmutableList<ModuleEntry> getEntries() {
    return entries;
  }

  @Override
  public Optional<Resources.ResourceTable> getResourceTable() {
    return resourceTable;
  }

  @Override
  public AndroidManifest getAndroidManifest() {
    return androidManifest;
  }

  @Override
  public ImmutableList<ManifestMutator> getMasterManifestMutators() {
    return masterManifestMutators;
  }

  @Override
  public BundleModuleName getModuleName() {
    return moduleName;
  }

  @Override
  public boolean isMasterSplit() {
    return masterSplit;
  }

  @Override
  public Optional<Files.NativeLibraries> getNativeConfig() {
    return nativeConfig;
  }

  @Override
  public Optional<Files.Assets> getAssetsConfig() {
    return assetsConfig;
  }

  @Override
  public String toString() {
    return "ModuleSplit{"
        + "apkTargeting=" + apkTargeting + ", "
        + "variantTargeting=" + variantTargeting + ", "
        + "splitType=" + splitType + ", "
        + "entries=" + entries + ", "
        + "resourceTable=" + resourceTable + ", "
        + "androidManifest=" + androidManifest + ", "
        + "masterManifestMutators=" + masterManifestMutators + ", "
        + "moduleName=" + moduleName + ", "
        + "masterSplit=" + masterSplit + ", "
        + "nativeConfig=" + nativeConfig + ", "
        + "assetsConfig=" + assetsConfig
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ModuleSplit) {
      ModuleSplit that = (ModuleSplit) o;
      return (this.apkTargeting.equals(that.getApkTargeting()))
           && (this.variantTargeting.equals(that.getVariantTargeting()))
           && (this.splitType.equals(that.getSplitType()))
           && (this.entries.equals(that.getEntries()))
           && (this.resourceTable.equals(that.getResourceTable()))
           && (this.androidManifest.equals(that.getAndroidManifest()))
           && (this.masterManifestMutators.equals(that.getMasterManifestMutators()))
           && (this.moduleName.equals(that.getModuleName()))
           && (this.masterSplit == that.isMasterSplit())
           && (this.nativeConfig.equals(that.getNativeConfig()))
           && (this.assetsConfig.equals(that.getAssetsConfig()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.apkTargeting.hashCode();
    h *= 1000003;
    h ^= this.variantTargeting.hashCode();
    h *= 1000003;
    h ^= this.splitType.hashCode();
    h *= 1000003;
    h ^= this.entries.hashCode();
    h *= 1000003;
    h ^= this.resourceTable.hashCode();
    h *= 1000003;
    h ^= this.androidManifest.hashCode();
    h *= 1000003;
    h ^= this.masterManifestMutators.hashCode();
    h *= 1000003;
    h ^= this.moduleName.hashCode();
    h *= 1000003;
    h ^= this.masterSplit ? 1231 : 1237;
    h *= 1000003;
    h ^= this.nativeConfig.hashCode();
    h *= 1000003;
    h ^= this.assetsConfig.hashCode();
    return h;
  }

  @Override
  public ModuleSplit.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ModuleSplit.Builder {
    private Targeting.ApkTargeting apkTargeting;
    private Targeting.VariantTargeting variantTargeting;
    private ModuleSplit.SplitType splitType;
    private ImmutableList<ModuleEntry> entries;
    private Optional<Resources.ResourceTable> resourceTable = Optional.empty();
    private AndroidManifest androidManifest;
    private ImmutableList.Builder<ManifestMutator> masterManifestMutatorsBuilder$;
    private ImmutableList<ManifestMutator> masterManifestMutators;
    private BundleModuleName moduleName;
    private Boolean masterSplit;
    private Optional<Files.NativeLibraries> nativeConfig = Optional.empty();
    private Optional<Files.Assets> assetsConfig = Optional.empty();
    Builder() {
    }
    private Builder(ModuleSplit source) {
      this.apkTargeting = source.getApkTargeting();
      this.variantTargeting = source.getVariantTargeting();
      this.splitType = source.getSplitType();
      this.entries = source.getEntries();
      this.resourceTable = source.getResourceTable();
      this.androidManifest = source.getAndroidManifest();
      this.masterManifestMutators = source.getMasterManifestMutators();
      this.moduleName = source.getModuleName();
      this.masterSplit = source.isMasterSplit();
      this.nativeConfig = source.getNativeConfig();
      this.assetsConfig = source.getAssetsConfig();
    }
    @Override
    public ModuleSplit.Builder setApkTargeting(Targeting.ApkTargeting apkTargeting) {
      if (apkTargeting == null) {
        throw new NullPointerException("Null apkTargeting");
      }
      this.apkTargeting = apkTargeting;
      return this;
    }
    @Override
    public ModuleSplit.Builder setVariantTargeting(Targeting.VariantTargeting variantTargeting) {
      if (variantTargeting == null) {
        throw new NullPointerException("Null variantTargeting");
      }
      this.variantTargeting = variantTargeting;
      return this;
    }
    @Override
    public ModuleSplit.Builder setSplitType(ModuleSplit.SplitType splitType) {
      if (splitType == null) {
        throw new NullPointerException("Null splitType");
      }
      this.splitType = splitType;
      return this;
    }
    @Override
    public ModuleSplit.Builder setEntries(List<ModuleEntry> entries) {
      if (entries == null) {
        throw new NullPointerException("Null entries");
      }
      this.entries = ImmutableList.copyOf(entries);
      return this;
    }
    @Override
    public ModuleSplit.Builder setResourceTable(Resources.ResourceTable resourceTable) {
      if (resourceTable == null) {
        throw new NullPointerException("Null resourceTable");
      }
      this.resourceTable = Optional.of(resourceTable);
      return this;
    }
    @Override
    public ModuleSplit.Builder setAndroidManifest(AndroidManifest androidManifest) {
      if (androidManifest == null) {
        throw new NullPointerException("Null androidManifest");
      }
      this.androidManifest = androidManifest;
      return this;
    }
    @Override
    ImmutableList.Builder<ManifestMutator> masterManifestMutatorsBuilder() {
      if (masterManifestMutatorsBuilder$ == null) {
        if (masterManifestMutators == null) {
          masterManifestMutatorsBuilder$ = ImmutableList.builder();
        } else {
          masterManifestMutatorsBuilder$ = ImmutableList.builder();
          masterManifestMutatorsBuilder$.addAll(masterManifestMutators);
          masterManifestMutators = null;
        }
      }
      return masterManifestMutatorsBuilder$;
    }
    @Override
    public ModuleSplit.Builder setModuleName(BundleModuleName moduleName) {
      if (moduleName == null) {
        throw new NullPointerException("Null moduleName");
      }
      this.moduleName = moduleName;
      return this;
    }
    @Override
    public ModuleSplit.Builder setMasterSplit(boolean masterSplit) {
      this.masterSplit = masterSplit;
      return this;
    }
    @Override
    public ModuleSplit.Builder setNativeConfig(Files.NativeLibraries nativeConfig) {
      if (nativeConfig == null) {
        throw new NullPointerException("Null nativeConfig");
      }
      this.nativeConfig = Optional.of(nativeConfig);
      return this;
    }
    @Override
    public ModuleSplit.Builder setAssetsConfig(Files.Assets assetsConfig) {
      if (assetsConfig == null) {
        throw new NullPointerException("Null assetsConfig");
      }
      this.assetsConfig = Optional.of(assetsConfig);
      return this;
    }
    @Override
    protected ModuleSplit autoBuild() {
      if (masterManifestMutatorsBuilder$ != null) {
        this.masterManifestMutators = masterManifestMutatorsBuilder$.build();
      } else if (this.masterManifestMutators == null) {
        this.masterManifestMutators = ImmutableList.of();
      }
      String missing = "";
      if (this.apkTargeting == null) {
        missing += " apkTargeting";
      }
      if (this.variantTargeting == null) {
        missing += " variantTargeting";
      }
      if (this.splitType == null) {
        missing += " splitType";
      }
      if (this.entries == null) {
        missing += " entries";
      }
      if (this.androidManifest == null) {
        missing += " androidManifest";
      }
      if (this.moduleName == null) {
        missing += " moduleName";
      }
      if (this.masterSplit == null) {
        missing += " masterSplit";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ModuleSplit(
          this.apkTargeting,
          this.variantTargeting,
          this.splitType,
          this.entries,
          this.resourceTable,
          this.androidManifest,
          this.masterManifestMutators,
          this.moduleName,
          this.masterSplit,
          this.nativeConfig,
          this.assetsConfig);
    }
  }

}
