
package com.android.tools.build.bundletool.model;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_ModuleConditions extends ModuleConditions {

  private final ImmutableList<DeviceFeatureCondition> deviceFeatureConditions;
  private final Optional<Integer> minSdkVersion;
  private final Optional<UserCountriesCondition> userCountriesCondition;

  private AutoValue_ModuleConditions(
      ImmutableList<DeviceFeatureCondition> deviceFeatureConditions,
      Optional<Integer> minSdkVersion,
      Optional<UserCountriesCondition> userCountriesCondition) {
    this.deviceFeatureConditions = deviceFeatureConditions;
    this.minSdkVersion = minSdkVersion;
    this.userCountriesCondition = userCountriesCondition;
  }

  @Override
  public ImmutableList<DeviceFeatureCondition> getDeviceFeatureConditions() {
    return deviceFeatureConditions;
  }

  @Override
  public Optional<Integer> getMinSdkVersion() {
    return minSdkVersion;
  }

  @Override
  public Optional<UserCountriesCondition> getUserCountriesCondition() {
    return userCountriesCondition;
  }

  @Override
  public String toString() {
    return "ModuleConditions{"
        + "deviceFeatureConditions=" + deviceFeatureConditions + ", "
        + "minSdkVersion=" + minSdkVersion + ", "
        + "userCountriesCondition=" + userCountriesCondition
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ModuleConditions) {
      ModuleConditions that = (ModuleConditions) o;
      return (this.deviceFeatureConditions.equals(that.getDeviceFeatureConditions()))
           && (this.minSdkVersion.equals(that.getMinSdkVersion()))
           && (this.userCountriesCondition.equals(that.getUserCountriesCondition()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.deviceFeatureConditions.hashCode();
    h *= 1000003;
    h ^= this.minSdkVersion.hashCode();
    h *= 1000003;
    h ^= this.userCountriesCondition.hashCode();
    return h;
  }

  static final class Builder extends ModuleConditions.Builder {
    private ImmutableList.Builder<DeviceFeatureCondition> deviceFeatureConditionsBuilder$;
    private ImmutableList<DeviceFeatureCondition> deviceFeatureConditions;
    private Optional<Integer> minSdkVersion = Optional.empty();
    private Optional<UserCountriesCondition> userCountriesCondition = Optional.empty();
    Builder() {
    }
    @Override
    ImmutableList.Builder<DeviceFeatureCondition> deviceFeatureConditionsBuilder() {
      if (deviceFeatureConditionsBuilder$ == null) {
        deviceFeatureConditionsBuilder$ = ImmutableList.builder();
      }
      return deviceFeatureConditionsBuilder$;
    }
    @Override
    public ModuleConditions.Builder setMinSdkVersion(int minSdkVersion) {
      this.minSdkVersion = Optional.of(minSdkVersion);
      return this;
    }
    @Override
    public ModuleConditions.Builder setUserCountriesCondition(UserCountriesCondition userCountriesCondition) {
      if (userCountriesCondition == null) {
        throw new NullPointerException("Null userCountriesCondition");
      }
      this.userCountriesCondition = Optional.of(userCountriesCondition);
      return this;
    }
    @Override
    public ModuleConditions build() {
      if (deviceFeatureConditionsBuilder$ != null) {
        this.deviceFeatureConditions = deviceFeatureConditionsBuilder$.build();
      } else if (this.deviceFeatureConditions == null) {
        this.deviceFeatureConditions = ImmutableList.of();
      }
      return new AutoValue_ModuleConditions(
          this.deviceFeatureConditions,
          this.minSdkVersion,
          this.userCountriesCondition);
    }
  }

}
