/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.archive;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.archive.ArchivedAndroidManifestUtils;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.ResourceInjector;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.android.tools.build.bundletool.splitters.ResourceAnalyzer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.inject.Inject;

public final class ArchivedApksGenerator {
    public static final String APP_STORE_PACKAGE_NAME_RESOURCE_NAME = "reactivation_app_store_package_name";
    public static final String PLAY_STORE_PACKAGE_NAME = "shadow.bundletool.com.android.vending";
    private static final String ARCHIVED_CLASSES_DEX_PATH = "dex/classes.dex";
    private final TempDirectory globalTempDir;

    @Inject
    ArchivedApksGenerator(TempDirectory globalTempDir) {
        this.globalTempDir = globalTempDir;
    }

    public ModuleSplit generateArchivedApk(AppBundle appBundle, Optional<String> customAppStorePackageName) throws IOException {
        this.validateRequest(appBundle);
        BundleModule baseModule = appBundle.getBaseModule();
        AndroidManifest archivedManifest = ArchivedAndroidManifestUtils.createArchivedManifest(baseModule.getAndroidManifest());
        Resources.ResourceTable archivedResourceTable = this.getArchivedResourceTable(appBundle, baseModule, archivedManifest, customAppStorePackageName);
        Path archivedClassesDexFile = this.getArchivedClassesDexFile();
        return ModuleSplit.forArchive(baseModule, archivedManifest, archivedResourceTable, archivedClassesDexFile);
    }

    private void validateRequest(AppBundle appBundle) {
        boolean isStoreArchiveEnabledByDefault;
        Preconditions.checkNotNull((Object)appBundle);
        Version bundletoolVersion = BundleToolVersion.getVersionFromBundleConfig(appBundle.getBundleConfig());
        if (!VersionGuardedFeature.ARCHIVED_APK_GENERATION.enabledForVersion(bundletoolVersion)) {
            throw InvalidCommandException.builder().withInternalMessage(String.format("Archived APK can only be generated for bundles built with version %s or higher.", VersionGuardedFeature.ARCHIVED_APK_GENERATION.getEnabledSinceVersion())).build();
        }
        Optional<Boolean> storeArchiveConfig = appBundle.getStoreArchive();
        if (!storeArchiveConfig.orElse(isStoreArchiveEnabledByDefault = VersionGuardedFeature.STORE_ARCHIVE_ENABLED_BY_DEFAULT.enabledForVersion(bundletoolVersion)).booleanValue()) {
            throw InvalidCommandException.builder().withInternalMessage("Archived APK cannot be generated when Store Archive configuration is disabled.").build();
        }
        if (appBundle.getBaseModule().getAndroidManifest().isHeadless()) {
            throw InvalidCommandException.builder().withInternalMessage("Archived APK can not be generated for applications without a launcher activity.").build();
        }
    }

    private Resources.ResourceTable getArchivedResourceTable(AppBundle appBundle, BundleModule bundleModule, AndroidManifest archivedManifest, Optional<String> customAppStorePackageName) throws IOException {
        Resources.ResourceTable.Builder archivedResourceTable = Resources.ResourceTable.newBuilder();
        if (bundleModule.getResourceTable().isPresent()) {
            ImmutableSet<ResourceId> referredResources = new ResourceAnalyzer(appBundle).findAllAppResourcesReachableFromManifest(archivedManifest);
            archivedResourceTable = ResourcesUtils.filterResourceTable(bundleModule.getResourceTable().get(), entry -> !referredResources.contains((Object)entry.getResourceId()), ResourceTableEntry::getEntry).toBuilder();
        }
        ResourceInjector resourceInjector = new ResourceInjector(archivedResourceTable, appBundle.getPackageName());
        resourceInjector.addStringResource(APP_STORE_PACKAGE_NAME_RESOURCE_NAME, ArchivedApksGenerator.getAppStorePackageName(customAppStorePackageName));
        return resourceInjector.build();
    }

    private static String getAppStorePackageName(Optional<String> customAppStorePackageName) {
        return customAppStorePackageName.orElse(PLAY_STORE_PACKAGE_NAME);
    }

    private Path getArchivedClassesDexFile() throws IOException {
        Path archivedDexFilePath = Files.createTempFile(this.globalTempDir.getPath(), "classes", ".dex", new FileAttribute[0]);
        try (InputStream inputStream = ArchivedApksGenerator.readArchivedClassesDexFile();){
            Files.copy(inputStream, archivedDexFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        return archivedDexFilePath;
    }

    private static InputStream readArchivedClassesDexFile() {
        return ArchivedApksGenerator.class.getResourceAsStream(ARCHIVED_CLASSES_DEX_PATH);
    }
}

