/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import shadow.bundletool.com.android.ddmlib.AdbCommandRejectedException;
import shadow.bundletool.com.android.ddmlib.MultiLineReceiver;
import shadow.bundletool.com.android.ddmlib.ShellCommandUnresponsiveException;
import shadow.bundletool.com.android.ddmlib.TimeoutException;

public class AdbShellCommandTask {
    private final String command;
    private final Device device;

    public AdbShellCommandTask(Device device, String commandToExecute) {
        this.device = device;
        this.command = commandToExecute;
    }

    public ImmutableList<String> execute() {
        return this.execute(0L, TimeUnit.SECONDS);
    }

    public ImmutableList<String> execute(long deadline, TimeUnit deadlineUnits) {
        final ImmutableList.Builder outputLines = ImmutableList.builder();
        try {
            this.device.executeShellCommand(this.command, new MultiLineReceiver(){

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public void processNewLines(String[] strings) {
                    outputLines.add((Object[])strings);
                }
            }, deadline, deadlineUnits);
            return outputLines.build();
        }
        catch (IOException e11) {
            throw CommandExecutionException.builder().withInternalMessage("I/O error while executing 'adb shell %s' on device '%s'.", this.command, this.device.getSerialNumber()).withCause(e11).build();
        }
        catch (TimeoutException e12) {
            throw CommandExecutionException.builder().withInternalMessage("Timeout while executing 'adb shell %s' on device '%s'.", this.command, this.device.getSerialNumber()).withCause(e12).build();
        }
        catch (ShellCommandUnresponsiveException e13) {
            throw CommandExecutionException.builder().withInternalMessage("Unresponsive shell command while executing 'adb shell %s' on device '%s'.", this.command, this.device.getSerialNumber()).withCause(e13).build();
        }
        catch (AdbCommandRejectedException e14) {
            throw CommandExecutionException.builder().withInternalMessage("Rejected 'adb shell %s' command on device '%s'.", this.command, this.device.getSerialNumber()).withCause(e14).build();
        }
    }
}

