/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;
import javax.annotation.WillNotClose;

public final class GZipUtils {
    public static long calculateGzipCompressedSize(Path file) throws IOException {
        return GZipUtils.calculateGzipCompressedSize(MoreFiles.asByteSource((Path)file, (OpenOption[])new OpenOption[0]));
    }

    public static long calculateGzipCompressedSize(File file) throws IOException {
        return GZipUtils.calculateGzipCompressedSize(Files.asByteSource((File)file));
    }

    public static long calculateGzipCompressedSize(ByteSource byteSource) throws IOException {
        try (InputStream is2 = byteSource.openStream();){
            long l11 = GZipUtils.calculateGzipCompressedSize(is2);
            return l11;
        }
    }

    public static long calculateGzipCompressedSize(@WillNotClose InputStream stream) throws IOException {
        CountingOutputStream countingOutputStream = new CountingOutputStream(ByteStreams.nullOutputStream());
        try (GZIPOutputStream compressedStream = new GZIPOutputStream((OutputStream)countingOutputStream);){
            ByteStreams.copy((InputStream)stream, (OutputStream)compressedStream);
        }
        return countingOutputStream.getCount();
    }

    private GZipUtils() {
    }
}

