/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.validation.BundleFilesValidator;
import com.android.tools.build.bundletool.validation.BundleZipValidator;
import com.android.tools.build.bundletool.validation.DexFilesValidator;
import com.android.tools.build.bundletool.validation.ResourceTableValidator;
import com.android.tools.build.bundletool.validation.SdkAndroidManifestValidator;
import com.android.tools.build.bundletool.validation.SdkBundleConfigValidator;
import com.android.tools.build.bundletool.validation.SdkBundleHasOneModuleValidator;
import com.android.tools.build.bundletool.validation.SdkBundleMandatoryFilesPresenceValidator;
import com.android.tools.build.bundletool.validation.SdkBundleModuleNameValidator;
import com.android.tools.build.bundletool.validation.SdkBundleModuleResourceIdValidator;
import com.android.tools.build.bundletool.validation.SdkBundleModulesMandatoryFilesPresenceValidator;
import com.android.tools.build.bundletool.validation.SdkModulesConfigValidator;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.android.tools.build.bundletool.validation.ValidatorRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.zip.ZipFile;

public class SdkBundleValidator {
    @VisibleForTesting
    static final ImmutableList<SubValidator> DEFAULT_BUNDLE_FILE_SUB_VALIDATORS = ImmutableList.of((Object)new BundleZipValidator(), (Object)new SdkBundleMandatoryFilesPresenceValidator());
    @VisibleForTesting
    static final ImmutableList<SubValidator> DEFAULT_MODULES_FILE_SUB_VALIDATORS = ImmutableList.of((Object)new SdkBundleModulesMandatoryFilesPresenceValidator(), (Object)new SdkBundleHasOneModuleValidator(), (Object)new SdkModulesConfigValidator());
    @VisibleForTesting
    static final ImmutableList<SubValidator> DEFAULT_BUNDLE_SUB_VALIDATORS = ImmutableList.of((Object)new BundleFilesValidator(), (Object)new SdkBundleModuleNameValidator(), (Object)new DexFilesValidator(), (Object)new SdkAndroidManifestValidator(), (Object)new SdkBundleConfigValidator(), (Object)new SdkModulesConfigValidator(), (Object)new ResourceTableValidator(), (Object)new SdkBundleModuleResourceIdValidator());
    private final ImmutableList<SubValidator> allBundleFileSubValidators;
    private final ImmutableList<SubValidator> allModulesFileSubValidators;
    private final ImmutableList<SubValidator> allBundleSubValidators;

    private SdkBundleValidator(ImmutableList<SubValidator> allBundleSubValidators, ImmutableList<SubValidator> allModulesFileSubValidators, ImmutableList<SubValidator> allBundleFileSubValidators) {
        this.allBundleSubValidators = allBundleSubValidators;
        this.allModulesFileSubValidators = allModulesFileSubValidators;
        this.allBundleFileSubValidators = allBundleFileSubValidators;
    }

    public static SdkBundleValidator create() {
        return SdkBundleValidator.create((ImmutableList<SubValidator>)ImmutableList.of());
    }

    public static SdkBundleValidator create(ImmutableList<SubValidator> extraSubValidators) {
        return new SdkBundleValidator((ImmutableList<SubValidator>)ImmutableList.builder().addAll(DEFAULT_BUNDLE_SUB_VALIDATORS).addAll(extraSubValidators).build(), (ImmutableList<SubValidator>)ImmutableList.builder().addAll(DEFAULT_MODULES_FILE_SUB_VALIDATORS).addAll(extraSubValidators).build(), (ImmutableList<SubValidator>)ImmutableList.builder().addAll(DEFAULT_BUNDLE_FILE_SUB_VALIDATORS).addAll(extraSubValidators).build());
    }

    public void validateFile(ZipFile bundleFile) {
        new ValidatorRunner(this.allBundleFileSubValidators).validateBundleZipFile(bundleFile);
    }

    public void validateModulesFile(ZipFile modulesFile) {
        new ValidatorRunner(this.allModulesFileSubValidators).validateSdkModulesZipFile(modulesFile);
    }

    public void validate(SdkBundle bundle) {
        new ValidatorRunner(this.allBundleSubValidators).validateSdkBundle(bundle);
    }
}

