/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;

public class ResourceReader {
    public ImmutableList<Path> listResourceFilesInFolder(String path) throws URISyntaxException, IOException {
        URL pathUrl = ResourceReader.class.getResource(path);
        return pathUrl.getProtocol().equals("jar") ? this.readFromJar(Paths.get(ResourceReader.class.getProtectionDomain().getCodeSource().getLocation().toURI()), path) : this.readFromDirectory(Paths.get(pathUrl.toURI()));
    }

    private ImmutableList<Path> readFromDirectory(Path sourceDirectory) throws IOException {
        try (Stream<Path> stream = Files.list(sourceDirectory);){
            ImmutableList immutableList = (ImmutableList)stream.collect(ImmutableList.toImmutableList());
            return immutableList;
        }
    }

    private ImmutableList<Path> readFromJar(Path sourceJar, String path) throws IOException {
        try (FileSystem fs2 = FileSystems.newFileSystem(sourceJar, Thread.currentThread().getContextClassLoader());){
            ImmutableList immutableList;
            block12: {
                Stream<Path> stream = Files.list(fs2.getPath(path, new String[0]));
                try {
                    immutableList = (ImmutableList)stream.collect(ImmutableList.toImmutableList());
                    if (stream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return immutableList;
        }
    }

    public ByteSource getResourceByteSource(String resourcePath) throws IOException {
        try (InputStream fileContentStream = ResourceReader.class.getResourceAsStream(resourcePath);){
            ByteSource byteSource = ByteSource.wrap((byte[])ByteStreams.toByteArray((InputStream)fileContentStream));
            return byteSource;
        }
    }
}

