/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import java.io.Reader;
import java.nio.CharBuffer;

public final class CharSequenceReader
extends Reader {
    private CharSequence seq;
    private int pos;
    private int mark;

    public CharSequenceReader(CharSequence seq) {
        this.seq = seq;
    }

    private boolean hasRemaining() {
        return this.remaining() > 0;
    }

    private int remaining() {
        return this.seq.length() - this.pos;
    }

    @Override
    public int read(CharBuffer target) {
        if (!this.hasRemaining()) {
            return -1;
        }
        int charsToRead = Math.min(target.remaining(), this.remaining());
        for (int i11 = 0; i11 < charsToRead; ++i11) {
            target.put(this.seq.charAt(this.pos++));
        }
        return charsToRead;
    }

    @Override
    public int read() {
        return this.hasRemaining() ? (int)this.seq.charAt(this.pos++) : -1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (!this.hasRemaining()) {
            return -1;
        }
        int charsToRead = Math.min(len, this.remaining());
        for (int i11 = 0; i11 < charsToRead; ++i11) {
            cbuf[off + i11] = this.seq.charAt(this.pos++);
        }
        return charsToRead;
    }

    @Override
    public long skip(long n11) {
        int charsToSkip = (int)Math.min((long)this.remaining(), n11);
        this.pos += charsToSkip;
        return charsToSkip;
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() {
        this.seq = null;
    }
}

