/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.tools.build.bundletool.model.exceptions.InvalidDeviceSpecException;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.google.common.io.MoreFiles;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Path;

public class DeviceSpecParser {
    private static final String JSON_EXTENSION = "json";

    public static Devices.DeviceSpec parseDeviceSpec(Path deviceSpecFile) {
        return DeviceSpecParser.parseDeviceSpecInternal(deviceSpecFile, false);
    }

    public static Devices.DeviceSpec parseDeviceSpec(Reader deviceSpecReader) throws IOException {
        return DeviceSpecParser.parseDeviceSpecInternal(deviceSpecReader, false);
    }

    public static Devices.DeviceSpec parsePartialDeviceSpec(Path deviceSpecFile) {
        return DeviceSpecParser.parseDeviceSpecInternal(deviceSpecFile, true);
    }

    public static Devices.DeviceSpec parsePartialDeviceSpec(Reader deviceSpecReader) throws IOException {
        return DeviceSpecParser.parseDeviceSpecInternal(deviceSpecReader, true);
    }

    private static Devices.DeviceSpec parseDeviceSpecInternal(Path deviceSpecFile, boolean canSkipFields) {
        Devices.DeviceSpec deviceSpec;
        block9: {
            if (!JSON_EXTENSION.equals(MoreFiles.getFileExtension((Path)deviceSpecFile))) {
                throw InvalidDeviceSpecException.builder().withUserMessage("Expected .json extension for the device spec file.").build();
            }
            BufferedReader deviceSpecReader = BufferedIo.reader(deviceSpecFile);
            try {
                deviceSpec = DeviceSpecParser.parseDeviceSpecInternal(deviceSpecReader, canSkipFields);
                if (deviceSpecReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (deviceSpecReader != null) {
                        try {
                            ((Reader)deviceSpecReader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e11) {
                    throw new UncheckedIOException(String.format("Error while reading the device spec file '%s'.", deviceSpecFile), e11);
                }
            }
            ((Reader)deviceSpecReader).close();
        }
        return deviceSpec;
    }

    private static Devices.DeviceSpec parseDeviceSpecInternal(Reader deviceSpecReader, boolean canSkipFields) throws IOException {
        Devices.DeviceSpec.Builder builder = Devices.DeviceSpec.newBuilder();
        JsonFormat.parser().merge(deviceSpecReader, (Message.Builder)builder);
        Devices.DeviceSpec deviceSpec = builder.build();
        DeviceSpecParser.validateDeviceSpec(deviceSpec, canSkipFields);
        return deviceSpec;
    }

    public static void validateDeviceSpec(Devices.DeviceSpec deviceSpec, boolean canSkipFields) {
        if (deviceSpec.getSdkVersion() < 0 || !canSkipFields && deviceSpec.getSdkVersion() == 0) {
            throw InvalidDeviceSpecException.builder().withUserMessage("Device spec SDK version (%d) should be set to a strictly positive number.", deviceSpec.getSdkVersion()).build();
        }
        if (deviceSpec.getScreenDensity() < 0 || !canSkipFields && deviceSpec.getScreenDensity() == 0) {
            throw InvalidDeviceSpecException.builder().withUserMessage("Device spec screen density (%d) should be set to a strictly positive number.", deviceSpec.getScreenDensity()).build();
        }
        if (!canSkipFields) {
            if (deviceSpec.getSupportedAbisList().isEmpty()) {
                throw InvalidDeviceSpecException.builder().withUserMessage("Device spec supported ABI list is empty.").build();
            }
            if (deviceSpec.getSupportedLocalesList().isEmpty()) {
                throw InvalidDeviceSpecException.builder().withUserMessage("Device spec supported locales list is empty.").build();
            }
        }
    }

    private DeviceSpecParser() {
    }
}

