/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;

class ApkDescriptionHelper {
    static Commands.ApkDescription createApkDescription(ZipPath relativePath, ModuleSplit split) {
        Commands.ApkDescription.Builder resultBuilder = Commands.ApkDescription.newBuilder().setPath(relativePath.toString()).setTargeting(split.getApkTargeting());
        switch (split.getSplitType()) {
            case INSTANT: {
                resultBuilder.setInstantApkMetadata(ApkDescriptionHelper.createSplitApkMetadata(split));
                break;
            }
            case SPLIT: {
                resultBuilder.setSplitApkMetadata(ApkDescriptionHelper.createSplitApkMetadata(split));
                break;
            }
            case SYSTEM: {
                if (split.isBaseModuleSplit() && split.isMasterSplit()) {
                    resultBuilder.setSystemApkMetadata(ApkDescriptionHelper.createSystemApkMetadata(split));
                    break;
                }
                resultBuilder.setSplitApkMetadata(ApkDescriptionHelper.createSplitApkMetadata(split));
                break;
            }
            case STANDALONE: {
                if (split.isApex()) {
                    resultBuilder.setApexApkMetadata(ApkDescriptionHelper.createApexApkMetadata(split));
                    break;
                }
                resultBuilder.setStandaloneApkMetadata(ApkDescriptionHelper.createStandaloneApkMetadata(split));
                break;
            }
            case ASSET_SLICE: {
                resultBuilder.setAssetSliceMetadata(ApkDescriptionHelper.createSplitApkMetadata(split));
                break;
            }
            case ARCHIVE: {
                resultBuilder.setArchivedApkMetadata(Commands.ArchivedApkMetadata.getDefaultInstance());
            }
        }
        return resultBuilder.build();
    }

    private static Commands.SplitApkMetadata createSplitApkMetadata(ModuleSplit split) {
        return Commands.SplitApkMetadata.newBuilder().setSplitId(split.getAndroidManifest().getSplitId().orElse("")).setIsMasterSplit(split.isMasterSplit()).build();
    }

    private static Commands.SystemApkMetadata createSystemApkMetadata(ModuleSplit split) {
        return Commands.SystemApkMetadata.newBuilder().addAllFusedModuleName((Iterable<String>)split.getAndroidManifest().getFusedModuleNames()).build();
    }

    private static Commands.StandaloneApkMetadata createStandaloneApkMetadata(ModuleSplit split) {
        return Commands.StandaloneApkMetadata.newBuilder().addAllFusedModuleName((Iterable<String>)split.getAndroidManifest().getFusedModuleNames()).build();
    }

    private static Commands.ApexApkMetadata createApexApkMetadata(ModuleSplit split) {
        return Commands.ApexApkMetadata.newBuilder().addAllApexEmbeddedApkConfig((Iterable<? extends Config.ApexEmbeddedApkConfig>)split.getApexEmbeddedApkConfigs()).build();
    }

    private ApkDescriptionHelper() {
    }
}

