/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.io.ByteSource;
import java.util.Optional;

abstract class $AutoValue_ModuleEntry
extends ModuleEntry {
    private final ZipPath path;
    private final Optional<ModuleEntry.ModuleEntryBundleLocation> bundleLocation;
    private final boolean forceUncompressed;
    private final boolean shouldSign;
    private final ByteSource content;

    $AutoValue_ModuleEntry(ZipPath path, Optional<ModuleEntry.ModuleEntryBundleLocation> bundleLocation, boolean forceUncompressed, boolean shouldSign, ByteSource content) {
        if (path == null) {
            throw new NullPointerException("Null path");
        }
        this.path = path;
        if (bundleLocation == null) {
            throw new NullPointerException("Null bundleLocation");
        }
        this.bundleLocation = bundleLocation;
        this.forceUncompressed = forceUncompressed;
        this.shouldSign = shouldSign;
        if (content == null) {
            throw new NullPointerException("Null content");
        }
        this.content = content;
    }

    @Override
    public ZipPath getPath() {
        return this.path;
    }

    @Override
    public Optional<ModuleEntry.ModuleEntryBundleLocation> getBundleLocation() {
        return this.bundleLocation;
    }

    @Override
    public boolean getForceUncompressed() {
        return this.forceUncompressed;
    }

    @Override
    public boolean getShouldSign() {
        return this.shouldSign;
    }

    @Override
    public ByteSource getContent() {
        return this.content;
    }

    public String toString() {
        return "ModuleEntry{path=" + this.path + ", bundleLocation=" + this.bundleLocation + ", forceUncompressed=" + this.forceUncompressed + ", shouldSign=" + this.shouldSign + ", content=" + this.content + "}";
    }

    @Override
    public ModuleEntry.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ModuleEntry.Builder {
        private ZipPath path;
        private Optional<ModuleEntry.ModuleEntryBundleLocation> bundleLocation = Optional.empty();
        private Boolean forceUncompressed;
        private Boolean shouldSign;
        private ByteSource content;

        Builder() {
        }

        private Builder(ModuleEntry source) {
            this.path = source.getPath();
            this.bundleLocation = source.getBundleLocation();
            this.forceUncompressed = source.getForceUncompressed();
            this.shouldSign = source.getShouldSign();
            this.content = source.getContent();
        }

        @Override
        public ModuleEntry.Builder setPath(ZipPath path) {
            if (path == null) {
                throw new NullPointerException("Null path");
            }
            this.path = path;
            return this;
        }

        @Override
        public ModuleEntry.Builder setBundleLocation(Optional<ModuleEntry.ModuleEntryBundleLocation> bundleLocation) {
            if (bundleLocation == null) {
                throw new NullPointerException("Null bundleLocation");
            }
            this.bundleLocation = bundleLocation;
            return this;
        }

        @Override
        public ModuleEntry.Builder setBundleLocation(ModuleEntry.ModuleEntryBundleLocation bundleLocation) {
            this.bundleLocation = Optional.of(bundleLocation);
            return this;
        }

        @Override
        public ModuleEntry.Builder setForceUncompressed(boolean forceUncompressed) {
            this.forceUncompressed = forceUncompressed;
            return this;
        }

        @Override
        public ModuleEntry.Builder setShouldSign(boolean shouldSign) {
            this.shouldSign = shouldSign;
            return this;
        }

        @Override
        public ModuleEntry.Builder setContent(ByteSource content) {
            if (content == null) {
                throw new NullPointerException("Null content");
            }
            this.content = content;
            return this;
        }

        @Override
        public ModuleEntry build() {
            String missing = "";
            if (this.path == null) {
                missing = missing + " path";
            }
            if (this.forceUncompressed == null) {
                missing = missing + " forceUncompressed";
            }
            if (this.shouldSign == null) {
                missing = missing + " shouldSign";
            }
            if (this.content == null) {
                missing = missing + " content";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ModuleEntry(this.path, this.bundleLocation, this.forceUncompressed, this.shouldSign, this.content);
        }
    }
}

