/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ClassesDexNameSanitizer;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BundleParser {
    public static final ZipPath METADATA_DIRECTORY = ZipPath.create("BUNDLE-METADATA");
    public static final String BUNDLE_CONFIG_FILE_NAME = "BundleConfig.pb";

    private BundleParser() {
    }

    public static Optional<BundleModuleName> extractModuleName(ZipEntry entry, ImmutableSet<ZipPath> nonModuleDirectories) {
        ZipPath path = ZipPath.create(entry.getName());
        for (ZipPath nonModuleDirectory : nonModuleDirectories) {
            if (!path.startsWith(nonModuleDirectory)) continue;
            return Optional.empty();
        }
        if (path.getNameCount() <= 1) {
            return Optional.empty();
        }
        if (path.toString().endsWith(".class")) {
            return Optional.empty();
        }
        return Optional.of(BundleModuleName.create(path.getName(0).toString()));
    }

    public static ImmutableList<BundleModule> extractModules(ZipFile bundleFile, Config.BundleConfig bundleConfig, ImmutableSet<ZipPath> nonModuleDirectories) {
        HashMap<BundleModuleName, BundleModule.Builder> moduleBuilders = new HashMap<BundleModuleName, BundleModule.Builder>();
        Enumeration<? extends ZipEntry> entries = bundleFile.entries();
        while (entries.hasMoreElements()) {
            Optional<BundleModuleName> moduleName;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(moduleName = BundleParser.extractModuleName(entry, nonModuleDirectories)).isPresent()) continue;
            BundleModule.Builder moduleBuilder = moduleBuilders.computeIfAbsent(moduleName.get(), name -> BundleModule.builder().setName((BundleModuleName)name).setBundleConfig(bundleConfig));
            moduleBuilder.addEntry(ModuleEntry.builder().setBundleLocation(ModuleEntry.ModuleEntryBundleLocation.create(Paths.get(bundleFile.getName(), new String[0]), ZipPath.create(entry.getName()))).setPath(ZipUtils.convertBundleToModulePath(ZipPath.create(entry.getName()))).setContent(ZipUtils.asByteSource(bundleFile, entry)).build());
        }
        BundleParser.checkModulesHaveManifest(moduleBuilders.values());
        return (ImmutableList)moduleBuilders.values().stream().map(BundleModule.Builder::build).collect(ImmutableList.toImmutableList());
    }

    private static void checkModulesHaveManifest(Collection<BundleModule.Builder> bundleModules) {
        ImmutableSet modulesWithoutManifest = (ImmutableSet)bundleModules.stream().filter(bundleModule -> !bundleModule.hasAndroidManifest()).map(module -> module.getName().getName()).collect(ImmutableSet.toImmutableSet());
        if (!modulesWithoutManifest.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Found modules in the App Bundle without an AndroidManifest.xml: %s", modulesWithoutManifest).build();
        }
    }

    public static Config.BundleConfig readBundleConfig(ZipFile bundleFile) {
        ZipEntry bundleConfigEntry = bundleFile.getEntry(BUNDLE_CONFIG_FILE_NAME);
        if (bundleConfigEntry == null) {
            throw InvalidBundleException.builder().withUserMessage("File '%s' was not found.", BUNDLE_CONFIG_FILE_NAME).build();
        }
        try {
            return Config.BundleConfig.parseFrom(ZipUtils.asByteSource(bundleFile, bundleConfigEntry).read());
        }
        catch (InvalidProtocolBufferException e5) {
            throw InvalidBundleException.builder().withCause(e5).withUserMessage("Bundle config '%s' could not be parsed.", BUNDLE_CONFIG_FILE_NAME).build();
        }
        catch (IOException e6) {
            throw new UncheckedIOException(String.format("Error reading file '%s'.", BUNDLE_CONFIG_FILE_NAME), e6);
        }
    }

    public static BundleMetadata readBundleMetadata(ZipFile bundleFile) {
        BundleMetadata.Builder metadata = BundleMetadata.builder();
        ZipUtils.allFileEntries(bundleFile).filter(entry -> ZipPath.create(entry.getName()).startsWith(METADATA_DIRECTORY)).forEach(zipEntry -> {
            ZipPath bundlePath = ZipPath.create(zipEntry.getName());
            ZipPath metadataPath = bundlePath.subpath(1, bundlePath.getNameCount());
            metadata.addFile(metadataPath, ZipUtils.asByteSource(bundleFile, zipEntry));
        });
        return metadata.build();
    }

    @CheckReturnValue
    public static ImmutableList<BundleModule> sanitize(ImmutableList<BundleModule> modules) {
        modules = (ImmutableList)modules.stream().map(new ClassesDexNameSanitizer()::sanitize).collect(ImmutableList.toImmutableList());
        return modules;
    }
}

