/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.externalBuild;

import com.android.build.gradle.internal.BuildCacheUtils;
import com.android.build.gradle.internal.externalBuild.ExternalBuildExtension;
import com.android.build.gradle.internal.externalBuild.ExternalBuildGlobalScope;
import com.android.build.gradle.internal.externalBuild.ExternalBuildTaskManager;
import com.android.build.gradle.internal.profile.ProfilerInitializer;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.profile.ThreadRecorder;
import com.android.builder.utils.FileCache;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class ExternalBuildPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        ExternalBuildExtension externalBuildExtension = (ExternalBuildExtension)project.getExtensions().create("externalBuild", ExternalBuildExtension.class, new Object[0]);
        ProjectOptions projectOptions = new ProjectOptions(project, ImmutableMap.of((Object)BooleanOption.ENABLE_AAPT2.getPropertyName(), (Object)false));
        ProfilerInitializer.init((Project)project, (ProjectOptions)projectOptions);
        FileCache buildCache = BuildCacheUtils.createBuildCacheIfEnabled((Project)project, (ProjectOptions)projectOptions);
        Preconditions.checkNotNull((Object)buildCache);
        ExternalBuildGlobalScope globalScope = new ExternalBuildGlobalScope(project, projectOptions, buildCache);
        ExternalBuildTaskManager taskManager = new ExternalBuildTaskManager(globalScope, project, ThreadRecorder.get());
        project.afterEvaluate(project1 -> {
            try {
                taskManager.createTasks(externalBuildExtension);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

