/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.build.api.transform.Transform;
import com.android.build.api.variant.VariantFilter;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.SourceSetSourceProviderWrapper;
import com.android.build.gradle.internal.coverage.JacocoOptions;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.AdbOptions;
import com.android.build.gradle.internal.dsl.AndroidSourceSetFactory;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.DataBindingOptions;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.dsl.ExternalNativeBuild;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.LibraryRequest;
import com.android.builder.model.SourceProvider;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestServer;
import com.android.repository.Revision;
import com.android.resources.Density;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.reflect.Instantiator;

public abstract class BaseExtension
implements AndroidConfig {
    private final List<List<Object>> transformDependencies = Lists.newArrayList();
    private final AndroidBuilder androidBuilder;
    private final SdkHandler sdkHandler;
    private final DefaultConfig defaultConfig;
    private final AaptOptions aaptOptions;
    private final LintOptions lintOptions;
    private final ExternalNativeBuild externalNativeBuild;
    private final DexOptions dexOptions;
    private final TestOptions testOptions;
    private final CompileOptions compileOptions;
    private final PackagingOptions packagingOptions;
    private final JacocoOptions jacoco;
    private final Splits splits;
    private final AdbOptions adbOptions;
    private final NamedDomainObjectContainer<ProductFlavor> productFlavors;
    private final NamedDomainObjectContainer<BuildType> buildTypes;
    private final NamedDomainObjectContainer<SigningConfig> signingConfigs;
    private final NamedDomainObjectContainer<BaseVariantOutput> buildOutputs;
    private final List<DeviceProvider> deviceProviderList = Lists.newArrayList();
    private final List<TestServer> testServerList = Lists.newArrayList();
    private final List<Transform> transforms = Lists.newArrayList();
    private final DataBindingOptions dataBinding;
    private final NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer;
    private String target;
    private Revision buildToolsRevision;
    private List<LibraryRequest> libraryRequests = Lists.newArrayList();
    private List<String> flavorDimensionList;
    private String resourcePrefix;
    private ExtraModelInfo extraModelInfo;
    private String defaultPublishConfig = "release";
    private Action<VariantFilter> variantFilter;
    protected Logger logger;
    private boolean isWritable = true;
    protected Project project;
    private final ProjectOptions projectOptions;
    boolean generatePureSplits = false;

    BaseExtension(final Project project, ProjectOptions projectOptions, Instantiator instantiator, AndroidBuilder androidBuilder, SdkHandler sdkHandler, NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs, NamedDomainObjectContainer<BaseVariantOutput> buildOutputs, ExtraModelInfo extraModelInfo, final boolean publishPackage) {
        this.androidBuilder = androidBuilder;
        this.sdkHandler = sdkHandler;
        this.buildTypes = buildTypes;
        this.productFlavors = productFlavors;
        this.signingConfigs = signingConfigs;
        this.extraModelInfo = extraModelInfo;
        this.buildOutputs = buildOutputs;
        this.project = project;
        this.projectOptions = projectOptions;
        this.logger = Logging.getLogger(this.getClass());
        this.defaultConfig = (DefaultConfig)instantiator.newInstance(DefaultConfig.class, new Object[]{"main", project, instantiator, project.getLogger(), extraModelInfo});
        this.aaptOptions = (AaptOptions)instantiator.newInstance(AaptOptions.class, new Object[0]);
        this.dexOptions = (DexOptions)instantiator.newInstance(DexOptions.class, new Object[]{extraModelInfo});
        this.lintOptions = (LintOptions)instantiator.newInstance(LintOptions.class, new Object[0]);
        this.externalNativeBuild = (ExternalNativeBuild)instantiator.newInstance(ExternalNativeBuild.class, new Object[]{instantiator, project});
        this.testOptions = (TestOptions)instantiator.newInstance(TestOptions.class, new Object[]{instantiator});
        this.compileOptions = (CompileOptions)instantiator.newInstance(CompileOptions.class, new Object[0]);
        this.packagingOptions = (PackagingOptions)instantiator.newInstance(PackagingOptions.class, new Object[0]);
        this.jacoco = (JacocoOptions)instantiator.newInstance(JacocoOptions.class, new Object[0]);
        this.adbOptions = (AdbOptions)instantiator.newInstance(AdbOptions.class, new Object[0]);
        this.splits = (Splits)instantiator.newInstance(Splits.class, new Object[]{instantiator});
        this.dataBinding = (DataBindingOptions)instantiator.newInstance(DataBindingOptions.class, new Object[0]);
        this.sourceSetsContainer = project.container(AndroidSourceSet.class, (NamedDomainObjectFactory)new AndroidSourceSetFactory(instantiator, project, publishPackage));
        this.sourceSetsContainer.whenObjectAdded((Action)new Action<AndroidSourceSet>(){

            public void execute(AndroidSourceSet sourceSet) {
                ConfigurationContainer configurations = project.getConfigurations();
                String implementationName = sourceSet.getImplementationConfigurationName();
                String runtimeOnlyName = sourceSet.getRuntimeOnlyConfigurationName();
                String compileOnlyName = sourceSet.getCompileOnlyConfigurationName();
                String compileName = sourceSet.getCompileConfigurationName();
                Configuration compile = BaseExtension.this.createConfiguration(configurations, compileName, String.format("%s dependencies for '%s' sources (deprecated: use '%s' instead).", "Compile", sourceSet.getName(), implementationName), "compile".equals(compileName) || "testCompile".equals(compileName));
                compile.getAllDependencies().whenObjectAdded((Action)new AndroidConfig.DeprecatedConfigurationAction(project, compile, implementationName));
                String packageConfigDescription = publishPackage ? String.format("%s dependencies for '%s' sources (deprecated: use '%s' instead).", "Publish", sourceSet.getName(), runtimeOnlyName) : String.format("%s dependencies for '%s' sources (deprecated: use '%s' instead).", "Apk", sourceSet.getName(), runtimeOnlyName);
                Configuration apk = BaseExtension.this.createConfiguration(configurations, sourceSet.getPackageConfigurationName(), packageConfigDescription);
                apk.getAllDependencies().whenObjectAdded((Action)new AndroidConfig.DeprecatedConfigurationAction(project, apk, runtimeOnlyName));
                Configuration provided = BaseExtension.this.createConfiguration(configurations, sourceSet.getProvidedConfigurationName(), String.format("%s dependencies for '%s' sources (deprecated: use '%s' instead).", "Provided", sourceSet.getName(), compileOnlyName));
                provided.getAllDependencies().whenObjectAdded((Action)new AndroidConfig.DeprecatedConfigurationAction(project, provided, compileOnlyName));
                String apiName = sourceSet.getApiConfigurationName();
                Configuration api = BaseExtension.this.createConfiguration(configurations, apiName, String.format("%s dependencies for '%s' sources.", "API", sourceSet.getName()));
                api.extendsFrom(new Configuration[]{compile});
                Configuration implementation = BaseExtension.this.createConfiguration(configurations, implementationName, String.format("%s dependencies for '%s' sources.", "Implementation only", sourceSet.getName()));
                implementation.extendsFrom(new Configuration[]{api});
                Configuration runtimeOnly = BaseExtension.this.createConfiguration(configurations, runtimeOnlyName, String.format("%s dependencies for '%s' sources.", "Runtime only", sourceSet.getName()));
                runtimeOnly.extendsFrom(new Configuration[]{apk});
                Configuration compileOnly = BaseExtension.this.createConfiguration(configurations, compileOnlyName, String.format("%s dependencies for '%s' sources.", "Compile only", sourceSet.getName()));
                compileOnly.extendsFrom(new Configuration[]{provided});
                Configuration wearConfig = BaseExtension.this.createConfiguration(configurations, sourceSet.getWearAppConfigurationName(), "Link to a wear app to embed for object '" + sourceSet.getName() + "'.");
                BaseExtension.this.createConfiguration(configurations, sourceSet.getAnnotationProcessorConfigurationName(), "Classpath for the annotation processor for '" + sourceSet.getName() + "'.");
                sourceSet.setRoot(String.format("src/%s", sourceSet.getName()));
            }
        });
        this.createConfiguration(project.getConfigurations(), "androidTestUtil", "Additional APKs used during instrumentation testing.", true);
        this.sourceSetsContainer.create(this.defaultConfig.getName());
        this.buildToolsRevision = AndroidBuilder.DEFAULT_BUILD_TOOLS_REVISION;
        this.setDefaultConfigValues();
    }

    private void setDefaultConfigValues() {
        Set densities = Density.getRecommendedValuesForDevice();
        HashSet strings = Sets.newHashSetWithExpectedSize((int)densities.size());
        for (Density density : densities) {
            strings.add(density.getResourceValue());
        }
        this.defaultConfig.getVectorDrawables().setGeneratedDensities((Iterable)strings);
        this.defaultConfig.getVectorDrawables().setUseSupportLibrary(Boolean.valueOf(false));
    }

    public void disableWrite() {
        this.isWritable = false;
    }

    protected void checkWritability() {
        if (!this.isWritable) {
            throw new GradleException("Android tasks have already been created.\nThis happens when calling android.applicationVariants,\nandroid.libraryVariants or android.testVariants.\nOnce these methods are called, it is not possible to\ncontinue configuring the model.");
        }
    }

    private Configuration createConfiguration(ConfigurationContainer configurations, String name, String description) {
        return this.createConfiguration(configurations, name, description, false);
    }

    private Configuration createConfiguration(ConfigurationContainer configurations, String name, String description, boolean canBeResolved) {
        this.logger.info("Creating configuration {}", (Object)name);
        Configuration configuration = (Configuration)configurations.findByName(name);
        if (configuration == null) {
            configuration = (Configuration)configurations.create(name);
        }
        configuration.setVisible(false);
        configuration.setDescription(description);
        configuration.setCanBeConsumed(false);
        configuration.setCanBeResolved(canBeResolved);
        return configuration;
    }

    public void compileSdkVersion(String version) {
        this.checkWritability();
        this.target = version;
    }

    public void compileSdkVersion(int apiLevel) {
        this.compileSdkVersion("android-" + apiLevel);
    }

    public void setCompileSdkVersion(int apiLevel) {
        this.compileSdkVersion(apiLevel);
    }

    public void setCompileSdkVersion(String target) {
        this.compileSdkVersion(target);
    }

    public void useLibrary(String name) {
        this.useLibrary(name, true);
    }

    public void useLibrary(String name, boolean required) {
        this.libraryRequests.add(new LibraryRequest(name, required));
    }

    public void buildToolsVersion(String version) {
        this.checkWritability();
        this.buildToolsRevision = Revision.parseRevision((String)version, (Revision.Precision)Revision.Precision.MICRO);
    }

    public String getBuildToolsVersion() {
        return this.buildToolsRevision.toString();
    }

    public void setBuildToolsVersion(String version) {
        this.buildToolsVersion(version);
    }

    public void buildTypes(Action<? super NamedDomainObjectContainer<BuildType>> action) {
        this.checkWritability();
        action.execute(this.buildTypes);
    }

    public void productFlavors(Action<? super NamedDomainObjectContainer<ProductFlavor>> action) {
        this.checkWritability();
        action.execute(this.productFlavors);
    }

    public void signingConfigs(Action<? super NamedDomainObjectContainer<SigningConfig>> action) {
        this.checkWritability();
        action.execute(this.signingConfigs);
    }

    public void flavorDimensions(String ... dimensions) {
        this.checkWritability();
        this.flavorDimensionList = Arrays.asList(dimensions);
    }

    public void sourceSets(Action<NamedDomainObjectContainer<AndroidSourceSet>> action) {
        this.checkWritability();
        action.execute(this.sourceSetsContainer);
    }

    public NamedDomainObjectContainer<AndroidSourceSet> getSourceSets() {
        return this.sourceSetsContainer;
    }

    public NamedDomainObjectContainer<BaseVariantOutput> getBuildOutputs() {
        return this.buildOutputs;
    }

    public void defaultConfig(Action<DefaultConfig> action) {
        this.checkWritability();
        action.execute((Object)this.defaultConfig);
    }

    public void aaptOptions(Action<AaptOptions> action) {
        this.checkWritability();
        action.execute((Object)this.aaptOptions);
    }

    public void dexOptions(Action<DexOptions> action) {
        this.checkWritability();
        action.execute((Object)this.dexOptions);
    }

    public void lintOptions(Action<LintOptions> action) {
        this.checkWritability();
        action.execute((Object)this.lintOptions);
    }

    public void externalNativeBuild(Action<ExternalNativeBuild> action) {
        this.checkWritability();
        action.execute((Object)this.externalNativeBuild);
    }

    public void testOptions(Action<TestOptions> action) {
        this.checkWritability();
        action.execute((Object)this.testOptions);
    }

    public void compileOptions(Action<CompileOptions> action) {
        this.checkWritability();
        action.execute((Object)this.compileOptions);
    }

    public void packagingOptions(Action<PackagingOptions> action) {
        this.checkWritability();
        action.execute((Object)this.packagingOptions);
    }

    public void jacoco(Action<JacocoOptions> action) {
        this.checkWritability();
        action.execute((Object)this.jacoco);
    }

    public void adbOptions(Action<AdbOptions> action) {
        this.checkWritability();
        action.execute((Object)this.adbOptions);
    }

    public void splits(Action<Splits> action) {
        this.checkWritability();
        action.execute((Object)this.splits);
    }

    public void dataBinding(Action<DataBindingOptions> action) {
        this.checkWritability();
        action.execute((Object)this.dataBinding);
    }

    public DataBindingOptions getDataBinding() {
        return this.dataBinding;
    }

    public void deviceProvider(DeviceProvider deviceProvider) {
        this.checkWritability();
        this.deviceProviderList.add(deviceProvider);
    }

    public List<DeviceProvider> getDeviceProviders() {
        return this.deviceProviderList;
    }

    public void testServer(TestServer testServer) {
        this.checkWritability();
        this.testServerList.add(testServer);
    }

    public List<TestServer> getTestServers() {
        return this.testServerList;
    }

    public void registerTransform(Transform transform, Object ... dependencies) {
        this.transforms.add(transform);
        this.transformDependencies.add(Arrays.asList(dependencies));
    }

    public List<Transform> getTransforms() {
        return ImmutableList.copyOf(this.transforms);
    }

    public List<List<Object>> getTransformsDependencies() {
        return ImmutableList.copyOf(this.transformDependencies);
    }

    public NamedDomainObjectContainer<ProductFlavor> getProductFlavors() {
        return this.productFlavors;
    }

    public NamedDomainObjectContainer<BuildType> getBuildTypes() {
        return this.buildTypes;
    }

    public NamedDomainObjectContainer<SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public void defaultPublishConfig(String value) {
        this.setDefaultPublishConfig(value);
    }

    public String getDefaultPublishConfig() {
        return this.defaultPublishConfig;
    }

    public void setDefaultPublishConfig(String value) {
        this.defaultPublishConfig = value;
    }

    public void setPublishNonDefault(boolean publishNonDefault) {
        this.logger.warn("publishNonDefault is deprecated and has no effect anymore. All variants are now published.");
    }

    public void variantFilter(Action<VariantFilter> filter) {
        this.setVariantFilter(filter);
    }

    public void setVariantFilter(Action<VariantFilter> filter) {
        this.variantFilter = filter;
    }

    public Action<VariantFilter> getVariantFilter() {
        return this.variantFilter;
    }

    public AdbOptions getAdbOptions() {
        return this.adbOptions;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public List<String> getFlavorDimensionList() {
        return this.flavorDimensionList;
    }

    public boolean getGeneratePureSplits() {
        return this.generatePureSplits;
    }

    public void resourcePrefix(String prefix) {
        this.resourcePrefix = prefix;
    }

    public abstract void addVariant(BaseVariant var1);

    public void registerArtifactType(String name, boolean isTest, int artifactType) {
        this.extraModelInfo.registerArtifactType(name, isTest, artifactType);
    }

    public void registerBuildTypeSourceProvider(String name, BuildType buildType, SourceProvider sourceProvider) {
        this.extraModelInfo.registerBuildTypeSourceProvider(name, (CoreBuildType)buildType, sourceProvider);
    }

    public void registerProductFlavorSourceProvider(String name, ProductFlavor productFlavor, SourceProvider sourceProvider) {
        this.extraModelInfo.registerProductFlavorSourceProvider(name, (CoreProductFlavor)productFlavor, sourceProvider);
    }

    public void registerJavaArtifact(String name, BaseVariant variant, String assembleTaskName, String javaCompileTaskName, Collection<File> generatedSourceFolders, Iterable<String> ideSetupTaskNames, Configuration configuration, File classesFolder, File javaResourceFolder, SourceProvider sourceProvider) {
        this.extraModelInfo.registerJavaArtifact(name, variant, assembleTaskName, javaCompileTaskName, generatedSourceFolders, ideSetupTaskNames, configuration, classesFolder, javaResourceFolder, sourceProvider);
    }

    public void registerMultiFlavorSourceProvider(String name, String flavorName, SourceProvider sourceProvider) {
        this.extraModelInfo.registerMultiFlavorSourceProvider(name, flavorName, sourceProvider);
    }

    public static SourceProvider wrapJavaSourceSet(SourceSet sourceSet) {
        return new SourceSetSourceProviderWrapper(sourceSet);
    }

    public String getCompileSdkVersion() {
        return this.target;
    }

    public Revision getBuildToolsRevision() {
        return this.buildToolsRevision;
    }

    public Collection<LibraryRequest> getLibraryRequests() {
        return this.libraryRequests;
    }

    public File getSdkDirectory() {
        return this.sdkHandler.getSdkFolder();
    }

    public File getNdkDirectory() {
        return this.sdkHandler.getNdkFolder();
    }

    public List<File> getBootClasspath() {
        this.ensureTargetSetup();
        return this.androidBuilder.getBootClasspath(false);
    }

    public File getAdbExecutable() {
        return this.sdkHandler.getSdkInfo().getAdb();
    }

    @Deprecated
    public File getAdbExe() {
        return this.getAdbExecutable();
    }

    public File getDefaultProguardFile(String name) {
        if (!ProguardFiles.KNOWN_FILE_NAMES.contains(name)) {
            this.extraModelInfo.handleSyncError(null, 0, ProguardFiles.UNKNOWN_FILENAME_MESSAGE);
        }
        return ProguardFiles.getDefaultProguardFile((String)name, (Project)this.project);
    }

    public void generatePureSplits(boolean flag) {
        this.setGeneratePureSplits(flag);
    }

    public void setGeneratePureSplits(boolean flag) {
        if (flag) {
            this.logger.warn("Pure splits are not supported by PlayStore yet.");
        }
        this.generatePureSplits = flag;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public CompileOptions getCompileOptions() {
        return this.compileOptions;
    }

    public DexOptions getDexOptions() {
        return this.dexOptions;
    }

    public JacocoOptions getJacoco() {
        return this.jacoco;
    }

    public LintOptions getLintOptions() {
        return this.lintOptions;
    }

    public ExternalNativeBuild getExternalNativeBuild() {
        return this.externalNativeBuild;
    }

    public PackagingOptions getPackagingOptions() {
        return this.packagingOptions;
    }

    public Splits getSplits() {
        return this.splits;
    }

    public TestOptions getTestOptions() {
        return this.testOptions;
    }

    private void ensureTargetSetup() {
        TargetInfo targetInfo = this.androidBuilder.getTargetInfo();
        if (targetInfo == null) {
            this.sdkHandler.initTarget(this.getCompileSdkVersion(), this.buildToolsRevision, this.libraryRequests, this.androidBuilder, SdkHandler.useCachedSdk((ProjectOptions)this.projectOptions));
        }
    }

    public Boolean getPackageBuildConfig() {
        throw new GradleException("packageBuildConfig is not supported.");
    }

    public Collection<String> getAidlPackageWhiteList() {
        throw new GradleException("aidlPackageWhiteList is not supported.");
    }

    public Boolean getBaseFeature() {
        throw new GradleException("baseFeature is not supported.");
    }
}

