/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.FeaturePlugin;
import com.android.build.gradle.api.AndroidBasePlugin;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.ApiObjectFactory;
import com.android.build.gradle.internal.BadPluginException;
import com.android.build.gradle.internal.BuildCacheUtils;
import com.android.build.gradle.internal.ClasspathVerifier;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.NativeLibraryFactoryImpl;
import com.android.build.gradle.internal.NonFinalPluginExpiry;
import com.android.build.gradle.internal.PluginInitializer;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.api.dsl.extensions.BaseExtension2;
import com.android.build.gradle.internal.api.sourcesets.FilesProvider;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.BuildTypeFactory;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.ProductFlavorFactory;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.SigningConfigFactory;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.ide.NativeModelBuilder;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.packaging.GradleKeystoreHelper;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.plugin.PluginDelegate;
import com.android.build.gradle.internal.plugin.ProjectWrapper;
import com.android.build.gradle.internal.plugin.TypedPluginDelegate;
import com.android.build.gradle.internal.process.GradleJavaProcessExecutor;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.profile.ProfilerInitializer;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.transforms.DexTransform;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.internal.variant2.ContainerFactory;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.internal.compiler.PreDexCache;
import com.android.builder.model.DataBindingOptions;
import com.android.builder.model.Version;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.utils.FileCache;
import com.android.dx.command.dexer.Main;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.api.Channel;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.Downloader;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.downloader.LocalFileAwareDownloader;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.legacy.LegacyDownloader;
import com.android.tools.lint.gradle.api.ToolingRegistryProvider;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class BasePlugin<E extends BaseExtension2>
implements Plugin<Project>,
ToolingRegistryProvider {
    public static final GradleVersion GRADLE_MIN_VERSION = GradleVersion.parse((String)"4.4");
    private BaseExtension extension;
    private VariantManager variantManager;
    private TaskManager taskManager;
    protected Project project;
    private ProjectOptions projectOptions;
    private SdkHandler sdkHandler;
    private NdkHandler ndkHandler;
    private AndroidBuilder androidBuilder;
    private DataBindingBuilder dataBindingBuilder;
    private VariantFactory variantFactory;
    private ToolingModelBuilderRegistry registry;
    private LoggerWrapper loggerWrapper;
    protected ExtraModelInfo extraModelInfo;
    private String creator;
    private Recorder threadRecorder;
    private boolean hasCreatedTasks = false;

    BasePlugin(ToolingModelBuilderRegistry registry) {
        ClasspathVerifier.checkClasspathSanity();
        this.registry = registry;
        this.creator = "Android Gradle " + Version.ANDROID_GRADLE_PLUGIN_VERSION;
        NonFinalPluginExpiry.verifyRetirementAge();
        ModelBuilder.clearCaches();
    }

    protected abstract BaseExtension createExtension(Project var1, ProjectOptions var2, AndroidBuilder var3, SdkHandler var4, NamedDomainObjectContainer<BuildType> var5, NamedDomainObjectContainer<ProductFlavor> var6, NamedDomainObjectContainer<SigningConfig> var7, NamedDomainObjectContainer<BaseVariantOutput> var8, ExtraModelInfo var9);

    protected abstract GradleBuildProject.PluginType getAnalyticsPluginType();

    protected abstract VariantFactory createVariantFactory(GlobalScope var1, AndroidBuilder var2, AndroidConfig var3);

    protected abstract TaskManager createTaskManager(GlobalScope var1, Project var2, ProjectOptions var3, AndroidBuilder var4, DataBindingBuilder var5, AndroidConfig var6, SdkHandler var7, NdkHandler var8, ToolingModelBuilderRegistry var9, Recorder var10);

    protected abstract int getProjectType();

    public VariantManager getVariantManager() {
        return this.variantManager;
    }

    public BaseExtension getExtension() {
        return this.extension;
    }

    AndroidBuilder getAndroidBuilder() {
        return this.androidBuilder;
    }

    private ILogger getLogger() {
        if (this.loggerWrapper == null) {
            this.loggerWrapper = new LoggerWrapper(this.project.getLogger());
        }
        return this.loggerWrapper;
    }

    public void apply(Project project) {
        System.setProperty("java.awt.headless", "true");
        this.project = project;
        this.projectOptions = new ProjectOptions(project);
        project.getPluginManager().apply(AndroidBasePlugin.class);
        this.checkPathForErrors();
        this.checkModulesForErrors();
        PluginInitializer.initialize((Project)project);
        ProfilerInitializer.init((Project)project, (ProjectOptions)this.projectOptions);
        this.threadRecorder = ThreadRecorder.get();
        ProcessProfileWriter.getProject((String)project.getPath()).setAndroidPluginVersion(Version.ANDROID_GRADLE_PLUGIN_VERSION).setAndroidPlugin(this.getAnalyticsPluginType()).setPluginGeneration(GradleBuildProject.PluginGeneration.FIRST).setOptions(AnalyticsUtil.toProto((ProjectOptions)this.projectOptions));
        if (!this.projectOptions.get(BooleanOption.ENABLE_NEW_DSL_AND_API)) {
            TaskInputHelper.enableBypass();
            this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_CONFIGURE, project.getPath(), null, this::configureProject);
            this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_BASE_EXTENSION_CREATION, project.getPath(), null, this::configureExtension);
            this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_TASKS_CREATION, project.getPath(), null, this::createTasks);
        } else {
            project.getPlugins().apply(JavaBasePlugin.class);
            ProjectWrapper projectWrapper = new ProjectWrapper(project);
            PluginDelegate delegate = new PluginDelegate(project.getPath(), project.getObjects(), project.getExtensions(), project.getConfigurations(), (ContainerFactory)projectWrapper, (FilesProvider)projectWrapper, project.getLogger(), this.projectOptions, this.getTypedDelegate());
            delegate.prepareForEvaluation();
            project.afterEvaluate(p -> {
                Collection cfr_ignored_0 = (Collection)this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_CREATE_ANDROID_TASKS, p.getPath(), null, () -> ((PluginDelegate)delegate).afterEvaluate());
            });
        }
    }

    protected abstract TypedPluginDelegate<E> getTypedDelegate();

    private void configureProject() {
        Gradle gradle = this.project.getGradle();
        this.extraModelInfo = new ExtraModelInfo(this.project.getPath(), this.projectOptions, this.project.getLogger());
        BasePlugin.checkGradleVersion(this.project, this.getLogger(), this.projectOptions);
        this.sdkHandler = new SdkHandler(this.project, this.getLogger());
        if (!gradle.getStartParameter().isOffline() && this.projectOptions.get(BooleanOption.ENABLE_SDK_DOWNLOAD)) {
            SdkLibData sdkLibData = SdkLibData.download((Downloader)this.getDownloader(), (SettingsController)this.getSettingsController());
            this.sdkHandler.setSdkLibData(sdkLibData);
        }
        this.androidBuilder = new AndroidBuilder(this.project == this.project.getRootProject() ? this.project.getName() : this.project.getPath(), this.creator, (ProcessExecutor)new GradleProcessExecutor(this.project), (JavaProcessExecutor)new GradleJavaProcessExecutor(this.project), (EvalIssueReporter)this.extraModelInfo.getSyncIssueHandler(), (MessageReceiver)this.extraModelInfo.getMessageReceiver(), this.getLogger(), this.isVerbose());
        this.dataBindingBuilder = new DataBindingBuilder();
        this.dataBindingBuilder.setPrintMachineReadableOutput(SyncOptions.getErrorFormatMode((ProjectOptions)this.projectOptions) == SyncOptions.ErrorFormatMode.MACHINE_PARSABLE);
        if (this.projectOptions.hasDeprecatedOptions()) {
            this.androidBuilder.getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, this.projectOptions.getDeprecatedOptionsErrorMessage());
        }
        if (!this.projectOptions.get(BooleanOption.ENABLE_AAPT2)) {
            this.androidBuilder.getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, String.format("AAPT is deprecated and support for it will be soon removed. Remove the '%s=false' flag to enable AAPT2.", BooleanOption.ENABLE_AAPT2.getPropertyName()));
        }
        this.project.getPlugins().apply(JavaBasePlugin.class);
        this.project.getTasks().getByName("assemble").setDescription("Assembles all variants of all applications and secondary packages.");
        gradle.addBuildListener(new BuildListener(){

            public void buildStarted(Gradle gradle) {
                TaskInputHelper.enableBypass();
            }

            public void settingsEvaluated(Settings settings) {
            }

            public void projectsLoaded(Gradle gradle) {
            }

            public void projectsEvaluated(Gradle gradle) {
            }

            public void buildFinished(BuildResult buildResult) {
                if (buildResult.getGradle().getParent() != null) {
                    return;
                }
                BasePlugin.this.sdkHandler.unload();
                BasePlugin.this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_BUILD_FINISHED, BasePlugin.this.project.getPath(), null, () -> {
                    PreDexCache.getCache().clear(FileUtils.join((File)BasePlugin.this.project.getRootProject().getBuildDir(), (String[])new String[]{"intermediates", "dex-cache", "cache.xml"}), BasePlugin.this.getLogger());
                    Main.clearInternTables();
                });
            }
        });
        gradle.getTaskGraph().addTaskExecutionGraphListener(taskGraph -> {
            TaskInputHelper.disableBypass();
            for (Task task : taskGraph.getAllTasks()) {
                Transform transform;
                if (!(task instanceof TransformTask) || !((transform = ((TransformTask)task).getTransform()) instanceof DexTransform)) continue;
                PreDexCache.getCache().load(FileUtils.join((File)this.project.getRootProject().getBuildDir(), (String[])new String[]{"intermediates", "dex-cache", "cache.xml"}));
                break;
            }
        });
        BasePlugin.createLintClasspathConfiguration(this.project);
    }

    public static void createLintClasspathConfiguration(Project project) {
        Configuration config = (Configuration)project.getConfigurations().create("lintClassPath");
        config.setVisible(false);
        config.setTransitive(true);
        config.setCanBeConsumed(false);
        config.setDescription("The lint embedded classpath");
        project.getDependencies().add(config.getName(), (Object)("com.android.tools.lint:lint-gradle:" + Version.ANDROID_TOOLS_BASE_VERSION));
    }

    private void configureExtension() {
        ObjectFactory objectFactory = this.project.getObjects();
        NamedDomainObjectContainer buildTypeContainer = this.project.container(BuildType.class, (NamedDomainObjectFactory)new BuildTypeFactory(objectFactory, this.project, (EvalIssueReporter)this.extraModelInfo.getSyncIssueHandler(), this.extraModelInfo.getDeprecationReporter()));
        NamedDomainObjectContainer productFlavorContainer = this.project.container(ProductFlavor.class, (NamedDomainObjectFactory)new ProductFlavorFactory(objectFactory, this.project, this.project.getLogger()));
        NamedDomainObjectContainer signingConfigContainer = this.project.container(SigningConfig.class, (NamedDomainObjectFactory)new SigningConfigFactory(objectFactory, GradleKeystoreHelper.getDefaultDebugKeystoreLocation()));
        NamedDomainObjectContainer buildOutputs = this.project.container(BaseVariantOutput.class);
        this.project.getExtensions().add("buildOutputs", (Object)buildOutputs);
        this.extension = this.createExtension(this.project, this.projectOptions, this.androidBuilder, this.sdkHandler, (NamedDomainObjectContainer<BuildType>)buildTypeContainer, (NamedDomainObjectContainer<ProductFlavor>)productFlavorContainer, (NamedDomainObjectContainer<SigningConfig>)signingConfigContainer, (NamedDomainObjectContainer<BaseVariantOutput>)buildOutputs, this.extraModelInfo);
        this.ndkHandler = new NdkHandler(this.project.getRootDir(), null, "gcc", "", Boolean.valueOf(false));
        FileCache buildCache = BuildCacheUtils.createBuildCacheIfEnabled((Project)this.project, (ProjectOptions)this.projectOptions);
        GlobalScope globalScope = new GlobalScope(this.project, this.projectOptions, this.androidBuilder, (AndroidConfig)this.extension, this.sdkHandler, this.ndkHandler, this.registry, buildCache);
        this.variantFactory = this.createVariantFactory(globalScope, this.androidBuilder, this.extension);
        this.taskManager = this.createTaskManager(globalScope, this.project, this.projectOptions, this.androidBuilder, this.dataBindingBuilder, this.extension, this.sdkHandler, this.ndkHandler, this.registry, this.threadRecorder);
        this.variantManager = new VariantManager(globalScope, this.project, this.projectOptions, this.androidBuilder, (AndroidConfig)this.extension, this.variantFactory, this.taskManager, this.threadRecorder);
        this.registerModels(this.registry, globalScope, this.variantManager, this.extension, this.extraModelInfo);
        signingConfigContainer.whenObjectAdded(arg_0 -> ((VariantManager)this.variantManager).addSigningConfig(arg_0));
        buildTypeContainer.whenObjectAdded(buildType -> {
            SigningConfig signingConfig = (SigningConfig)signingConfigContainer.findByName("debug");
            buildType.init(signingConfig);
            this.variantManager.addBuildType((CoreBuildType)buildType);
        });
        productFlavorContainer.whenObjectAdded(arg_0 -> ((VariantManager)this.variantManager).addProductFlavor(arg_0));
        signingConfigContainer.whenObjectRemoved((Action)new UnsupportedAction("Removing signingConfigs is not supported."));
        buildTypeContainer.whenObjectRemoved((Action)new UnsupportedAction("Removing build types is not supported."));
        productFlavorContainer.whenObjectRemoved((Action)new UnsupportedAction("Removing product flavors is not supported."));
        this.variantFactory.createDefaultComponents(buildTypeContainer, productFlavorContainer, signingConfigContainer);
    }

    protected void registerModels(ToolingModelBuilderRegistry registry, GlobalScope globalScope, VariantManager variantManager, AndroidConfig config, ExtraModelInfo extraModelInfo) {
        ModelBuilder modelBuilder = new ModelBuilder(globalScope, this.androidBuilder, variantManager, this.taskManager, config, extraModelInfo, this.ndkHandler, (NativeLibraryFactory)new NativeLibraryFactoryImpl(this.ndkHandler), this.getProjectType(), 1);
        registry.register((ToolingModelBuilder)modelBuilder);
        NativeModelBuilder nativeModelBuilder = new NativeModelBuilder(variantManager);
        registry.register((ToolingModelBuilder)nativeModelBuilder);
    }

    private void createTasks() {
        this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.TASK_MANAGER_CREATE_TASKS, this.project.getPath(), null, () -> this.taskManager.createTasksBeforeEvaluate());
        this.project.afterEvaluate(project -> this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_CREATE_ANDROID_TASKS, project.getPath(), null, () -> this.createAndroidTasks(false)));
    }

    static void checkGradleVersion(Project project, ILogger logger, ProjectOptions projectOptions) {
        String currentVersion = project.getGradle().getGradleVersion();
        if (GRADLE_MIN_VERSION.compareTo(currentVersion) > 0) {
            File file = new File("gradle" + File.separator + "wrapper" + File.separator + "gradle-wrapper.properties");
            String errorMessage = String.format("Minimum supported Gradle version is %s. Current version is %s. If using the gradle wrapper, try editing the distributionUrl in %s to gradle-%s-all.zip", GRADLE_MIN_VERSION, currentVersion, file.getAbsolutePath(), GRADLE_MIN_VERSION);
            if (projectOptions != null && (projectOptions.get(BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY) || projectOptions.get(BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY_OLD))) {
                logger.warning(errorMessage, new Object[0]);
                logger.warning("As %s is set, continuing anyway.", new Object[]{BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.getPropertyName()});
            } else {
                throw new RuntimeException(errorMessage);
            }
        }
    }

    final void createAndroidTasks(boolean force) {
        Preconditions.checkState((this.extension.getBuildToolsRevision() != null ? 1 : 0) != 0, (Object)"buildToolsVersion is not specified.");
        Preconditions.checkState((this.extension.getCompileSdkVersion() != null ? 1 : 0) != 0, (Object)"compileSdkVersion is not specified.");
        this.ndkHandler.setCompileSdkVersion(this.extension.getCompileSdkVersion());
        if (this.project.getPlugins().hasPlugin(JavaPlugin.class)) {
            throw new BadPluginException("The 'java' plugin has been applied, but it is not compatible with the Android plugins.");
        }
        boolean targetSetupSuccess = this.ensureTargetSetup();
        this.sdkHandler.ensurePlatformToolsIsInstalledWarnOnFailure((EvalIssueReporter)this.extraModelInfo.getSyncIssueHandler());
        if (!targetSetupSuccess) {
            this.project.getLogger().warn("Aborting configuration as SDK is missing components in sync mode.");
            return;
        }
        if (!(force || this.project.getState().getExecuted() && this.project.getState().getFailure() == null || SdkHandler.sTestSdkFolder != null)) {
            return;
        }
        if (this.hasCreatedTasks) {
            return;
        }
        this.hasCreatedTasks = true;
        this.extension.disableWrite();
        this.taskManager.configureCustomLintChecks();
        ProcessProfileWriter.getProject((String)this.project.getPath()).setCompileSdk(this.extension.getCompileSdkVersion()).setBuildToolsVersion(this.extension.getBuildToolsRevision().toString()).setSplits(AnalyticsUtil.toProto((Splits)this.extension.getSplits()));
        String kotlinPluginVersion = this.getKotlinPluginVersion();
        if (kotlinPluginVersion != null) {
            ProcessProfileWriter.getProject((String)this.project.getPath()).setKotlinPluginVersion(kotlinPluginVersion);
        }
        this.sdkHandler.addLocalRepositories(this.project);
        this.taskManager.addDataBindingDependenciesIfNecessary((DataBindingOptions)this.extension.getDataBinding());
        this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.VARIANT_MANAGER_CREATE_ANDROID_TASKS, this.project.getPath(), null, () -> {
            this.variantManager.createAndroidTasks();
            ApiObjectFactory apiObjectFactory = new ApiObjectFactory(this.androidBuilder, this.extension, this.variantFactory, this.project.getObjects());
            for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
                BaseVariantData variantData = variantScope.getVariantData();
                apiObjectFactory.create(variantData);
            }
        });
        this.taskManager.configureGlobalLintTask((Collection)this.variantManager.getVariantScopes());
        boolean forceRegeneration = this.projectOptions.get(BooleanOption.IDE_REFRESH_EXTERNAL_NATIVE_MODEL);
        this.checkSplitConfiguration();
        if (ExternalNativeBuildTaskUtils.shouldRegenerateOutOfDateJsons((ProjectOptions)this.projectOptions)) {
            this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.VARIANT_MANAGER_EXTERNAL_NATIVE_CONFIG_VALUES, this.project.getPath(), null, () -> {
                for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
                    ExternalNativeJsonGenerator generator = variantScope.getExternalNativeJsonGenerator();
                    if (generator == null) continue;
                    generator.build(forceRegeneration);
                }
            });
        }
    }

    private void checkSplitConfiguration() {
        boolean splitsEnabled;
        String configApkUrl = "https://d.android.com/topic/instant-apps/guides/config-splits.html";
        boolean isFeatureModule = this.project.getPlugins().hasPlugin(FeaturePlugin.class);
        boolean generatePureSplits = this.extension.getGeneratePureSplits();
        Splits splits = this.extension.getSplits();
        boolean bl = splitsEnabled = splits.getDensity().isEnable() || splits.getAbi().isEnable() || splits.getLanguage().isEnable();
        if (!isFeatureModule && generatePureSplits) {
            this.extraModelInfo.getSyncIssueHandler().reportWarning(EvalIssueReporter.Type.GENERIC, "Configuration APKs are supported by the Google Play Store only when publishing Android Instant Apps. To instead generate stand-alone APKs for different device configurations, set generatePureSplits=false. For more information, go to " + configApkUrl);
        }
        if (!isFeatureModule && !generatePureSplits && splits.getLanguage().isEnable()) {
            this.extraModelInfo.getSyncIssueHandler().reportWarning(EvalIssueReporter.Type.GENERIC, "Per-language APKs are supported only when building Android Instant Apps. For more information, go to " + configApkUrl);
        }
        if (isFeatureModule && !generatePureSplits && splitsEnabled) {
            this.extraModelInfo.getSyncIssueHandler().reportWarning(EvalIssueReporter.Type.GENERIC, "Configuration APKs targeting different device configurations are automatically built when splits are enabled for a feature module.\nTo suppress this warning, remove \"generatePureSplits false\" from your build.gradle file.\nTo learn more, see " + configApkUrl);
        }
    }

    private boolean isVerbose() {
        return this.project.getLogger().isEnabled(LogLevel.INFO);
    }

    private boolean ensureTargetSetup() {
        TargetInfo targetInfo = this.androidBuilder.getTargetInfo();
        if (targetInfo != null) {
            return true;
        }
        if (this.extension.getCompileOptions() == null) {
            throw new GradleException("Calling getBootClasspath before compileSdkVersion");
        }
        return this.sdkHandler.initTarget(this.extension.getCompileSdkVersion(), this.extension.getBuildToolsRevision(), this.extension.getLibraryRequests(), this.androidBuilder, SdkHandler.useCachedSdk((ProjectOptions)this.projectOptions));
    }

    private void checkModulesForErrors() {
        Project rootProject = this.project.getRootProject();
        HashMap<String, Project> subProjectsById = new HashMap<String, Project>();
        for (Project subProject : rootProject.getAllprojects()) {
            String id = subProject.getGroup().toString() + ":" + subProject.getName();
            if (subProjectsById.containsKey(id)) {
                String message = String.format("Your project contains 2 or more modules with the same identification %1$s\nat \"%2$s\" and \"%3$s\".\nYou must use different identification (either name or group) for each modules.", id, ((Project)subProjectsById.get(id)).getPath(), subProject.getPath());
                throw new StopExecutionException(message);
            }
            subProjectsById.put(id, subProject);
        }
    }

    private void checkPathForErrors() {
        if (!System.getProperty("os.name").toLowerCase(Locale.US).contains("windows")) {
            return;
        }
        if (this.projectOptions.get(BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY) || this.projectOptions.get(BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY_OLD)) {
            return;
        }
        if (CharMatcher.ASCII.matchesAllOf((CharSequence)this.project.getRootDir().getAbsolutePath())) {
            return;
        }
        String message = "Your project path contains non-ASCII characters. This will most likely cause the build to fail on Windows. Please move your project to a different directory. See http://b.android.com/95744 for details. This warning can be disabled by adding the line '" + BooleanOption.OVERRIDE_PATH_CHECK_PROPERTY.getPropertyName() + "=true' to gradle.properties file in the project directory.";
        throw new StopExecutionException(message);
    }

    public ToolingModelBuilderRegistry getModelBuilderRegistry() {
        return this.registry;
    }

    private SettingsController getSettingsController() {
        final Proxy proxy = BasePlugin.createProxy(System.getProperties(), this.getLogger());
        return new SettingsController(){

            public boolean getForceHttp() {
                return false;
            }

            public void setForceHttp(boolean force) {
            }

            public Channel getChannel() {
                Integer channel = BasePlugin.this.projectOptions.get(IntegerOption.ANDROID_SDK_CHANNEL);
                if (channel != null) {
                    return Channel.create((int)channel);
                }
                return Channel.DEFAULT;
            }

            public Proxy getProxy() {
                return proxy;
            }
        };
    }

    static Proxy createProxy(Properties properties, ILogger logger) {
        InetSocketAddress proxyAddr;
        String maybePort;
        String host = properties.getProperty("https.proxyHost");
        int port = 443;
        if (host != null) {
            maybePort = properties.getProperty("https.proxyPort");
            if (maybePort != null) {
                try {
                    port = Integer.parseInt(maybePort);
                }
                catch (NumberFormatException e) {
                    logger.info("Invalid https.proxyPort '" + maybePort + "', using default 443", new Object[0]);
                }
            }
        } else {
            host = properties.getProperty("http.proxyHost");
            if (host != null) {
                port = 80;
                maybePort = properties.getProperty("http.proxyPort");
                if (maybePort != null) {
                    try {
                        port = Integer.parseInt(maybePort);
                    }
                    catch (NumberFormatException e) {
                        logger.info("Invalid http.proxyPort '" + maybePort + "', using default 80", new Object[0]);
                    }
                }
            }
        }
        if (host != null && (proxyAddr = BasePlugin.createAddress(host, port)) != null) {
            return new Proxy(Proxy.Type.HTTP, proxyAddr);
        }
        return Proxy.NO_PROXY;
    }

    private static InetSocketAddress createAddress(String proxyHost, int proxyPort) {
        try {
            InetAddress address = InetAddress.getByName(proxyHost);
            return new InetSocketAddress(address, proxyPort);
        }
        catch (UnknownHostException e) {
            new ConsoleProgressIndicator().logWarning("Failed to parse host " + proxyHost);
            return null;
        }
    }

    private Downloader getDownloader() {
        return new LocalFileAwareDownloader((Downloader)new LegacyDownloader(FileOpUtils.create(), this.getSettingsController()));
    }

    private String getKotlinPluginVersion() {
        Plugin plugin = this.project.getPlugins().findPlugin("kotlin-android");
        if (plugin == null) {
            return null;
        }
        try {
            Method method = plugin.getClass().getMethod("getKotlinPluginVersion", new Class[0]);
            method.setAccessible(true);
            return method.invoke((Object)plugin, new Object[0]).toString();
        }
        catch (Throwable e) {
            return "unknown";
        }
    }

    private static class UnsupportedAction
    implements Action<Object> {
        private final String message;

        UnsupportedAction(String message) {
            this.message = message;
        }

        public void execute(Object o) {
            throw new UnsupportedOperationException(this.message);
        }
    }
}

