/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.dsl.BundleExtensionImpl;
import com.android.build.gradle.internal.tasks.BundleTask;
import com.android.tools.build.bundletool.BuildBundleCommand;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0007R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u0012R2\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0007@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask;", "Lorg/gradle/api/DefaultTask;", "()V", "configFile", "Ljava/io/File;", "getConfigFile", "()Ljava/io/File;", "extension", "Lcom/android/build/gradle/internal/dsl/BundleExtensionImpl;", "getExtension$gradle", "()Lcom/android/build/gradle/internal/dsl/BundleExtensionImpl;", "setExtension$gradle", "(Lcom/android/build/gradle/internal/dsl/BundleExtensionImpl;)V", "inputModules", "", "Lorg/gradle/api/file/FileCollection;", "inputModules$annotations", "getInputModules", "()Ljava/util/Collection;", "<set-?>", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "outputFile", "getOutputFile", "()Lorg/gradle/api/provider/Provider;", "setOutputFile$gradle", "(Lorg/gradle/api/provider/Provider;)V", "bundle", "", "gradle"})
public class BundleTask
extends DefaultTask {
    @NotNull
    public Provider<RegularFile> outputFile;
    @NotNull
    public BundleExtensionImpl extension;

    @OutputFile
    @NotNull
    public final Provider<RegularFile> getOutputFile() {
        Provider<RegularFile> provider = this.outputFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        return provider;
    }

    public final void setOutputFile$gradle(@NotNull Provider<RegularFile> provider) {
        Intrinsics.checkParameterIsNotNull(provider, (String)"<set-?>");
        this.outputFile = provider;
    }

    @NotNull
    public final BundleExtensionImpl getExtension$gradle() {
        BundleExtensionImpl bundleExtensionImpl = this.extension;
        if (bundleExtensionImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
        }
        return bundleExtensionImpl;
    }

    public final void setExtension$gradle(@NotNull BundleExtensionImpl bundleExtensionImpl) {
        Intrinsics.checkParameterIsNotNull((Object)bundleExtensionImpl, (String)"<set-?>");
        this.extension = bundleExtensionImpl;
    }

    public static /* synthetic */ void inputModules$annotations() {
    }

    @Classpath
    @NotNull
    public final Collection<FileCollection> getInputModules() {
        BundleExtensionImpl bundleExtensionImpl = this.extension;
        if (bundleExtensionImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
        }
        return bundleExtensionImpl.getModules().values();
    }

    @Optional
    @InputFile
    @Nullable
    public final File getConfigFile() {
        File file = this.getProject().file((Object)"BundleConfig.xml");
        return file.exists() ? file : null;
    }

    @TaskAction
    public final void bundle() {
        File bundleFile;
        Provider<RegularFile> provider = this.outputFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputFile.get()");
        File file = bundleFile = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"bundleFile");
        if (file.isFile()) {
            FileUtils.delete((File)bundleFile);
        }
        BundleExtensionImpl bundleExtensionImpl = this.extension;
        if (bundleExtensionImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
        }
        ImmutableList modules2 = (ImmutableList)bundleExtensionImpl.getModules().values().stream().map(bundle.modules.1.INSTANCE).collect(ImmutableList.toImmutableList());
        BuildBundleCommand.Builder command = BuildBundleCommand.builder().setOutputPath(bundleFile.toPath()).setModulesPaths(modules2);
        File file2 = this.getConfigFile();
        if (file2 != null) {
            File file3;
            File it = file3 = file2;
            command.setBundleConfigPath(it.toPath());
        }
        command.build().execute();
    }
}

