/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.VariantOutput;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.build.gradle.internal.api.ApkVariantOutputImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.api.LibraryVariantOutputImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.TestVariantImpl;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.internal.api.UnitTestVariantImpl;
import com.android.build.gradle.internal.dsl.VariantOutputFactory;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import org.gradle.api.model.ObjectFactory;

public class ApiObjectFactory {
    private final AndroidBuilder androidBuilder;
    private final BaseExtension extension;
    private final VariantFactory variantFactory;
    private final ObjectFactory objectFactory;
    private final ReadOnlyObjectProvider readOnlyObjectProvider = new ReadOnlyObjectProvider();

    public ApiObjectFactory(AndroidBuilder androidBuilder, BaseExtension extension, VariantFactory variantFactory, ObjectFactory objectFactory) {
        this.androidBuilder = androidBuilder;
        this.extension = extension;
        this.variantFactory = variantFactory;
        this.objectFactory = objectFactory;
    }

    public BaseVariantImpl create(BaseVariantData variantData) {
        if (variantData.getType().isTestComponent()) {
            this.createVariantOutput(variantData, null);
            return null;
        }
        BaseVariantImpl variantApi = this.variantFactory.createVariantApi(this.objectFactory, this.androidBuilder, variantData, this.readOnlyObjectProvider);
        if (variantApi == null) {
            return null;
        }
        if (this.variantFactory.hasTestScope()) {
            TestVariantData unitTestVariantData;
            TestVariantData androidTestVariantData = ((TestedVariantData)variantData).getTestVariantData((VariantType)VariantTypeImpl.ANDROID_TEST);
            if (androidTestVariantData != null) {
                TestVariantImpl androidTestVariant = (TestVariantImpl)this.objectFactory.newInstance(TestVariantImpl.class, new Object[]{androidTestVariantData, variantApi, this.objectFactory, this.androidBuilder, this.readOnlyObjectProvider, variantData.getScope().getGlobalScope().getProject().container(VariantOutput.class)});
                this.createVariantOutput((BaseVariantData)androidTestVariantData, (BaseVariantImpl)androidTestVariant);
                ((TestedAndroidConfig)this.extension).getTestVariants().add((Object)androidTestVariant);
                ((TestedVariant)variantApi).setTestVariant((TestVariant)androidTestVariant);
            }
            if ((unitTestVariantData = ((TestedVariantData)variantData).getTestVariantData((VariantType)VariantTypeImpl.UNIT_TEST)) != null) {
                UnitTestVariantImpl unitTestVariant = (UnitTestVariantImpl)this.objectFactory.newInstance(UnitTestVariantImpl.class, new Object[]{unitTestVariantData, variantApi, this.objectFactory, this.androidBuilder, this.readOnlyObjectProvider, variantData.getScope().getGlobalScope().getProject().container(VariantOutput.class)});
                ((TestedAndroidConfig)this.extension).getUnitTestVariants().add((Object)unitTestVariant);
                ((TestedVariant)variantApi).setUnitTestVariant((UnitTestVariant)unitTestVariant);
            }
        }
        this.createVariantOutput(variantData, variantApi);
        this.extension.addVariant((BaseVariant)variantApi);
        return variantApi;
    }

    private void createVariantOutput(BaseVariantData variantData, BaseVariantImpl variantApi) {
        variantData.variantOutputFactory = new VariantOutputFactory(variantData.getType().isAar() ? LibraryVariantOutputImpl.class : ApkVariantOutputImpl.class, this.objectFactory, (AndroidConfig)this.extension, variantApi, (TaskContainer)variantData);
        variantData.getOutputScope().getApkDatas().forEach(apkData -> {
            apkData.setVersionCode(variantData.getVariantConfiguration().getVersionCode());
            apkData.setVersionName(variantData.getVariantConfiguration().getVersionName());
            variantData.variantOutputFactory.create(apkData);
        });
    }
}

