/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.json;

import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonStreamingVisitor;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.Closeable;
import java.io.IOException;

public class AndroidBuildGradleJsonStreamingParser
implements Closeable {
    private final JsonReader reader;
    private final AndroidBuildGradleJsonStreamingVisitor visitor;

    public AndroidBuildGradleJsonStreamingParser(JsonReader reader, AndroidBuildGradleJsonStreamingVisitor visitor) {
        this.reader = reader;
        this.visitor = visitor;
    }

    public void parse() throws IOException {
        this.reader.beginObject();
        block16: while (this.reader.hasNext()) {
            String name;
            switch (name = this.reader.nextName()) {
                case "buildFiles": {
                    this.parseBuildFiles();
                    continue block16;
                }
                case "cleanCommands": {
                    this.parseCleanCommands();
                    continue block16;
                }
                case "cFileExtensions": {
                    this.parseCFileExtensions();
                    continue block16;
                }
                case "cppFileExtensions": {
                    this.parseCppFileExtensions();
                    continue block16;
                }
                case "libraries": {
                    this.parseLibraries();
                    continue block16;
                }
                case "toolchains": {
                    this.parseToolchains();
                    continue block16;
                }
            }
            this.parseUnknown();
        }
        this.reader.endObject();
    }

    private void parseUnknown() throws IOException {
        JsonToken peek = this.reader.peek();
        switch (peek) {
            case BEGIN_OBJECT: {
                this.parseUnknownObject();
                break;
            }
            case BEGIN_ARRAY: {
                this.parseUnknownArray();
                break;
            }
            case STRING: {
                this.reader.nextString();
                break;
            }
            case NAME: {
                this.reader.nextName();
                break;
            }
            case NULL: {
                this.reader.nextNull();
                break;
            }
            case NUMBER: {
                this.reader.nextString();
                break;
            }
            case BOOLEAN: {
                this.reader.nextBoolean();
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unexpected: Saw Gson token '%s' while parsing new and unrecognized Json section. ", peek.toString()));
            }
        }
    }

    private void parseUnknownArray() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            this.parseUnknown();
        }
        this.reader.endArray();
    }

    private void parseUnknownObject() throws IOException {
        this.reader.beginObject();
        while (this.reader.hasNext()) {
            this.parseUnknown();
        }
        this.reader.endObject();
    }

    private void parseLibraryObject() throws IOException {
        this.reader.beginObject();
        block22: while (this.reader.hasNext()) {
            String name;
            switch (name = this.reader.nextName()) {
                case "abi": {
                    this.visitor.visitLibraryAbi(this.reader.nextString());
                    continue block22;
                }
                case "artifactName": {
                    this.visitor.visitLibraryArtifactName(this.reader.nextString());
                    continue block22;
                }
                case "buildCommand": {
                    this.visitor.visitLibraryBuildCommand(this.reader.nextString());
                    continue block22;
                }
                case "buildType": {
                    this.visitor.visitLibraryBuildType(this.reader.nextString());
                    continue block22;
                }
                case "output": {
                    this.visitor.visitLibraryOutput(this.reader.nextString());
                    continue block22;
                }
                case "toolchain": {
                    this.visitor.visitLibraryToolchain(this.reader.nextString());
                    continue block22;
                }
                case "groupName": {
                    this.visitor.visitLibraryGroupName(this.reader.nextString());
                    continue block22;
                }
                case "files": {
                    this.parseLibraryFiles();
                    continue block22;
                }
                case "runtimeFiles": {
                    this.parseLibraryRuntimeFiles();
                    continue block22;
                }
            }
            this.parseUnknown();
        }
        this.reader.endObject();
    }

    private void parseToolchainObject() throws IOException {
        this.reader.beginObject();
        block8: while (this.reader.hasNext()) {
            String name;
            switch (name = this.reader.nextName()) {
                case "cCompilerExecutable": {
                    this.visitor.visitToolchainCCompilerExecutable(this.reader.nextString());
                    continue block8;
                }
                case "cppCompilerExecutable": {
                    this.visitor.visitToolchainCppCompilerExecutable(this.reader.nextString());
                    continue block8;
                }
            }
            this.parseUnknown();
        }
        this.reader.endObject();
    }

    private void parseLibraryFileObject() throws IOException {
        this.reader.beginObject();
        block10: while (this.reader.hasNext()) {
            String name;
            switch (name = this.reader.nextName()) {
                case "flags": {
                    this.visitor.visitLibraryFileFlags(this.reader.nextString());
                    continue block10;
                }
                case "src": {
                    this.visitor.visitLibraryFileSrc(this.reader.nextString());
                    continue block10;
                }
                case "workingDirectory": {
                    this.visitor.visitLibraryFileWorkingDirectory(this.reader.nextString());
                    continue block10;
                }
            }
            this.parseUnknown();
        }
        this.reader.endObject();
    }

    private void parseBuildFiles() throws IOException {
        this.reader.beginArray();
        block10: while (this.reader.hasNext()) {
            JsonToken peek = this.reader.peek();
            switch (this.reader.peek()) {
                case STRING: {
                    this.visitor.visitBuildFile(this.reader.nextString());
                    continue block10;
                }
                case BEGIN_OBJECT: {
                    String name;
                    this.reader.beginObject();
                    switch (name = this.reader.nextName()) {
                        case "path": {
                            this.visitor.visitBuildFile(this.reader.nextString());
                            break;
                        }
                        default: {
                            this.parseUnknown();
                        }
                    }
                    this.reader.endObject();
                    continue block10;
                }
            }
            this.parseUnknown();
        }
        this.reader.endArray();
    }

    private void parseCleanCommands() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            String value = this.reader.nextString();
            this.visitor.visitCleanCommands(value);
        }
        this.reader.endArray();
    }

    private void parseCFileExtensions() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            String value = this.reader.nextString();
            this.visitor.visitCFileExtensions(value);
        }
        this.reader.endArray();
    }

    private void parseCppFileExtensions() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            String value = this.reader.nextString();
            this.visitor.visitCppFileExtensions(value);
        }
        this.reader.endArray();
    }

    private void parseLibraries() throws IOException {
        this.reader.beginObject();
        while (this.reader.hasNext()) {
            String name = this.reader.nextName();
            this.visitor.beginLibrary(name);
            this.parseLibraryObject();
            this.visitor.endLibrary();
        }
        this.reader.endObject();
    }

    private void parseToolchains() throws IOException {
        this.reader.beginObject();
        while (this.reader.hasNext()) {
            String name = this.reader.nextName();
            this.visitor.beginToolchain(name);
            this.parseToolchainObject();
            this.visitor.endToolchain();
        }
        this.reader.endObject();
    }

    private void parseLibraryFiles() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            this.visitor.beginLibraryFile();
            this.parseLibraryFileObject();
            this.visitor.endLibraryFile();
        }
        this.reader.endArray();
    }

    private void parseLibraryRuntimeFiles() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            this.visitor.visitLibraryRuntimeFile(this.reader.nextString());
        }
        this.reader.endArray();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

