/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.builder.packaging.PackagingUtils;
import com.android.bundle.Config;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.tools.build.bundletool.commands.BuildBundleCommand;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 $2\u00020\u0001:\u0004#$%&B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010!\u001a\u00020\"H\u0007R2\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR&\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R&\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00138\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R&\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00198\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "", "", "aaptOptionsNoCompress", "getAaptOptionsNoCompress", "()Ljava/util/Collection;", "setAaptOptionsNoCompress", "(Ljava/util/Collection;)V", "Lcom/android/build/api/artifact/BuildableArtifact;", "baseModuleZip", "getBaseModuleZip", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setBaseModuleZip", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "Ljava/io/File;", "bundleFile", "getBundleFile", "()Ljava/io/File;", "setBundleFile", "(Ljava/io/File;)V", "Lorg/gradle/api/file/FileCollection;", "featureZips", "getFeatureZips", "()Lorg/gradle/api/file/FileCollection;", "setFeatureZips", "(Lorg/gradle/api/file/FileCollection;)V", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "bundleModules", "", "BundleToolRunnable", "Companion", "ConfigAction", "Params", "gradle"})
public class BundleTask
extends AndroidVariantTask {
    private final WorkerExecutorFacade workers;
    @NotNull
    private BuildableArtifact baseModuleZip;
    @NotNull
    private FileCollection featureZips;
    @NotNull
    private Collection<String> aaptOptionsNoCompress;
    @NotNull
    private File bundleFile;
    public static final Companion Companion = new Companion(null);

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final BuildableArtifact getBaseModuleZip() {
        BuildableArtifact buildableArtifact = this.baseModuleZip;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
        }
        return buildableArtifact;
    }

    private final void setBaseModuleZip(BuildableArtifact buildableArtifact) {
        this.baseModuleZip = buildableArtifact;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final FileCollection getFeatureZips() {
        FileCollection fileCollection = this.featureZips;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        return fileCollection;
    }

    private final void setFeatureZips(FileCollection fileCollection) {
        this.featureZips = fileCollection;
    }

    @Input
    @NotNull
    public final Collection<String> getAaptOptionsNoCompress() {
        Collection<String> collection = this.aaptOptionsNoCompress;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
        }
        return collection;
    }

    private final void setAaptOptionsNoCompress(Collection<String> collection) {
        this.aaptOptionsNoCompress = collection;
    }

    @OutputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final File getBundleFile() {
        File file = this.bundleFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        return file;
    }

    private final void setBundleFile(File file) {
        this.bundleFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void bundleModules() {
        Closeable closeable = (Closeable)this.workers;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            BuildableArtifact buildableArtifact = this.baseModuleZip;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
            }
            File file = BuildableArtifactUtil.singleFile(buildableArtifact);
            FileCollection fileCollection = this.featureZips;
            if (fileCollection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
            }
            Set set = fileCollection.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"featureZips.files");
            Collection<String> collection = this.aaptOptionsNoCompress;
            if (collection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
            }
            File file2 = this.bundleFile;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
            }
            it.submit(BundleToolRunnable.class, (Serializable)new Params(file, set, collection, file2));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public BundleTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workers = Workers.getWorker$default(Workers.INSTANCE, workerExecutor, null, 2, null);
    }

    @NotNull
    public static final /* synthetic */ File access$getBundleFile$p(BundleTask $this) {
        File file = $this.bundleFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        return file;
    }

    @NotNull
    public static final /* synthetic */ BuildableArtifact access$getBaseModuleZip$p(BundleTask $this) {
        BuildableArtifact buildableArtifact = $this.baseModuleZip;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
        }
        return buildableArtifact;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getFeatureZips$p(BundleTask $this) {
        FileCollection fileCollection = $this.featureZips;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        return fileCollection;
    }

    @NotNull
    public static final /* synthetic */ Collection access$getAaptOptionsNoCompress$p(BundleTask $this) {
        Collection<String> collection = $this.aaptOptionsNoCompress;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
        }
        return collection;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask$Params;", "Ljava/io/Serializable;", "baseModuleFile", "Ljava/io/File;", "featureFiles", "", "aaptOptionsNoCompress", "", "", "bundleFile", "(Ljava/io/File;Ljava/util/Set;Ljava/util/Collection;Ljava/io/File;)V", "getAaptOptionsNoCompress", "()Ljava/util/Collection;", "getBaseModuleFile", "()Ljava/io/File;", "getBundleFile", "getFeatureFiles", "()Ljava/util/Set;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle"})
    private static final class Params
    implements Serializable {
        @NotNull
        private final File baseModuleFile;
        @NotNull
        private final Set<File> featureFiles;
        @NotNull
        private final Collection<String> aaptOptionsNoCompress;
        @NotNull
        private final File bundleFile;

        @NotNull
        public final File getBaseModuleFile() {
            return this.baseModuleFile;
        }

        @NotNull
        public final Set<File> getFeatureFiles() {
            return this.featureFiles;
        }

        @NotNull
        public final Collection<String> getAaptOptionsNoCompress() {
            return this.aaptOptionsNoCompress;
        }

        @NotNull
        public final File getBundleFile() {
            return this.bundleFile;
        }

        public Params(@NotNull File baseModuleFile, @NotNull Set<? extends File> featureFiles, @NotNull Collection<String> aaptOptionsNoCompress, @NotNull File bundleFile) {
            Intrinsics.checkParameterIsNotNull((Object)baseModuleFile, (String)"baseModuleFile");
            Intrinsics.checkParameterIsNotNull(featureFiles, (String)"featureFiles");
            Intrinsics.checkParameterIsNotNull(aaptOptionsNoCompress, (String)"aaptOptionsNoCompress");
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            this.baseModuleFile = baseModuleFile;
            this.featureFiles = featureFiles;
            this.aaptOptionsNoCompress = aaptOptionsNoCompress;
            this.bundleFile = bundleFile;
        }

        @NotNull
        public final File component1() {
            return this.baseModuleFile;
        }

        @NotNull
        public final Set<File> component2() {
            return this.featureFiles;
        }

        @NotNull
        public final Collection<String> component3() {
            return this.aaptOptionsNoCompress;
        }

        @NotNull
        public final File component4() {
            return this.bundleFile;
        }

        @NotNull
        public final Params copy(@NotNull File baseModuleFile, @NotNull Set<? extends File> featureFiles, @NotNull Collection<String> aaptOptionsNoCompress, @NotNull File bundleFile) {
            Intrinsics.checkParameterIsNotNull((Object)baseModuleFile, (String)"baseModuleFile");
            Intrinsics.checkParameterIsNotNull(featureFiles, (String)"featureFiles");
            Intrinsics.checkParameterIsNotNull(aaptOptionsNoCompress, (String)"aaptOptionsNoCompress");
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            return new Params(baseModuleFile, featureFiles, aaptOptionsNoCompress, bundleFile);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Params copy$default(Params params, File file, Set set, Collection collection, File file2, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.baseModuleFile;
            }
            if ((n & 2) != 0) {
                set = params.featureFiles;
            }
            if ((n & 4) != 0) {
                collection = params.aaptOptionsNoCompress;
            }
            if ((n & 8) != 0) {
                file2 = params.bundleFile;
            }
            return params.copy(file, set, collection, file2);
        }

        public String toString() {
            return "Params(baseModuleFile=" + this.baseModuleFile + ", featureFiles=" + this.featureFiles + ", aaptOptionsNoCompress=" + this.aaptOptionsNoCompress + ", bundleFile=" + this.bundleFile + ")";
        }

        public int hashCode() {
            File file = this.baseModuleFile;
            Set<File> set = this.featureFiles;
            Collection<String> collection = this.aaptOptionsNoCompress;
            File file2 = this.bundleFile;
            return (((file != null ? ((Object)file).hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (collection != null ? ((Object)collection).hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.baseModuleFile, (Object)params.baseModuleFile) || !Intrinsics.areEqual(this.featureFiles, params.featureFiles) || !Intrinsics.areEqual(this.aaptOptionsNoCompress, params.aaptOptionsNoCompress) || !Intrinsics.areEqual((Object)this.bundleFile, (Object)params.bundleFile)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask$BundleToolRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/BundleTask$Params;", "(Lcom/android/build/gradle/internal/tasks/BundleTask$Params;)V", "getBundlePath", "Ljava/nio/file/Path;", "folder", "Ljava/io/File;", "run", "", "gradle"})
    private static final class BundleToolRunnable
    implements Runnable {
        private final Params params;

        @Override
        public void run() {
            File bundleFile = this.params.getBundleFile();
            FileUtils.mkdirs((File)bundleFile.getParentFile());
            if (bundleFile.isFile()) {
                FileUtils.delete((File)bundleFile);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)this.getBundlePath(this.params.getBaseModuleFile()));
            Iterable $receiver$iv = this.params.getFeatureFiles();
            for (Object element$iv : $receiver$iv) {
                File it = (File)element$iv;
                builder.add((Object)this.getBundlePath(it));
            }
            List noCompressGlobsForBundle = PackagingUtils.getNoCompressGlobsForBundle(this.params.getAaptOptionsNoCompress());
            Config.BundleConfig bundleConfig = Config.BundleConfig.newBuilder().setCompression(Config.Compression.newBuilder().addAllUncompressedGlob((Iterable)noCompressGlobsForBundle)).build();
            BuildBundleCommand.Builder command = BuildBundleCommand.builder().setBundleConfig(bundleConfig).setOutputPath(bundleFile.toPath()).setModulesPaths(builder.build());
            command.build().execute();
        }

        private final Path getBundlePath(File folder) {
            File[] children = folder.listFiles();
            Preconditions.checkNotNull((Object)children);
            Preconditions.checkState((((Object[])children).length == 1 ? 1 : 0) != 0);
            Path path = children[0].toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"children[0].toPath()");
            return path;
        }

        @Inject
        public BundleToolRunnable(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/tasks/BundleTask;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle"})
    public static final class ConfigAction
    implements TaskConfigAction<BundleTask> {
        private final VariantScope scope;

        @Override
        @NotNull
        public String getName() {
            return Companion.getTaskName(this.scope);
        }

        @Override
        @NotNull
        public Class<BundleTask> getType() {
            return BundleTask.class;
        }

        @Override
        public void execute(@NotNull BundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            task.setVariantName(this.scope.getFullVariantName());
            task.bundleFile = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.BUNDLE, (Task)task, "bundle.aab");
            task.baseModuleZip = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MODULE_BUNDLE);
            FileCollection fileCollection = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MODULE_BUNDLE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"scope.getArtifactFileCol\u2026DULE_BUNDLE\n            )");
            task.featureZips = fileCollection;
            BundleTask bundleTask = task;
            GlobalScope globalScope = this.scope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"scope.globalScope");
            AndroidConfig androidConfig = globalScope.getExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidConfig, (String)"scope.globalScope.extension");
            AaptOptions aaptOptions = androidConfig.getAaptOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)aaptOptions, (String)"scope.globalScope.extension.aaptOptions");
            Collection collection = aaptOptions.getNoCompress();
            if (collection == null) {
                BundleTask bundleTask2 = bundleTask;
                List list = CollectionsKt.emptyList();
                bundleTask = bundleTask2;
                collection = list;
            }
            bundleTask.aaptOptionsNoCompress = collection;
        }

        public ConfigAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            this.scope = scope;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask$Companion;", "", "()V", "getTaskName", "", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "gradle"})
    public static final class Companion {
        @NotNull
        public final String getTaskName(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            return scope.getTaskName("bundle");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

