/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.PreDexCallable;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.builder.dexing.DexingType;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.utils.FileCache;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class PreDexTransform
extends Transform {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(PreDexTransform.class);
    private final DexOptions dexOptions;
    private final AndroidBuilder androidBuilder;
    private final FileCache buildCache;
    private final DexingType dexingType;
    private final int minSdkVersion;

    public PreDexTransform(DexOptions dexOptions, AndroidBuilder androidBuilder, FileCache buildCache, DexingType dexingType, int minSdkVersion) {
        this.dexOptions = dexOptions;
        this.androidBuilder = androidBuilder;
        this.buildCache = buildCache;
        this.dexingType = dexingType;
        this.minSdkVersion = minSdkVersion;
    }

    public String getName() {
        return "preDex";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return TransformManager.CONTENT_DEX;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_WITH_IR_FOR_DEXING;
    }

    public Map<String, Object> getParameterInputs() {
        try {
            HashMap params = Maps.newHashMapWithExpectedSize((int)7);
            params.put("optimize", true);
            params.put("jumbo", this.dexOptions.getJumboMode());
            params.put("multidex-mode", this.dexingType.name());
            params.put("java-max-heap-size", this.dexOptions.getJavaMaxHeapSize());
            params.put("additional-parameters", Iterables.toString((Iterable)this.dexOptions.getAdditionalParameters()));
            TargetInfo targetInfo = this.androidBuilder.getTargetInfo();
            Preconditions.checkState((targetInfo != null ? 1 : 0) != 0, (String)"androidBuilder.targetInfo required for task '%s'.", (Object)this.getName());
            BuildToolInfo buildTools = targetInfo.getBuildTools();
            params.put("build-tools", buildTools.getRevision().toString());
            params.put("min-sdk-version", this.minSdkVersion);
            return params;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, IOException, InterruptedException {
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)"Missing output provider.");
        ArrayList jarInputs = Lists.newArrayList();
        ArrayList directoryInputs = Lists.newArrayList();
        for (TransformInput input : transformInvocation.getInputs()) {
            jarInputs.addAll(input.getJarInputs());
            directoryInputs.addAll(input.getDirectoryInputs());
        }
        logger.verbose("Task is incremental : %b ", transformInvocation.isIncremental());
        logger.verbose("JarInputs %s", Joiner.on((String)",").join((Iterable)jarInputs));
        logger.verbose("DirInputs %s", Joiner.on((String)",").join((Iterable)directoryInputs));
        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)logger), new MessageReceiver[]{this.androidBuilder.getMessageReceiver()});
        if (!transformInvocation.isIncremental()) {
            outputProvider.deleteAll();
        }
        try {
            HashSet hashes = Sets.newHashSet();
            HashMap inputFiles = Maps.newHashMap();
            ArrayList deletedFiles = Lists.newArrayList();
            HashSet externalLibJarFiles = Sets.newHashSet();
            for (DirectoryInput directoryInput : directoryInputs) {
                File rootFolder = directoryInput.getFile();
                if (!rootFolder.exists()) {
                    File preDexedFile = this.getPreDexFile(outputProvider, (QualifiedContent)directoryInput);
                    if (!preDexedFile.exists()) continue;
                    deletedFiles.add(preDexedFile);
                    continue;
                }
                if (transformInvocation.isIncremental() && directoryInput.getChangedFiles().isEmpty()) continue;
                logger.verbose("Changed file for %s are %s", directoryInput.getFile().getAbsolutePath(), Joiner.on((String)",").join(directoryInput.getChangedFiles().entrySet()));
                File preDexFile = this.getPreDexFile(outputProvider, (QualifiedContent)directoryInput);
                inputFiles.put(rootFolder, preDexFile);
            }
            for (JarInput jarInput : jarInputs) {
                switch (jarInput.getStatus()) {
                    case NOTCHANGED: {
                        if (transformInvocation.isIncremental()) break;
                    }
                    case CHANGED: 
                    case ADDED: {
                        File preDexFile = this.getPreDexFile(outputProvider, (QualifiedContent)jarInput);
                        inputFiles.put(jarInput.getFile(), preDexFile);
                        if (!jarInput.getScopes().equals(Collections.singleton(QualifiedContent.Scope.EXTERNAL_LIBRARIES))) break;
                        externalLibJarFiles.add(jarInput.getFile());
                        break;
                    }
                    case REMOVED: {
                        File preDexedFile = this.getPreDexFile(outputProvider, (QualifiedContent)jarInput);
                        if (!preDexedFile.exists()) break;
                        deletedFiles.add(preDexedFile);
                        break;
                    }
                }
            }
            logger.verbose("inputFiles : %s", Joiner.on((String)",").join(inputFiles.keySet()));
            WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
            for (Map.Entry entry : inputFiles.entrySet()) {
                FileCache usedBuildCache = PreDexTransform.getBuildCache((File)entry.getKey(), externalLibJarFiles.contains(entry.getKey()), this.buildCache);
                PreDexCallable action2 = new PreDexCallable((File)entry.getKey(), (File)entry.getValue(), hashes, (ProcessOutputHandler)outputHandler, usedBuildCache, this.dexingType, this.dexOptions, this.androidBuilder, this.minSdkVersion);
                logger.verbose("Adding PreDexCallable for %s : %s", entry.getKey(), action2);
                executor.execute((Callable)action2);
            }
            for (File file : deletedFiles) {
                executor.execute(() -> {
                    FileUtils.deletePath((File)file);
                    return null;
                });
            }
            executor.waitForTasksWithQuickFail(false);
            logger.verbose("Done with all dexing", new Object[0]);
        }
        catch (Exception e) {
            throw new TransformException((Throwable)e);
        }
    }

    static FileCache getBuildCache(File inputFile, boolean isExternalLib, FileCache buildCache) {
        if (buildCache == null || !isExternalLib) {
            return null;
        }
        if (inputFile.getPath().contains("-SNAPSHOT")) {
            return null;
        }
        return buildCache;
    }

    private File getPreDexFile(TransformOutputProvider output2, QualifiedContent qualifiedContent) {
        File contentLocation = output2.getContentLocation(qualifiedContent.getName(), TransformManager.CONTENT_DEX, qualifiedContent.getScopes(), this.dexingType.isMultiDex() ? Format.DIRECTORY : Format.JAR);
        if (this.dexingType.isMultiDex()) {
            FileUtils.mkdirs((File)contentLocation);
        } else {
            FileUtils.mkdirs((File)contentLocation.getParentFile());
        }
        return contentLocation;
    }

    static String getInstantRunFileName(File inputFile) {
        if (inputFile.isDirectory()) {
            return inputFile.getName();
        }
        return inputFile.getName().replace(".", "_");
    }

    static String getFilename(File inputFile, DexingType dexingType) {
        String suffix = dexingType.isMultiDex() ? "" : ".jar";
        return FileUtils.getDirectoryNameForJar((File)inputFile) + suffix;
    }
}

