/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.ide.AaptOptionsImpl;
import com.android.build.gradle.internal.ide.AndroidArtifactImpl;
import com.android.build.gradle.internal.ide.ArtifactDependencyGraph;
import com.android.build.gradle.internal.ide.ArtifactMetaDataImpl;
import com.android.build.gradle.internal.ide.BuildOutputSupplier;
import com.android.build.gradle.internal.ide.BuildOutputsSupplier;
import com.android.build.gradle.internal.ide.BuildTypeContainerImpl;
import com.android.build.gradle.internal.ide.DefaultAndroidProject;
import com.android.build.gradle.internal.ide.DefaultProjectBuildOutput;
import com.android.build.gradle.internal.ide.DefaultTestVariantBuildOutput;
import com.android.build.gradle.internal.ide.DefaultVariantBuildOutput;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.EarlySyncBuildOutput;
import com.android.build.gradle.internal.ide.InstantRunImpl;
import com.android.build.gradle.internal.ide.JavaArtifactImpl;
import com.android.build.gradle.internal.ide.NativeToolchainImpl;
import com.android.build.gradle.internal.ide.ProductFlavorContainerImpl;
import com.android.build.gradle.internal.ide.ProductFlavorImpl;
import com.android.build.gradle.internal.ide.SigningConfigImpl;
import com.android.build.gradle.internal.ide.SourceProviderImpl;
import com.android.build.gradle.internal.ide.SyncIssueImpl;
import com.android.build.gradle.internal.ide.TestOptionsImpl;
import com.android.build.gradle.internal.ide.TestedTargetVariantImpl;
import com.android.build.gradle.internal.ide.VariantImpl;
import com.android.build.gradle.internal.ide.level2.EmptyDependencyGraphs;
import com.android.build.gradle.internal.ide.level2.GlobalLibraryMapImpl;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.tasks.ExtractApksTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.ProjectBuildOutput;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.TestVariantBuildOutput;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.Variant;
import com.android.builder.model.VariantBuildOutput;
import com.android.builder.model.Version;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.ide.common.build.ApkInfo;
import com.android.utils.Pair;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.invocation.Gradle;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;

public class ModelBuilder<Extension extends AndroidConfig>
implements ParameterizedToolingModelBuilder<ModelBuilderParameter> {
    public static final String CURRENT_BUILD_NAME = "__current_build__";
    static final DependenciesImpl EMPTY_DEPENDENCIES_IMPL = new DependenciesImpl((List<AndroidLibrary>)ImmutableList.of(), (List<JavaLibrary>)ImmutableList.of(), (List<Dependencies.ProjectIdentifier>)ImmutableList.of());
    static final DependencyGraphs EMPTY_DEPENDENCY_GRAPH = new EmptyDependencyGraphs();
    protected final GlobalScope globalScope;
    private final AndroidBuilder androidBuilder;
    protected final Extension extension;
    private final ExtraModelInfo extraModelInfo;
    private final VariantManager variantManager;
    private final TaskManager taskManager;
    private final NdkHandler ndkHandler;
    private Map<Abi, NativeToolchain> toolchains;
    private NativeLibraryFactory nativeLibFactory;
    private final int projectType;
    private final int generation;
    private int modelLevel = 0;
    private boolean modelWithFullDependency = false;
    private ImmutableMap<String, String> buildMapping = null;
    private Set<SyncIssue> syncIssues = Sets.newLinkedHashSet();

    public ModelBuilder(GlobalScope globalScope, AndroidBuilder androidBuilder, VariantManager variantManager, TaskManager taskManager, Extension extension, ExtraModelInfo extraModelInfo, NdkHandler ndkHandler, NativeLibraryFactory nativeLibraryFactory, int projectType, int generation) {
        this.globalScope = globalScope;
        this.androidBuilder = androidBuilder;
        this.extension = extension;
        this.extraModelInfo = extraModelInfo;
        this.variantManager = variantManager;
        this.taskManager = taskManager;
        this.ndkHandler = ndkHandler;
        this.nativeLibFactory = nativeLibraryFactory;
        this.projectType = projectType;
        this.generation = generation;
    }

    public static void clearCaches() {
        ArtifactDependencyGraph.clearCaches();
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(AndroidProject.class.getName()) || modelName.equals(GlobalLibraryMap.class.getName()) || modelName.equals(ProjectBuildOutput.class.getName()) || modelName.equals(Variant.class.getName());
    }

    public Object buildAll(String modelName, Project project) {
        this.initBuildMapping(project);
        if (modelName.equals(AndroidProject.class.getName())) {
            return this.buildAndroidProject(project, true);
        }
        if (modelName.equals(Variant.class.getName())) {
            throw new RuntimeException("Please use parameterized tooling API to obtain Variant model.");
        }
        return this.buildNonParameterizedModels(modelName);
    }

    public Object buildAll(String modelName, ModelBuilderParameter parameter, Project project) {
        this.initBuildMapping(project);
        if (modelName.equals(AndroidProject.class.getName())) {
            return this.buildAndroidProject(project, parameter.getShouldBuildVariant());
        }
        if (modelName.equals(Variant.class.getName())) {
            return this.buildVariant(parameter.getVariantName());
        }
        return this.buildNonParameterizedModels(modelName);
    }

    private Object buildNonParameterizedModels(String modelName) {
        if (modelName.equals(ProjectBuildOutput.class.getName())) {
            return this.buildMinimalisticModel();
        }
        return ModelBuilder.buildGlobalLibraryMap();
    }

    public Class<ModelBuilderParameter> getParameterType() {
        return ModelBuilderParameter.class;
    }

    ProjectBuildOutput buildMinimalisticModel() {
        boolean isTestComponent;
        ImmutableList.Builder variantsOutput = ImmutableList.builder();
        ArrayListMultimap sortedVariants = ArrayListMultimap.create();
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            isTestComponent = variantScope.getVariantData().getType().isTestComponent();
            if (!isTestComponent || variantScope.getTestedVariantData() == null) continue;
            sortedVariants.put((Object)variantScope.getTestedVariantData().getScope(), (Object)variantScope);
        }
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            isTestComponent = variantScope.getType().isTestComponent();
            if (isTestComponent) continue;
            Collection testingVariants = sortedVariants.get((Object)variantScope);
            Object testVariantBuildOutputs = testingVariants == null ? ImmutableList.of() : (Collection)testingVariants.stream().map(testVariantScope -> new DefaultTestVariantBuildOutput(testVariantScope.getFullVariantName(), (Collection)ModelBuilder.getBuildOutputSupplier(testVariantScope.getVariantData()).get(), variantScope.getFullVariantName(), testVariantScope.getType() == VariantTypeImpl.ANDROID_TEST ? TestVariantBuildOutput.TestType.ANDROID_TEST : TestVariantBuildOutput.TestType.UNIT)).collect(Collectors.toList());
            variantsOutput.add((Object)new DefaultVariantBuildOutput(variantScope.getFullVariantName(), (Collection)ModelBuilder.getBuildOutputSupplier(variantScope.getVariantData()).get(), (Collection<TestVariantBuildOutput>)testVariantBuildOutputs));
        }
        return new DefaultProjectBuildOutput((ImmutableList<VariantBuildOutput>)variantsOutput.build());
    }

    private static Object buildGlobalLibraryMap() {
        return new GlobalLibraryMapImpl(ArtifactDependencyGraph.getGlobalLibMap());
    }

    private Object buildAndroidProject(Project project, boolean shouldBuildVariant) {
        ProjectOptions projectOptions = new ProjectOptions(project);
        Integer modelLevelInt = SyncOptions.buildModelOnlyVersion(projectOptions);
        if (modelLevelInt != null) {
            this.modelLevel = modelLevelInt;
        }
        if (this.modelLevel < 3) {
            throw new RuntimeException("This Gradle plugin requires a newer IDE able to request IDE model level 3. For Android Studio this means version 3.0+");
        }
        this.modelWithFullDependency = projectOptions.get(BooleanOption.IDE_BUILD_MODEL_FEATURE_FULL_DEPENDENCIES);
        List bootClasspath = this.androidBuilder.getTargetInfo() != null ? this.androidBuilder.getBootClasspathAsStrings(false) : Collections.emptyList();
        List<File> frameworkSource = Collections.emptyList();
        ArrayList artifactMetaDataList = Lists.newArrayList(this.extraModelInfo.getExtraArtifacts());
        for (VariantType variantType : VariantType.Companion.getTestComponents()) {
            artifactMetaDataList.add(new ArtifactMetaDataImpl(variantType.getArtifactName(), true, variantType.getArtifactType()));
        }
        com.android.builder.model.LintOptions lintOptions = LintOptions.create(this.extension.getLintOptions());
        AaptOptions aaptOptions = AaptOptionsImpl.create(this.extension.getAaptOptions());
        this.syncIssues.addAll((Collection<SyncIssue>)this.extraModelInfo.getSyncIssueHandler().getSyncIssues());
        ArrayList flavorDimensionList = this.extension.getFlavorDimensionList() != null ? this.extension.getFlavorDimensionList() : Lists.newArrayList();
        this.toolchains = ModelBuilder.createNativeToolchainModelMap(this.ndkHandler);
        ProductFlavorContainer defaultConfig2 = ProductFlavorContainerImpl.createProductFlavorContainer(this.variantManager.getDefaultConfig(), this.extraModelInfo.getExtraFlavorSourceProviders(this.variantManager.getDefaultConfig().getProductFlavor().getName()));
        ArrayList buildTypes = Lists.newArrayList();
        ArrayList productFlavors = Lists.newArrayList();
        ArrayList variants = Lists.newArrayList();
        ArrayList variantNames = Lists.newArrayList();
        for (BuildTypeData buildTypeData : this.variantManager.getBuildTypes().values()) {
            buildTypes.add(BuildTypeContainerImpl.create(buildTypeData, this.extraModelInfo.getExtraBuildTypeSourceProviders(buildTypeData.getBuildType().getName())));
        }
        for (ProductFlavorData productFlavorData : this.variantManager.getProductFlavors().values()) {
            productFlavors.add(ProductFlavorContainerImpl.createProductFlavorContainer(productFlavorData, this.extraModelInfo.getExtraFlavorSourceProviders(productFlavorData.getProductFlavor().getName())));
        }
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            if (variantScope.getVariantData().getType().isTestComponent()) continue;
            variantNames.add(variantScope.getFullVariantName());
            if (!shouldBuildVariant) continue;
            variants.add(this.createVariant(variantScope.getVariantData()));
        }
        return new DefaultAndroidProject(project.getName(), defaultConfig2, flavorDimensionList, buildTypes, productFlavors, variants, variantNames, this.androidBuilder.getTargetInfo() != null ? this.androidBuilder.getTarget().hashString() : "", bootClasspath, frameworkSource, ModelBuilder.cloneSigningConfigs(this.extension.getSigningConfigs()), aaptOptions, artifactMetaDataList, this.syncIssues, this.extension.getCompileOptions(), lintOptions, project.getBuildDir(), this.extension.getResourcePrefix(), (Collection<NativeToolchain>)ImmutableList.copyOf(this.toolchains.values()), this.extension.getBuildToolsVersion(), this.projectType, Version.BUILDER_MODEL_API_VERSION, this.generation, this.isBaseSplit(), this.getDynamicFeatures());
    }

    protected boolean isBaseSplit() {
        return false;
    }

    protected Collection<String> getDynamicFeatures() {
        return ImmutableList.of();
    }

    public static Map<Abi, NativeToolchain> createNativeToolchainModelMap(NdkHandler ndkHandler) {
        if (!ndkHandler.isConfigured()) {
            return ImmutableMap.of();
        }
        HashMap toolchains = Maps.newHashMap();
        for (Abi abi : ndkHandler.getSupportedAbis()) {
            toolchains.put(abi, new NativeToolchainImpl(ndkHandler.getToolchain().getName() + "-" + abi.getName(), ndkHandler.getCCompiler(abi), ndkHandler.getCppCompiler(abi)));
        }
        return toolchains;
    }

    private VariantImpl buildVariant(String variantName) {
        if (variantName == null) {
            throw new IllegalArgumentException("Variant name cannot be null.");
        }
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            if (variantScope.getVariantData().getType().isTestComponent() || !variantScope.getFullVariantName().equals(variantName)) continue;
            return this.createVariant(variantScope.getVariantData());
        }
        throw new IllegalArgumentException(String.format("Variant with name '%s' doesn't exist.", variantName));
    }

    private VariantImpl createVariant(BaseVariantData variantData) {
        AndroidArtifact mainArtifact = this.createAndroidArtifact("_main_", variantData);
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        File manifest = variantConfiguration.getMainManifest();
        if (manifest != null) {
            DefaultManifestParser attributeSupplier = new DefaultManifestParser(manifest, () -> true);
            this.validateMinSdkVersion((ManifestAttributeSupplier)attributeSupplier);
            this.validateTargetSdkVersion((ManifestAttributeSupplier)attributeSupplier);
        }
        String variantName = variantConfiguration.getFullName();
        ArrayList extraAndroidArtifacts = Lists.newArrayList(this.extraModelInfo.getExtraAndroidArtifacts(variantName));
        List<JavaArtifact> clonedExtraJavaArtifacts = this.extraModelInfo.getExtraJavaArtifacts(variantName).stream().map(javaArtifact -> JavaArtifactImpl.clone(javaArtifact, this.modelLevel, this.modelWithFullDependency)).collect(Collectors.toList());
        if (variantData instanceof TestedVariantData) {
            block4: for (VariantType variantType : VariantType.Companion.getTestComponents()) {
                TestVariantData testVariantData = ((TestedVariantData)((Object)variantData)).getTestVariantData(variantType);
                if (testVariantData == null) continue;
                switch ((VariantTypeImpl)variantType) {
                    case ANDROID_TEST: {
                        extraAndroidArtifacts.add(this.createAndroidArtifact(variantType.getArtifactName(), testVariantData));
                        continue block4;
                    }
                    case UNIT_TEST: {
                        clonedExtraJavaArtifacts.add(this.createUnitTestsJavaArtifact(variantType, testVariantData));
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Unsupported test variant type ${variantType}.");
            }
        }
        Collection<TestedTargetVariant> testTargetVariants = this.getTestTargetVariants(variantData);
        return new VariantImpl(variantName, variantConfiguration.getBaseName(), ((CoreBuildType)variantConfiguration.getBuildType()).getName(), ModelBuilder.getProductFlavorNames(variantData), new ProductFlavorImpl(variantConfiguration.getMergedFlavor()), mainArtifact, extraAndroidArtifacts, clonedExtraJavaArtifacts, testTargetVariants);
    }

    private Collection<TestedTargetVariant> getTestTargetVariants(BaseVariantData variantData) {
        if (this.extension instanceof TestAndroidConfig) {
            TestAndroidConfig testConfig = (TestAndroidConfig)this.extension;
            ArtifactCollection apkArtifacts = variantData.getScope().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST_METADATA);
            if (apkArtifacts.getArtifacts().size() == 1) {
                ResolvedArtifactResult result = (ResolvedArtifactResult)Iterables.getOnlyElement((Iterable)apkArtifacts.getArtifacts());
                String variant = ArtifactDependencyGraph.getVariant(result);
                return ImmutableList.of((Object)new TestedTargetVariantImpl(testConfig.getTargetProjectPath(), variant));
            }
            if (!apkArtifacts.getFailures().isEmpty()) {
                VariantScope variantScope = variantData.getScope();
                this.syncIssues.addAll(new DependencyFailureHandler().addErrors(variantScope.getGlobalScope().getProject().getPath() + "@" + variantScope.getFullVariantName() + "/testTarget", apkArtifacts.getFailures()).collectIssues());
            }
        }
        return ImmutableList.of();
    }

    private JavaArtifactImpl createUnitTestsJavaArtifact(VariantType variantType, BaseVariantData variantData) {
        VariantScope testedScope;
        SourceProviders sourceProviders = ModelBuilder.determineSourceProviders(variantData);
        VariantScope scope = variantData.getScope();
        Pair<Dependencies, DependencyGraphs> result = ModelBuilder.getDependencies(scope, this.buildMapping, this.extraModelInfo, this.syncIssues, this.modelLevel, this.modelWithFullDependency);
        HashSet<File> additionalTestClasses = new HashSet<File>();
        additionalTestClasses.addAll(variantData.getAllPreJavacGeneratedBytecode().getFiles());
        additionalTestClasses.addAll(variantData.getAllPostJavacGeneratedBytecode().getFiles());
        if (scope.getArtifacts().hasArtifact(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY)) {
            additionalTestClasses.add(BuildableArtifactUtil.singleFile(scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY)));
        }
        if ((testedScope = Objects.requireNonNull(scope.getTestedVariantData()).getScope()).getArtifacts().hasArtifact(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR)) {
            additionalTestClasses.add((File)Iterables.getOnlyElement((Iterable)testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR)));
        }
        return new JavaArtifactImpl(variantType.getArtifactName(), scope.getAssembleTask().getName(), scope.getCompileTask().getName(), Sets.newHashSet((Object[])new String[]{this.taskManager.createMockableJar.getName()}), ModelBuilder.getGeneratedSourceFoldersForUnitTests(variantData), (File)Iterables.getOnlyElement((Iterable)scope.getArtifacts().getArtifactFiles(InternalArtifactType.JAVAC)), additionalTestClasses, variantData.getJavaResourcesForUnitTesting(), this.globalScope.getMockableJarArtifact().getSingleFile(), (Dependencies)result.getFirst(), (DependencyGraphs)result.getSecond(), sourceProviders.variantSourceProvider, sourceProviders.multiFlavorSourceProvider);
    }

    public static Pair<Dependencies, DependencyGraphs> getDependencies(VariantScope variantScope, ImmutableMap<String, String> buildMapping, ExtraModelInfo extraModelInfo, Set<SyncIssue> syncIssues, int modelLevel, boolean modelWithFullDependency) {
        Pair result;
        if (extraModelInfo.getSyncIssueHandler().hasSyncIssue(EvalIssueReporter.Type.UNNAMED_FLAVOR_DIMENSION)) {
            result = Pair.of((Object)EMPTY_DEPENDENCIES_IMPL, (Object)EMPTY_DEPENDENCY_GRAPH);
        } else {
            boolean downloadSources;
            Project project = variantScope.getGlobalScope().getProject();
            ArtifactDependencyGraph graph = new ArtifactDependencyGraph();
            boolean bl = downloadSources = !project.hasProperty("android.injected.build.model.disable.src.download") || !Boolean.TRUE.equals(project.getProperties().get("android.injected.build.model.disable.src.download"));
            result = modelLevel >= 4 ? Pair.of((Object)EMPTY_DEPENDENCIES_IMPL, (Object)graph.createLevel4DependencyGraph(variantScope, modelWithFullDependency, downloadSources, buildMapping, syncIssues::add)) : Pair.of((Object)graph.createDependencies(variantScope, downloadSources, buildMapping, syncIssues::add), (Object)EMPTY_DEPENDENCY_GRAPH);
        }
        return result;
    }

    private Collection<NativeLibrary> createNativeLibraries(Collection<Abi> abis, VariantScope scope) {
        ArrayList nativeLibraries = Lists.newArrayListWithCapacity((int)abis.size());
        for (Abi abi : abis) {
            Optional<NativeLibrary> lib;
            NativeToolchain toolchain = this.toolchains.get((Object)abi);
            if (toolchain == null || !(lib = this.nativeLibFactory.create(scope, toolchain.getName(), abi)).isPresent()) continue;
            nativeLibraries.add(lib.get());
        }
        return nativeLibraries;
    }

    private AndroidArtifact createAndroidArtifact(String name, BaseVariantData variantData) {
        String applicationId;
        VariantScope scope = variantData.getScope();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        CoreSigningConfig signingConfig = variantConfiguration.getSigningConfig();
        String signingConfigName = null;
        if (signingConfig != null) {
            signingConfigName = signingConfig.getName();
        }
        SourceProviders sourceProviders = ModelBuilder.determineSourceProviders(variantData);
        BuildOutputSupplier<Collection<EarlySyncBuildOutput>> splitOutputsProxy = ModelBuilder.getBuildOutputSupplier(variantData);
        BuildOutputSupplier<Collection<EarlySyncBuildOutput>> manifestsProxy = ModelBuilder.getManifestsSupplier(variantData);
        CoreNdkOptions ndkConfig = variantData.getVariantConfiguration().getNdkConfig();
        Object nativeLibraries = ImmutableList.of();
        if (this.ndkHandler.isConfigured()) {
            nativeLibraries = this.extension.getSplits().getAbi().isEnable() ? this.createNativeLibraries(this.extension.getSplits().getAbi().isUniversalApk() ? this.ndkHandler.getSupportedAbis() : ModelBuilder.createAbiList(this.extension.getSplits().getAbiFilters()), scope) : (ndkConfig.getAbiFilters() == null || ndkConfig.getAbiFilters().isEmpty() ? this.createNativeLibraries(this.ndkHandler.getSupportedAbis(), scope) : this.createNativeLibraries(ModelBuilder.createAbiList(ndkConfig.getAbiFilters()), scope));
        }
        InstantRunImpl instantRun = new InstantRunImpl(BuildInfoWriterTask.ConfigAction.getBuildInfoFile(scope), variantConfiguration.getInstantRunSupportStatus(this.globalScope));
        Pair<Dependencies, DependencyGraphs> dependencies = ModelBuilder.getDependencies(scope, this.buildMapping, this.extraModelInfo, this.syncIssues, this.modelLevel, this.modelWithFullDependency);
        HashSet<File> additionalTestClasses = new HashSet<File>();
        additionalTestClasses.addAll(variantData.getAllPreJavacGeneratedBytecode().getFiles());
        additionalTestClasses.addAll(variantData.getAllPostJavacGeneratedBytecode().getFiles());
        ArrayList<File> additionalRuntimeApks = new ArrayList<File>();
        TestOptionsImpl testOptions = null;
        if (variantData.getType().isTestComponent()) {
            Configuration testHelpers = (Configuration)scope.getGlobalScope().getProject().getConfigurations().findByName("androidTestUtil");
            if (testHelpers != null) {
                additionalRuntimeApks.addAll(testHelpers.getFiles());
            }
            DeviceProviderInstrumentTestTask.checkForNonApks(additionalRuntimeApks, message -> this.syncIssues.add(new SyncIssueImpl(EvalIssueReporter.Type.GENERIC, EvalIssueReporter.Severity.ERROR, null, (String)message)));
            TestOptions testOptionsDsl = scope.getGlobalScope().getExtension().getTestOptions();
            testOptions = new TestOptionsImpl(testOptionsDsl.getAnimationsDisabled(), testOptionsDsl.getExecutionEnum());
        }
        try {
            applicationId = variantConfiguration.getApplicationId();
        }
        catch (RuntimeException e) {
            applicationId = "";
            this.syncIssues.add(new SyncIssueImpl(EvalIssueReporter.Type.GENERIC, EvalIssueReporter.Severity.ERROR, null, e.getMessage()));
        }
        return new AndroidArtifactImpl(name, scope.getGlobalScope().getProjectBaseName() + "-" + variantConfiguration.getBaseName(), variantData.getTaskByKind(TaskContainer.TaskKind.ASSEMBLE) == null ? scope.getTaskName("assemble") : variantData.getTaskByKind(TaskContainer.TaskKind.ASSEMBLE).getName(), variantConfiguration.isSigningReady() || variantData.outputsAreSigned, signingConfigName, applicationId, scope.getSourceGenTask() == null ? scope.getTaskName("generate", "Sources") : scope.getSourceGenTask().getName(), scope.getCompileTask() == null ? scope.getTaskName("compile", "Sources") : scope.getCompileTask().getName(), ModelBuilder.getGeneratedSourceFolders(variantData), ModelBuilder.getGeneratedResourceFolders(variantData), (File)Iterables.getOnlyElement((Iterable)scope.getArtifacts().getArtifactFiles(InternalArtifactType.JAVAC)), additionalTestClasses, scope.getVariantData().getJavaResourcesForUnitTesting(), (Dependencies)dependencies.getFirst(), (DependencyGraphs)dependencies.getSecond(), additionalRuntimeApks, sourceProviders.variantSourceProvider, sourceProviders.multiFlavorSourceProvider, variantConfiguration.getSupportedAbis(), (Collection<NativeLibrary>)nativeLibraries, variantConfiguration.getMergedBuildConfigFields(), variantConfiguration.getMergedResValues(), instantRun, splitOutputsProxy, manifestsProxy, testOptions, scope.getConnectedTask() == null ? null : scope.getConnectedTask().getName(), variantData.getTaskByKind(TaskContainer.TaskKind.BUNDLE) == null ? scope.getTaskName("bundle") : variantData.getTaskByKind(TaskContainer.TaskKind.BUNDLE).getName(), ExtractApksTask.Companion.getTaskName(scope));
    }

    private void validateMinSdkVersion(ManifestAttributeSupplier supplier) {
        if (supplier.getMinSdkVersion() != null) {
            this.syncIssues.add(new SyncIssueImpl(EvalIssueReporter.Type.MIN_SDK_VERSION_IN_MANIFEST, EvalIssueReporter.Severity.ERROR, null, "The minSdk version should not be declared in the android manifest file. You can move the version from the manifest to the defaultConfig in the build.gradle file."));
        }
    }

    private void validateTargetSdkVersion(ManifestAttributeSupplier supplier) {
        if (supplier.getTargetSdkVersion() != null) {
            this.syncIssues.add(new SyncIssueImpl(EvalIssueReporter.Type.TARGET_SDK_VERSION_IN_MANIFEST, EvalIssueReporter.Severity.WARNING, null, "The targetSdk version should not be declared in the android manifest file. You can move the version from the manifest to the defaultConfig in the build.gradle file."));
        }
    }

    private static BuildOutputSupplier<Collection<EarlySyncBuildOutput>> getBuildOutputSupplier(BaseVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        VariantTypeImpl variantType = (VariantTypeImpl)variantData.getType();
        switch (variantType) {
            case BASE_APK: 
            case OPTIONAL_APK: 
            case BASE_FEATURE: 
            case FEATURE: 
            case TEST_APK: {
                return new BuildOutputsSupplier((List<ArtifactType>)ImmutableList.of((Object)((Object)InternalArtifactType.APK), (Object)((Object)InternalArtifactType.ABI_PACKAGED_SPLIT), (Object)((Object)InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT)), (List<File>)ImmutableList.of((Object)variantScope.getApkLocation()));
            }
            case LIBRARY: {
                ApkInfo mainApkInfo = ApkInfo.of((VariantOutput.OutputType)VariantOutput.OutputType.MAIN, (Collection)ImmutableList.of(), (int)0);
                return BuildOutputSupplier.of(ImmutableList.of((Object)new EarlySyncBuildOutput(InternalArtifactType.AAR, mainApkInfo.getType(), mainApkInfo.getFilters(), mainApkInfo.getVersionCode(), BuildableArtifactUtil.singleFile(variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.AAR)))));
            }
            case ANDROID_TEST: {
                return new BuildOutputsSupplier((List<ArtifactType>)ImmutableList.of((Object)((Object)InternalArtifactType.APK)), (List<File>)ImmutableList.of((Object)variantScope.getApkLocation()));
            }
            case UNIT_TEST: {
                return () -> {
                    BaseVariantData testedVariantData = variantScope.getTestedVariantData();
                    VariantScope testedVariantScope = testedVariantData.getScope();
                    PublishingSpecs.VariantSpec testedSpec = testedVariantScope.getPublishingSpec().getTestingSpec(variantScope.getVariantConfiguration().getType());
                    PublishingSpecs.OutputSpec taskOutputSpec = testedSpec.getSpec(AndroidArtifacts.ArtifactType.CLASSES);
                    ArtifactType testedOutputType = taskOutputSpec.getOutputType();
                    return ImmutableList.of((Object)new EarlySyncBuildOutput(InternalArtifactType.JAVAC, VariantOutput.OutputType.MAIN, (Collection<? extends FilterData>)ImmutableList.of(), variantData.getVariantConfiguration().getVersionCode(), (File)variantScope.getArtifacts().getFinalArtifactFiles(testedOutputType).iterator().next()));
                };
            }
        }
        throw new RuntimeException("Unhandled build type " + variantData.getType());
    }

    private static BuildOutputSupplier<Collection<EarlySyncBuildOutput>> getManifestsSupplier(BaseVariantData variantData) {
        VariantTypeImpl variantType = (VariantTypeImpl)variantData.getType();
        switch (variantType) {
            case ANDROID_TEST: 
            case BASE_APK: 
            case OPTIONAL_APK: 
            case BASE_FEATURE: 
            case FEATURE: 
            case TEST_APK: {
                return new BuildOutputsSupplier((List<ArtifactType>)ImmutableList.of((Object)((Object)InternalArtifactType.MERGED_MANIFESTS)), (List<File>)ImmutableList.of((Object)variantData.getScope().getManifestOutputDirectory()));
            }
            case LIBRARY: {
                ApkInfo mainApkInfo = ApkInfo.of((VariantOutput.OutputType)VariantOutput.OutputType.MAIN, (Collection)ImmutableList.of(), (int)0);
                return BuildOutputSupplier.of(ImmutableList.of((Object)new EarlySyncBuildOutput(InternalArtifactType.MERGED_MANIFESTS, mainApkInfo.getType(), mainApkInfo.getFilters(), mainApkInfo.getVersionCode(), new File(variantData.getScope().getManifestOutputDirectory(), "AndroidManifest.xml"))));
            }
        }
        throw new RuntimeException("Unhandled build type " + variantData.getType());
    }

    private static Collection<Abi> createAbiList(Collection<String> abiNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String abiName : abiNames) {
            Abi abi = Abi.getByName(abiName);
            if (abi == null) continue;
            builder.add((Object)abi);
        }
        return builder.build();
    }

    private static SourceProviders determineSourceProviders(BaseVariantData variantData) {
        SourceProvider variantSourceProvider = variantData.getVariantConfiguration().getVariantSourceProvider();
        SourceProvider multiFlavorSourceProvider = variantData.getVariantConfiguration().getMultiFlavorSourceProvider();
        return new SourceProviders(variantSourceProvider != null ? new SourceProviderImpl(variantSourceProvider) : null, multiFlavorSourceProvider != null ? new SourceProviderImpl(multiFlavorSourceProvider) : null);
    }

    private static List<String> getProductFlavorNames(BaseVariantData variantData) {
        return variantData.getVariantConfiguration().getProductFlavors().stream().map(ProductFlavor::getName).collect(Collectors.toList());
    }

    private static List<File> getGeneratedSourceFoldersForUnitTests(BaseVariantData variantData) {
        if (variantData == null) {
            return Collections.emptyList();
        }
        ArrayList folders = Lists.newArrayList(variantData.getExtraGeneratedSourceFolders());
        folders.add(variantData.getScope().getAnnotationProcessorOutputDir());
        return folders;
    }

    private static List<File> getGeneratedSourceFolders(BaseVariantData variantData) {
        if (variantData == null) {
            return Collections.emptyList();
        }
        VariantScope scope = variantData.getScope();
        BuildArtifactsHolder artifacts = scope.getArtifacts();
        GlobalScope globalScope = variantData.getScope().getGlobalScope();
        boolean useDataBindingV2 = globalScope.getProjectOptions().get(BooleanOption.ENABLE_DATA_BINDING_V2);
        boolean addDataBindingSources = globalScope.getExtension().getDataBinding().isEnabled() && useDataBindingV2 && artifacts.hasArtifact(InternalArtifactType.DATA_BINDING_BASE_CLASS_SOURCE_OUT);
        List<File> extraFolders = ModelBuilder.getGeneratedSourceFoldersForUnitTests(variantData);
        int additionalFolders = 4;
        if (addDataBindingSources) {
            ++additionalFolders;
        }
        ArrayList folders = Lists.newArrayListWithExpectedSize((int)(additionalFolders + extraFolders.size()));
        folders.addAll(extraFolders);
        if (artifacts.hasArtifact(InternalArtifactType.NOT_NAMESPACED_R_CLASS_SOURCES)) {
            folders.add(Iterables.get((Iterable)artifacts.getFinalArtifactFiles(InternalArtifactType.NOT_NAMESPACED_R_CLASS_SOURCES).getFiles(), (int)0));
        }
        if (artifacts.hasArtifact(InternalArtifactType.EMPTY_R_CLASS_FOR_STUDIO)) {
            folders.add(Iterables.get((Iterable)artifacts.getFinalArtifactFiles(InternalArtifactType.EMPTY_R_CLASS_FOR_STUDIO).getFiles(), (int)0));
        }
        folders.add(scope.getAidlSourceOutputDir());
        folders.add(scope.getBuildConfigSourceOutputDir());
        Boolean ndkMode = variantData.getVariantConfiguration().getMergedFlavor().getRenderscriptNdkModeEnabled();
        if (ndkMode == null || !ndkMode.booleanValue()) {
            folders.add(scope.getRenderscriptSourceOutputDir());
        }
        if (addDataBindingSources) {
            BuildableArtifact output2 = scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.DATA_BINDING_BASE_CLASS_SOURCE_OUT);
            folders.add(BuildableArtifactUtil.singleFile(output2));
        }
        return folders;
    }

    private static List<File> getGeneratedResourceFolders(BaseVariantData variantData) {
        ArrayList result;
        Set extraFolders;
        if (variantData == null) {
            return Collections.emptyList();
        }
        FileCollection extraResFolders = variantData.getExtraGeneratedResFolders();
        Set set = extraFolders = extraResFolders != null ? extraResFolders.getFiles() : null;
        if (extraFolders != null && !extraFolders.isEmpty()) {
            result = Lists.newArrayListWithCapacity((int)(extraFolders.size() + 2));
            result.addAll(extraFolders);
        } else {
            result = Lists.newArrayListWithCapacity((int)2);
        }
        VariantScope scope = variantData.getScope();
        result.add(scope.getRenderscriptResOutputDir());
        result.add(scope.getGeneratedResOutputDir());
        return result;
    }

    private static Collection<SigningConfig> cloneSigningConfigs(Collection<? extends SigningConfig> signingConfigs) {
        return signingConfigs.stream().map(SigningConfigImpl::createSigningConfig).collect(Collectors.toList());
    }

    private static SourceProviderContainer getSourceProviderContainer(Collection<SourceProviderContainer> items, String name) {
        for (SourceProviderContainer item : items) {
            if (!name.equals(item.getArtifactName())) continue;
            return item;
        }
        return null;
    }

    private void initBuildMapping(Project project) {
        if (this.buildMapping == null) {
            this.buildMapping = ModelBuilder.computeBuildMapping(project.getGradle());
        }
    }

    public static ImmutableMap<String, String> computeBuildMapping(Gradle gradle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String currentBuildPath = gradle.getRootProject().getProjectDir().getAbsolutePath();
        builder.put((Object)CURRENT_BUILD_NAME, (Object)currentBuildPath);
        Gradle rootGradleProject = gradle;
        while (rootGradleProject.getParent() != null) {
            rootGradleProject = rootGradleProject.getParent();
        }
        if (rootGradleProject != gradle) {
            builder.put((Object)rootGradleProject.getRootProject().getName(), (Object)rootGradleProject.getRootProject().getProjectDir().getAbsolutePath());
        }
        for (IncludedBuild includedBuild : rootGradleProject.getIncludedBuilds()) {
            String includedBuildPath = includedBuild.getProjectDir().getAbsolutePath();
            if (includedBuildPath.equals(currentBuildPath)) continue;
            builder.put((Object)includedBuild.getName(), (Object)includedBuildPath);
        }
        return builder.build();
    }

    private static class SourceProviders {
        protected SourceProviderImpl variantSourceProvider;
        protected SourceProviderImpl multiFlavorSourceProvider;

        public SourceProviders(SourceProviderImpl variantSourceProvider, SourceProviderImpl multiFlavorSourceProvider) {
            this.variantSourceProvider = variantSourceProvider;
            this.multiFlavorSourceProvider = multiFlavorSourceProvider;
        }
    }
}

