/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/ModuleMetadata;", "", "applicationId", "", "versionCode", "versionName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getApplicationId", "()Ljava/lang/String;", "getVersionCode", "getVersionName", "save", "", "outputFile", "Ljava/io/File;", "Companion", "gradle"})
public final class ModuleMetadata {
    @NotNull
    private final String applicationId;
    @NotNull
    private final String versionCode;
    @Nullable
    private final String versionName;
    @NotNull
    public static final String PERSISTED_FILE_NAME = "application-id.json";
    public static final Companion Companion = new Companion(null);

    public final void save(@NotNull File outputFile) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        FileUtils.write((File)outputFile, (CharSequence)gson.toJson((Object)this));
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getVersionCode() {
        return this.versionCode;
    }

    @Nullable
    public final String getVersionName() {
        return this.versionName;
    }

    public ModuleMetadata(@NotNull String applicationId, @NotNull String versionCode, @Nullable String versionName) {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)versionCode, (String)"versionCode");
        this.applicationId = applicationId;
        this.versionCode = versionCode;
        this.versionName = versionName;
    }

    @JvmStatic
    @NotNull
    public static final ModuleMetadata load(@NotNull File input) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return Companion.load(input);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/ModuleMetadata$Companion;", "", "()V", "PERSISTED_FILE_NAME", "", "load", "Lcom/android/build/gradle/internal/tasks/ModuleMetadata;", "input", "Ljava/io/File;", "gradle"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final ModuleMetadata load(@NotNull File input) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            if (Intrinsics.areEqual((Object)input.getName(), (Object)ModuleMetadata.PERSISTED_FILE_NAME) ^ true) {
                throw (Throwable)new FileNotFoundException("No application declaration present.");
            }
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            Closeable closeable = new FileReader(input);
            Throwable throwable = null;
            try {
                FileReader fileReader = (FileReader)closeable;
                Object object = gson.fromJson((Reader)fileReader, ModuleMetadata.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(\n         \u2026ss.java\n                )");
                ModuleMetadata moduleMetadata = (ModuleMetadata)object;
                return moduleMetadata;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

