/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.workeractions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0003\u0016\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u0006\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u0005H\u0007J4\u0010\n\u001a\u00020\u000b\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u00052\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00060\rH\u0007J\u0012\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000fH\u0003J(\u0010\u0010\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u0006\"\b\b\u0000\u0010\b*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u0005H\u0007J\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015R\"\u0010\u0003\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/workeractions/WorkerActionServiceRegistry;", "", "()V", "services", "", "Lcom/android/build/gradle/internal/workeractions/WorkerActionServiceRegistry$ServiceKey;", "Lcom/android/build/gradle/internal/workeractions/WorkerActionServiceRegistry$RegisteredService;", "getService", "T", "key", "registerService", "", "serviceFactory", "Lkotlin/Function0;", "removeAllServices", "", "removeService", "serviceNotFoundError", "", "shutdownAllRegisteredServices", "executor", "Ljava/util/concurrent/Executor;", "Companion", "RegisteredService", "ServiceKey", "gradle"})
public final class WorkerActionServiceRegistry {
    private final Map<ServiceKey<?>, RegisteredService<?>> services;
    @JvmField
    @NotNull
    public static final WorkerActionServiceRegistry INSTANCE;
    public static final Companion Companion;

    public final synchronized <T> void registerService(@NotNull ServiceKey<T> key, @NotNull Function0<? extends RegisteredService<? extends T>> serviceFactory) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(serviceFactory, (String)"serviceFactory");
        if (this.services.get(key) == null) {
            this.services.put(key, (RegisteredService<?>)serviceFactory.invoke());
        }
    }

    @NotNull
    public final synchronized <T> RegisteredService<T> getService(@NotNull ServiceKey<T> key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        RegisteredService<?> registeredService = this.services.get(key);
        if (registeredService == null) {
            Void void_ = this.serviceNotFoundError(key);
            throw null;
        }
        return registeredService;
    }

    private final Void serviceNotFoundError(ServiceKey<?> key) {
        if (this.services.isEmpty()) {
            throw (Throwable)new IllegalStateException("No services are registered. Ensure the worker actions use IsolationMode.NONE.");
        }
        throw (Throwable)new IllegalStateException("Service " + key + " not registered. Available services: " + '[' + CollectionsKt.joinToString$default((Iterable)this.services.keySet(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "].");
    }

    @Nullable
    public final synchronized <T> RegisteredService<T> removeService(@NotNull ServiceKey<T> key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        return this.services.remove(key);
    }

    private final synchronized Collection<RegisteredService<?>> removeAllServices() {
        ArrayList toBeShutdown = new ArrayList(this.services.values());
        this.services.clear();
        return toBeShutdown;
    }

    public final void shutdownAllRegisteredServices(@NotNull Executor executor) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Collection<RegisteredService<?>> toBeShutdown = this.removeAllServices();
        Iterable $receiver$iv = toBeShutdown;
        for (Object element$iv : $receiver$iv) {
            RegisteredService it = (RegisteredService)element$iv;
            executor.execute(new Runnable(it){
                final /* synthetic */ RegisteredService $it;

                public final void run() {
                    this.$it.shutdown();
                }
                {
                    this.$it = registeredService;
                }
            });
        }
    }

    public WorkerActionServiceRegistry() {
        Map map;
        WorkerActionServiceRegistry workerActionServiceRegistry = this;
        workerActionServiceRegistry.services = map = (Map)new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new WorkerActionServiceRegistry();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/workeractions/WorkerActionServiceRegistry$ServiceKey;", "T", "", "Ljava/io/Serializable;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "gradle"})
    public static interface ServiceKey<T>
    extends Serializable {
        @NotNull
        public Class<T> getType();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\bf\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002J\b\u0010\u0006\u001a\u00020\u0007H&R\u0012\u0010\u0003\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/workeractions/WorkerActionServiceRegistry$RegisteredService;", "T", "", "service", "getService", "()Ljava/lang/Object;", "shutdown", "", "gradle"})
    public static interface RegisteredService<T> {
        @NotNull
        public T getService();

        public void shutdown();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/workeractions/WorkerActionServiceRegistry$Companion;", "", "()V", "INSTANCE", "Lcom/android/build/gradle/internal/workeractions/WorkerActionServiceRegistry;", "gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

