/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.ide.common.build.ApkInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.function.Supplier;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GenerateTestConfig
extends DefaultTask {
    BuildableArtifact resourcesDirectory;
    BuildableArtifact assets;
    Path sdkHome;
    File generatedJavaResourcesDirectory;
    ApkInfo mainApkInfo;
    BuildableArtifact manifests;
    BuildableArtifact compiledResourcesZip;
    Supplier<String> packageForR;

    @Input
    ApkInfo getMainApkInfo() {
        return this.mainApkInfo;
    }

    @InputFiles
    BuildableArtifact getManifests() {
        return this.manifests;
    }

    @TaskAction
    public void generateTestConfig() throws IOException {
        Preconditions.checkNotNull((Object)this.resourcesDirectory);
        Preconditions.checkNotNull((Object)this.assets);
        Preconditions.checkNotNull((Object)this.sdkHome);
        BuildOutput output2 = ExistingBuildElements.from((ArtifactType)InternalArtifactType.MERGED_MANIFESTS, this.manifests).element(this.mainApkInfo);
        GenerateTestConfig.generateTestConfigForOutput(((File)Iterables.getOnlyElement((Iterable)this.assets)).toPath().toAbsolutePath(), BuildableArtifactUtil.singleFile(this.resourcesDirectory).toPath().toAbsolutePath(), this.sdkHome, this.getPackageForR(), ((BuildOutput)Preconditions.checkNotNull((Object)output2, (Object)"Unable to find manifest output")).getOutputFile().toPath(), this.compiledResourcesZip, this.generatedJavaResourcesDirectory.toPath().toAbsolutePath());
    }

    static void generateTestConfigForOutput(Path assetsDir, Path resDir, Path sdkHome, String packageForR, Path manifest, BuildableArtifact compiledResourcesZip, Path outputDir) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("android_sdk_home", sdkHome.toAbsolutePath().toString());
        properties.setProperty("android_merged_resources", resDir.toAbsolutePath().toString());
        properties.setProperty("android_merged_manifest", manifest.toAbsolutePath().toString());
        properties.setProperty("android_merged_assets", assetsDir.toAbsolutePath().toString());
        if (compiledResourcesZip != null) {
            properties.setProperty("android_resource_apk", GenerateTestConfig.apkFrom(compiledResourcesZip).getPath());
        }
        properties.setProperty("android_custom_package", packageForR);
        Path output2 = outputDir.resolve("com").resolve("android").resolve("tools").resolve("test_config.properties");
        Files.createDirectories(output2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(output2, new OpenOption[0]);){
            properties.store(writer, "# Generated by the Android Gradle Plugin");
        }
    }

    @Input
    public String getResourcesDirectory() {
        return BuildableArtifactUtil.singleFile(this.resourcesDirectory).getPath();
    }

    @Input
    public String getAssets() {
        return ((File)Iterables.getOnlyElement((Iterable)this.assets)).getPath();
    }

    @Input
    public String getSdkHome() {
        return this.sdkHome.toString();
    }

    @Optional
    @Input
    public String getCompiledResourcesZip() {
        if (this.compiledResourcesZip == null) {
            return null;
        }
        return GenerateTestConfig.apkFrom(this.compiledResourcesZip).getPath();
    }

    private static File apkFrom(BuildableArtifact compiledResourcesZip) {
        return (File)Iterables.getOnlyElement((Iterable)compiledResourcesZip.getFiles());
    }

    @OutputDirectory
    public File getOutputFile() {
        return this.generatedJavaResourcesDirectory;
    }

    @Input
    public String getPackageForR() {
        return this.packageForR.get();
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateTestConfig> {
        private final VariantScope scope;
        private final VariantScope testedScope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
            this.testedScope = ((BaseVariantData)Preconditions.checkNotNull((Object)scope.getTestedVariantData(), (Object)"Not a unit test variant.")).getScope();
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("generate", "Config");
        }

        @Override
        public Class<GenerateTestConfig> getType() {
            return GenerateTestConfig.class;
        }

        @Override
        public void execute(GenerateTestConfig task) {
            task.resourcesDirectory = this.testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_NOT_COMPILED_RES);
            task.dependsOn(new Object[]{task.resourcesDirectory});
            task.manifests = this.testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_MANIFESTS);
            boolean enableBinaryResources = this.scope.getGlobalScope().getProjectOptions().get(BooleanOption.ENABLE_UNIT_TEST_BINARY_RESOURCES);
            if (enableBinaryResources) {
                task.compiledResourcesZip = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_FOR_LOCAL_TEST);
                task.dependsOn(new Object[]{task.compiledResourcesZip});
            }
            task.assets = this.testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_ASSETS);
            task.dependsOn(new Object[]{task.assets});
            task.mainApkInfo = this.testedScope.getOutputScope().getMainSplit();
            task.sdkHome = Paths.get(this.scope.getGlobalScope().getAndroidBuilder().getTarget().getLocation(), new String[0]);
            task.generatedJavaResourcesDirectory = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY, (Task)task, "out");
            task.packageForR = this.testedScope.getVariantConfiguration()::getOriginalApplicationId;
        }
    }
}

