/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.MergeManifests;
import com.android.build.gradle.tasks.ResourceException;
import com.android.build.gradle.tasks.WorkerExecutorAdapter;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.resources.AssetMerger;
import com.android.ide.common.resources.AssetSet;
import com.android.ide.common.resources.DataSet;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.resources.FileValidity;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergedAssetWriter;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class MergeSourceSetFolders
extends IncrementalTask {
    private File outputDir;
    private Supplier<Collection<File>> sourceFolderInputs;
    private Supplier<List<AssetSet>> assetSetSupplier;
    private ArtifactCollection libraries = null;
    private BuildableArtifact shadersOutputDir = null;
    private FileCollection copyApk = null;
    private String ignoreAssets = null;
    private final FileValidity<AssetSet> fileValidity = new FileValidity();
    private final WorkerExecutorFacade workerExecutor;

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Inject
    public MergeSourceSetFolders(WorkerExecutor workerExecutor) {
        this.workerExecutor = new WorkerExecutorAdapter(workerExecutor);
    }

    @Override
    @Internal
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        File destinationDir = this.getOutputDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        List<AssetSet> assetSets = this.computeAssetSetList();
        AssetMerger merger = new AssetMerger();
        try {
            for (AssetSet assetSet : assetSets) {
                assetSet.loadFromFiles(this.getILogger());
                merger.addDataSet((DataSet)assetSet);
            }
            MergedAssetWriter writer = new MergedAssetWriter(destinationDir, this.workerExecutor);
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
        }
        catch (MergingException e) {
            this.getLogger().error("Could not merge source set folders: ", (Throwable)e);
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException {
        AssetMerger merger = new AssetMerger();
        try {
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true)) {
                this.doFullTaskAction();
                return;
            }
            List<AssetSet> assetSets = this.computeAssetSetList();
            if (!merger.checkValidUpdate(assetSets)) {
                this.getLogger().info("Changed Asset sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            for (Map.Entry<File, FileStatus> entry : changedInputs.entrySet()) {
                File changedFile = entry.getKey();
                if (changedFile.isDirectory()) continue;
                merger.findDataSetContaining(changedFile, this.fileValidity);
                if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
                    this.doFullTaskAction();
                    return;
                }
                if (this.fileValidity.getStatus() != FileValidity.FileStatus.VALID_FILE || ((AssetSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, entry.getValue(), this.getILogger())) continue;
                this.getLogger().info("Failed to process {} event! Full task run", (Object)entry.getValue());
                this.doFullTaskAction();
                return;
            }
            MergedAssetWriter writer = new MergedAssetWriter(this.getOutputDir(), this.workerExecutor);
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
        }
        catch (MergingException e) {
            this.getLogger().error("Could not merge source set folders: ", (Throwable)e);
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
        finally {
            this.fileValidity.clear();
        }
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getLibraries() {
        if (this.libraries != null) {
            return this.libraries.getArtifactFiles();
        }
        return null;
    }

    public void setLibraries(ArtifactCollection libraries) {
        this.libraries = libraries;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public BuildableArtifact getShadersOutputDir() {
        return this.shadersOutputDir;
    }

    void setShadersOutputDir(BuildableArtifact shadersOutputDir) {
        this.shadersOutputDir = shadersOutputDir;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getCopyApk() {
        return this.copyApk;
    }

    void setCopyApk(FileCollection copyApk) {
        this.copyApk = copyApk;
    }

    @Input
    @Optional
    public String getIgnoreAssets() {
        return this.ignoreAssets;
    }

    void setAssetSetSupplier(Supplier<List<AssetSet>> assetSetSupplier) {
        this.assetSetSupplier = assetSetSupplier;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Collection<File> getSourceFolderInputs() {
        return this.sourceFolderInputs.get();
    }

    List<AssetSet> computeAssetSetList() {
        ArrayList assetSetList;
        ArrayList assetSets = this.assetSetSupplier.get();
        if (this.copyApk == null && this.shadersOutputDir == null && this.ignoreAssets == null && this.libraries == null) {
            assetSetList = assetSets;
        } else {
            int size = assetSets.size() + 3;
            if (this.libraries != null) {
                size += this.libraries.getArtifacts().size();
            }
            assetSetList = Lists.newArrayListWithExpectedSize((int)size);
            if (this.libraries != null) {
                Set libArtifacts = this.libraries.getArtifacts();
                for (ResolvedArtifactResult artifact : libArtifacts) {
                    AssetSet assetSet = new AssetSet(MergeManifests.getArtifactName(artifact));
                    assetSet.addSource(artifact.getFile());
                    assetSetList.add(0, assetSet);
                }
            }
            ArrayList generatedAssetFolders = Lists.newArrayList();
            if (this.shadersOutputDir != null) {
                generatedAssetFolders.addAll(this.shadersOutputDir.getFiles());
            }
            if (this.copyApk != null) {
                generatedAssetFolders.addAll(this.copyApk.getFiles());
            }
            AssetSet mainAssetSet = (AssetSet)assetSets.get(0);
            assert (mainAssetSet.getConfigName().equals("main"));
            mainAssetSet.addSources((Collection)generatedAssetFolders);
            assetSetList.addAll(assetSets);
        }
        if (this.ignoreAssets != null) {
            for (AssetSet set : assetSetList) {
                set.setIgnoredPatterns(this.ignoreAssets);
            }
        }
        return assetSetList;
    }

    public static class MergeShaderSourceFoldersConfigAction
    extends ConfigAction {
        public MergeShaderSourceFoldersConfigAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("merge", "Shaders");
        }

        @Override
        public void execute(MergeSourceSetFolders mergeAssetsTask) {
            super.execute(mergeAssetsTask);
            BaseVariantData variantData = this.scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            Function<SourceProvider, Collection> assetDirFunction = SourceProvider::getShadersDirectories;
            mergeAssetsTask.assetSetSupplier = () -> variantConfig.getSourceFilesAsAssetSets(assetDirFunction);
            mergeAssetsTask.sourceFolderInputs = () -> variantConfig.getSourceFiles(assetDirFunction);
            mergeAssetsTask.setOutputDir(this.scope.getMergeShadersOutputDir());
        }
    }

    public static class MergeJniLibFoldersConfigAction
    extends ConfigAction {
        public MergeJniLibFoldersConfigAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("merge", "JniLibFolders");
        }

        @Override
        public void execute(MergeSourceSetFolders mergeAssetsTask) {
            super.execute(mergeAssetsTask);
            BaseVariantData variantData = this.scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            Function<SourceProvider, Collection> assetDirFunction = SourceProvider::getJniLibsDirectories;
            mergeAssetsTask.assetSetSupplier = () -> variantConfig.getSourceFilesAsAssetSets(assetDirFunction);
            mergeAssetsTask.sourceFolderInputs = () -> variantConfig.getSourceFiles(assetDirFunction);
            mergeAssetsTask.setOutputDir(this.scope.getMergeNativeLibsOutputDir());
        }
    }

    public static class LibraryAssetConfigAction
    extends MergeAssetBaseConfigAction {
        public LibraryAssetConfigAction(VariantScope scope) {
            super(scope, InternalArtifactType.LIBRARY_ASSETS, false);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("package", "Assets");
        }
    }

    public static class MergeAppAssetConfigAction
    extends MergeAssetBaseConfigAction {
        public MergeAppAssetConfigAction(VariantScope scope) {
            super(scope, InternalArtifactType.MERGED_ASSETS, true);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("merge", "Assets");
        }
    }

    public static class MergeAssetBaseConfigAction
    extends ConfigAction {
        final boolean includeDependencies;
        final ArtifactType outputArtifactType;

        public MergeAssetBaseConfigAction(VariantScope scope, ArtifactType outputArtifactType, boolean includeDependencies) {
            super(scope);
            this.outputArtifactType = outputArtifactType;
            this.includeDependencies = includeDependencies;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("merge", "Assets");
        }

        @Override
        public void execute(MergeSourceSetFolders mergeAssetsTask) {
            super.execute(mergeAssetsTask);
            BaseVariantData variantData = this.scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            variantData.mergeAssetsTask = mergeAssetsTask;
            Function<SourceProvider, Collection> assetDirFunction = SourceProvider::getAssetsDirectories;
            mergeAssetsTask.assetSetSupplier = () -> variantConfig.getSourceFilesAsAssetSets(assetDirFunction);
            mergeAssetsTask.sourceFolderInputs = () -> variantConfig.getSourceFiles(assetDirFunction);
            mergeAssetsTask.shadersOutputDir = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.SHADER_ASSETS);
            AaptOptions options = this.scope.getGlobalScope().getExtension().getAaptOptions();
            if (options != null) {
                mergeAssetsTask.ignoreAssets = options.getIgnoreAssets();
            }
            if (this.includeDependencies) {
                mergeAssetsTask.libraries = this.scope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ASSETS);
            }
            mergeAssetsTask.setOutputDir(this.scope.getArtifacts().appendArtifact(this.outputArtifactType, (Task)mergeAssetsTask, "out"));
        }
    }

    protected static abstract class ConfigAction
    implements TaskConfigAction<MergeSourceSetFolders> {
        protected final VariantScope scope;

        protected ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public Class<MergeSourceSetFolders> getType() {
            return MergeSourceSetFolders.class;
        }

        @Override
        public void execute(MergeSourceSetFolders mergeAssetsTask) {
            BaseVariantData variantData = this.scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            mergeAssetsTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            mergeAssetsTask.setVariantName(variantConfig.getFullName());
            mergeAssetsTask.setIncrementalFolder(this.scope.getIncrementalDir(this.getName()));
        }
    }
}

