/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.res.Aapt2ProcessResourcesRunnable;
import com.android.build.gradle.internal.res.namespaced.Aapt2CompileRunnable;
import com.android.build.gradle.internal.res.namespaced.Aapt2DaemonManagerService;
import com.android.build.gradle.internal.res.namespaced.Aapt2ServiceKey;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.BlockingResourceLinker;
import com.android.builder.internal.aapt.v1.AaptV1;
import com.android.builder.internal.aapt.v2.Aapt2RenamingConventions;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MergingLogRewriter;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.Aapt2OutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.resources.QueueableResourceCompiler;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.workers.WorkerExecutor;

public class VerifyLibraryResourcesTask
extends IncrementalTask {
    private File compiledDirectory;
    private BuildableArtifact inputDirectory;
    private File mergeBlameLogFolder;
    private InternalArtifactType taskInputType;
    private BuildableArtifact manifestFiles;
    private AaptGeneration aaptGeneration;
    private FileCollection aapt2FromMaven;
    private final WorkerExecutorFacade workers;

    @Inject
    public VerifyLibraryResourcesTask(WorkerExecutor workerExecutor) {
        this.workers = Workers.INSTANCE.getWorker(workerExecutor);
    }

    @Override
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected final void doFullTaskAction() throws Exception {
        Map<File, FileStatus> fileStatusMap;
        try (Stream<Path> paths = Files.walk(BuildableArtifactUtil.singleFile(this.inputDirectory).toPath(), new FileVisitOption[0]);){
            fileStatusMap = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toMap(Path::toFile, file -> FileStatus.NEW));
        }
        FileUtils.cleanOutputDir((File)this.compiledDirectory);
        this.compileAndVerifyResources(fileStatusMap);
    }

    @Override
    protected final void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws Exception {
        this.compileAndVerifyResources(changedInputs);
    }

    private void compileAndVerifyResources(Map<File, FileStatus> inputs) throws Exception {
        AndroidBuilder builder = this.getBuilder();
        MergingLog mergingLog = new MergingLog(this.mergeBlameLogFolder);
        MergingLogRewriter mergingLogRewriter = new MergingLogRewriter(arg_0 -> ((MergingLog)mergingLog).find(arg_0), builder.getMessageReceiver());
        ParsingProcessOutputHandler processOutputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)(this.aaptGeneration == AaptGeneration.AAPT_V1 ? new AaptOutputParser() : new Aapt2OutputParser()), this.getILogger()), new MessageReceiver[]{mergingLogRewriter});
        BuildElements manifestsOutputs = ExistingBuildElements.from((ArtifactType)this.taskInputType, this.manifestFiles);
        File manifestFile = ((BuildOutput)Iterables.getOnlyElement((Iterable)manifestsOutputs)).getOutputFile();
        if (this.aaptGeneration == AaptGeneration.AAPT_V2_DAEMON_SHARED_POOL) {
            Aapt2ServiceKey aapt2ServiceKey = Aapt2DaemonManagerService.registerAaptService(this.aapt2FromMaven, this.getBuildTools(), this.getILogger());
            try (WorkerExecutorFacade facade = this.workers;){
                VerifyLibraryResourcesTask.compileResources(inputs, this.compiledDirectory, null, facade, aapt2ServiceKey, BuildableArtifactUtil.singleFile(this.inputDirectory));
                AaptPackageConfig config2 = this.getAaptPackageConfig(this.compiledDirectory, manifestFile);
                Aapt2ProcessResourcesRunnable.Params params = new Aapt2ProcessResourcesRunnable.Params(aapt2ServiceKey, config2);
                facade.submit(Aapt2ProcessResourcesRunnable.class, (Serializable)params);
            }
            return;
        }
        try (Aapt aapt = AaptGradleFactory.make(this.aaptGeneration, builder, (ProcessOutputHandler)processOutputHandler, true, 0);){
            if (aapt instanceof AaptV1) {
                this.linkResources(BuildableArtifactUtil.singleFile(this.inputDirectory), (BlockingResourceLinker)aapt, manifestFile);
            } else {
                VerifyLibraryResourcesTask.compileResources(inputs, this.compiledDirectory, (QueueableResourceCompiler)aapt, null, null, BuildableArtifactUtil.singleFile(this.inputDirectory));
                this.linkResources(this.compiledDirectory, (BlockingResourceLinker)aapt, manifestFile);
            }
        }
    }

    public static void compileResources(Map<File, FileStatus> inputs, File outDirectory, QueueableResourceCompiler aapt, WorkerExecutorFacade workerExecutor, Aapt2ServiceKey aapt2ServiceKey, File mergedResDirectory) throws AaptException, ExecutionException, InterruptedException, IOException {
        Preconditions.checkState((!(aapt instanceof AaptV1) ? 1 : 0) != 0, (Object)"Library resources should be compiled for verification using AAPT2");
        Preconditions.checkState((aapt != null || workerExecutor != null && aapt2ServiceKey != null ? 1 : 0) != 0);
        ArrayList<Future> compiling = new ArrayList<Future>();
        for (Map.Entry<File, FileStatus> input : inputs.entrySet()) {
            if (input.getKey().getParentFile().equals(mergedResDirectory)) continue;
            switch (input.getValue()) {
                case NEW: 
                case CHANGED: {
                    try {
                        CompileResourceRequest request2 = new CompileResourceRequest(input.getKey(), outDirectory, input.getKey().getParent(), false, false);
                        if (aapt != null) {
                            Future result = aapt.compile(request2);
                            compiling.add(result);
                            break;
                        }
                        workerExecutor.submit(Aapt2CompileRunnable.class, (Serializable)new Aapt2CompileRunnable.Params(aapt2ServiceKey, Collections.singletonList(request2)));
                        break;
                    }
                    catch (Exception e) {
                        throw new AaptException(String.format("Failed to compile file %s", input.getKey().getAbsolutePath()), (Throwable)e);
                    }
                }
                case REMOVED: {
                    FileUtils.deleteIfExists((File)new File(outDirectory, Aapt2RenamingConventions.compilationRename((File)input.getKey())));
                }
            }
        }
        if (workerExecutor != null) {
            workerExecutor.await();
        } else {
            for (Future result : compiling) {
                result.get();
            }
        }
    }

    private void linkResources(File resDir, BlockingResourceLinker aapt, File manifestFile) throws ProcessException, IOException {
        Preconditions.checkNotNull((Object)manifestFile, (Object)"Manifest file cannot be null");
        AaptPackageConfig config2 = this.getAaptPackageConfig(resDir, manifestFile);
        AndroidBuilder.processResources((BlockingResourceLinker)aapt, (AaptPackageConfig)config2, (ILogger)this.getILogger());
    }

    private AaptPackageConfig getAaptPackageConfig(File resDir, File manifestFile) {
        return new AaptPackageConfig.Builder().setManifestFile(manifestFile).setResourceDir(resDir).setLibrarySymbolTableFiles((Set)ImmutableSet.of()).setOptions(DslAdaptersKt.convert(new AaptOptions())).setVariantType((VariantType)VariantTypeImpl.LIBRARY).setAndroidTarget(this.getBuilder().getTarget()).build();
    }

    @Input
    public String getAaptGeneration() {
        return this.aaptGeneration.name();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getAapt2FromMaven() {
        return this.aapt2FromMaven;
    }

    @InputFiles
    public BuildableArtifact getManifestFiles() {
        return this.manifestFiles;
    }

    @Input
    public InternalArtifactType getTaskInputType() {
        return this.taskInputType;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public BuildableArtifact getInputDirectory() {
        return this.inputDirectory;
    }

    @OutputDirectory
    public File getCompiledDirectory() {
        return this.compiledDirectory;
    }

    @Input
    public File getMergeBlameLogFolder() {
        return this.mergeBlameLogFolder;
    }

    public static class ConfigAction
    implements TaskConfigAction<VerifyLibraryResourcesTask> {
        protected final VariantScope scope;
        private final TaskManager.MergeType sourceArtifactType;

        public ConfigAction(VariantScope scope, TaskManager.MergeType sourceArtifactType) {
            this.scope = scope;
            this.sourceArtifactType = sourceArtifactType;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("verify", "Resources");
        }

        @Override
        public Class<VerifyLibraryResourcesTask> getType() {
            return VerifyLibraryResourcesTask.class;
        }

        @Override
        public void execute(VerifyLibraryResourcesTask verifyLibraryResources) {
            BaseVariantData variantData = this.scope.getVariantData();
            GradleVariantConfiguration config2 = variantData.getVariantConfiguration();
            verifyLibraryResources.setVariantName(config2.getFullName());
            verifyLibraryResources.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            verifyLibraryResources.aaptGeneration = AaptGeneration.fromProjectOptions(this.scope.getGlobalScope().getProjectOptions());
            verifyLibraryResources.aapt2FromMaven = Aapt2MavenUtils.getAapt2FromMavenIfEnabled(this.scope.getGlobalScope());
            verifyLibraryResources.setIncrementalFolder(this.scope.getIncrementalDir(this.getName()));
            Preconditions.checkState((this.sourceArtifactType == TaskManager.MergeType.MERGE ? 1 : 0) != 0, (Object)"Support for not merging resources in libraries not implemented yet.");
            verifyLibraryResources.inputDirectory = this.scope.getArtifacts().getFinalArtifactFiles(this.sourceArtifactType.getOutputType());
            verifyLibraryResources.compiledDirectory = this.scope.getCompiledResourcesOutputDir();
            verifyLibraryResources.mergeBlameLogFolder = this.scope.getResourceBlameLogDir();
            boolean aaptFriendlyManifestsFilePresent = this.scope.getArtifacts().hasArtifact(InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS);
            verifyLibraryResources.taskInputType = aaptFriendlyManifestsFilePresent ? InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS : (this.scope.getInstantRunBuildContext().isInInstantRunMode() ? InternalArtifactType.INSTANT_RUN_MERGED_MANIFESTS : InternalArtifactType.MERGED_MANIFESTS);
            verifyLibraryResources.manifestFiles = this.scope.getArtifacts().getFinalArtifactFiles(verifyLibraryResources.taskInputType);
        }
    }
}

