/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.gradle.api.ApkVariantOutput;
import com.android.build.gradle.internal.api.BaseVariantOutputImpl;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.ide.common.build.ApkData;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.Serializable;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Task;

public class ApkVariantOutputImpl
extends BaseVariantOutputImpl
implements ApkVariantOutput {
    @Inject
    public ApkVariantOutputImpl(ApkData apkData, TaskContainer taskContainer) {
        super(apkData, taskContainer);
    }

    @Override
    public PackageAndroidArtifact getPackageApplication() {
        return this.taskContainer.getTaskByType(PackageAndroidArtifact.class);
    }

    @Override
    public File getOutputFile() {
        PackageAndroidArtifact packageAndroidArtifact = this.getPackageApplication();
        if (packageAndroidArtifact != null) {
            return new File(packageAndroidArtifact.getOutputDirectory(), this.apkData.getOutputFileName());
        }
        return super.getOutputFile();
    }

    @Override
    public Task getZipAlign() {
        return this.getPackageApplication();
    }

    @Override
    public void setVersionCodeOverride(int versionCodeOverride) {
        this.apkData.setVersionCode((IntSupplier & Serializable)() -> versionCodeOverride);
    }

    @Override
    public int getVersionCodeOverride() {
        return this.apkData.getVersionCode();
    }

    @Override
    public void setVersionNameOverride(String versionNameOverride) {
        this.apkData.setVersionName((Supplier<String> & Serializable)() -> versionNameOverride);
    }

    @Override
    public String getVersionNameOverride() {
        return this.apkData.getVersionName();
    }

    public int getVersionCode() {
        return this.apkData.getVersionCode();
    }

    @Override
    public String getFilter(VariantOutput.FilterType filterType) {
        FilterData filterData = this.apkData.getFilter(filterType);
        return filterData != null ? filterData.getIdentifier() : null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("apkData", (Object)this.apkData).toString();
    }
}

