/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.Toolchain;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFile;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFileKt;
import com.android.build.gradle.internal.cxx.configure.PlatformConfigurator;
import com.android.build.gradle.internal.ndk.AbiInfo;
import com.android.build.gradle.internal.ndk.DefaultStlNativeToolSpecification;
import com.android.build.gradle.internal.ndk.DefaultStlSpecificationFactory;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.ndk.StlNativeToolSpecification;
import com.android.build.gradle.internal.ndk.StlSpecification;
import com.android.repository.Revision;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.Pair;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.logging.Logging;

public class DefaultNdkInfo
implements NdkInfo {
    private final File root;
    private final PlatformConfigurator platformConfigurator;
    private final List<AbiInfo> abiInfoList;
    private final Map<Pair<Toolchain, Abi>, String> defaultToolchainVersions = Maps.newHashMap();

    public DefaultNdkInfo(File root) {
        this.root = root;
        this.platformConfigurator = new PlatformConfigurator(root);
        this.abiInfoList = new NdkAbiFile(NdkAbiFileKt.ndkMetaAbisFile(root)).getAbiInfoList();
    }

    @Override
    public File getRootDirectory() {
        return this.root;
    }

    @Override
    public String getCompilerSysrootPath(Abi abi, String platformVersion, boolean useUnifiedHeaders) {
        if (useUnifiedHeaders) {
            return FileUtils.join((String[])new String[]{this.root.getPath(), "sysroot"});
        }
        return this.getLinkerSysrootPath(abi, platformVersion);
    }

    @Override
    public String getLinkerSysrootPath(Abi abi, String platformVersion) {
        return FileUtils.join((String[])new String[]{this.root.getPath(), "platforms", platformVersion, "arch-" + abi.getArchitecture()});
    }

    @Override
    public String findLatestPlatformVersion(String targetPlatformString) {
        int targetVersion;
        AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)targetPlatformString);
        if (androidVersion == null) {
            Logging.getLogger(this.getClass()).warn("Unable to parse NDK platform version.  Try to find the latest instead.");
            targetVersion = Integer.MAX_VALUE;
        } else {
            targetVersion = androidVersion.getFeatureLevel();
        }
        targetVersion = this.findTargetPlatformVersionOrLower(targetVersion);
        if (targetVersion == 0) {
            return null;
        }
        return "android-" + targetVersion;
    }

    @Override
    public int findSuitablePlatformVersion(String abiName, String variantName, AndroidVersion androidVersion) {
        return this.platformConfigurator.findSuitablePlatformVersion(abiName, variantName, androidVersion);
    }

    private int findTargetPlatformVersionOrLower(int targetVersion) {
        File platformDir = new File(this.root, "/platforms");
        if (new File(platformDir, "android-" + targetVersion).exists()) {
            return targetVersion;
        }
        File[] platformSubDirs2 = platformDir.listFiles(File::isDirectory);
        int highestVersion = 0;
        for (File platform : platformSubDirs2) {
            if (!platform.getName().startsWith("android-")) continue;
            try {
                int version = Integer.parseInt(platform.getName().substring("android-".length()));
                if (version <= highestVersion || version >= targetVersion) continue;
                highestVersion = version;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return highestVersion;
    }

    private static String getToolchainPrefix(Toolchain toolchain, Abi abi) {
        if (toolchain == Toolchain.GCC) {
            return abi.getGccToolchainPrefix();
        }
        return "llvm";
    }

    @Override
    public File getToolchainPath(Toolchain toolchain, String toolchainVersion, Abi abi) {
        abi = this.getToolchainAbi(abi);
        String version = toolchainVersion.isEmpty() ? this.getDefaultToolchainVersion(toolchain, abi) : toolchainVersion;
        version = version.isEmpty() ? "" : "-" + version;
        File prebuiltFolder = new File(this.getRootDirectory(), "toolchains/" + DefaultNdkInfo.getToolchainPrefix(toolchain, abi) + version + "/prebuilt");
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        String hostOs = osName.contains("windows") ? "windows" : (osName.contains("mac") ? "darwin" : "linux");
        File[] toolchainPaths = prebuiltFolder.listFiles(File::isDirectory);
        if (toolchainPaths == null) {
            throw new InvalidUserDataException("Unable to find toolchain: " + prebuiltFolder);
        }
        if (toolchainPaths.length == 1) {
            return toolchainPaths[0];
        }
        File toolchainPath = new File(prebuiltFolder, hostOs + "-x86_64");
        if (toolchainPath.isDirectory()) {
            return toolchainPath;
        }
        String osString = osName.equals("windows") ? hostOs : hostOs + "-x86";
        toolchainPath = new File(prebuiltFolder, osString);
        if (toolchainPath.isDirectory()) {
            return toolchainPath;
        }
        throw new InvalidUserDataException("Unable to find toolchain prebuilt folder in: " + prebuiltFolder);
    }

    protected Abi getToolchainAbi(Abi abi) {
        return abi;
    }

    @Override
    public File getCCompiler(Toolchain toolchain, String toolchainVersion, Abi abi) {
        abi = this.getToolchainAbi(abi);
        String compiler = toolchain == Toolchain.CLANG ? "clang" : abi.getGccExecutablePrefix() + "-gcc";
        return new File(this.getToolchainPath(toolchain, toolchainVersion, abi), "bin/" + compiler);
    }

    @Override
    public File getCppCompiler(Toolchain toolchain, String toolchainVersion, Abi abi) {
        abi = this.getToolchainAbi(abi);
        String compiler = toolchain == Toolchain.CLANG ? "clang++" : abi.getGccExecutablePrefix() + "-g++";
        return new File(this.getToolchainPath(toolchain, toolchainVersion, abi), "bin/" + compiler);
    }

    @Override
    public File getLinker(Toolchain toolchain, String toolchainVersion, Abi abi) {
        return this.getCppCompiler(toolchain, toolchainVersion, abi);
    }

    @Override
    public File getAssembler(Toolchain toolchain, String toolchainVersion, Abi abi) {
        return this.getCCompiler(toolchain, toolchainVersion, abi);
    }

    @Override
    public File getAr(Toolchain toolchain, String toolchainVersion, Abi abi) {
        abi = this.getToolchainAbi(abi);
        String ar = abi.getGccExecutablePrefix() + (toolchain == Toolchain.CLANG ? "-ar" : "-gcc-ar");
        return new File(this.getToolchainPath(Toolchain.GCC, this.getDefaultToolchainVersion(Toolchain.GCC, abi), abi), "bin/" + ar);
    }

    @Override
    public File getStripExecutable(Toolchain toolchain, String toolchainVersion, Abi abi) {
        abi = this.getToolchainAbi(abi);
        return FileUtils.join((File)this.getToolchainPath(Toolchain.GCC, toolchain == Toolchain.GCC ? toolchainVersion : this.getDefaultToolchainVersion(Toolchain.GCC, abi), abi), (String[])new String[]{"bin", abi.getGccExecutablePrefix() + "-strip"});
    }

    @Override
    public String getDefaultToolchainVersion(Toolchain toolchain, Abi abi) {
        String defaultVersion = this.defaultToolchainVersions.get(Pair.of((Object)((Object)toolchain), (Object)((Object)(abi = this.getToolchainAbi(abi)))));
        if (defaultVersion != null) {
            return defaultVersion;
        }
        String toolchainPrefix = DefaultNdkInfo.getToolchainPrefix(toolchain, abi);
        File toolchains = new File(this.getRootDirectory(), "toolchains");
        File[] toolchainsForAbi = toolchains.listFiles((dir, filename) -> filename.startsWith(toolchainPrefix));
        if (toolchainsForAbi == null || toolchainsForAbi.length == 0) {
            throw new RuntimeException("No toolchains found in the NDK toolchains folder for ABI with prefix: " + toolchainPrefix);
        }
        Revision bestRevision = null;
        String bestVersionString = "";
        for (File toolchainFolder : toolchainsForAbi) {
            String folderName = toolchainFolder.getName();
            Revision revision = new Revision(0);
            String versionString = "";
            if (folderName.length() > toolchainPrefix.length() + 1) {
                try {
                    versionString = folderName.substring(toolchainPrefix.length() + 1);
                    revision = Revision.parseRevision((String)versionString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bestRevision != null && revision.compareTo(bestRevision) <= 0) continue;
            bestRevision = revision;
            bestVersionString = versionString;
        }
        this.defaultToolchainVersions.put((Pair<Toolchain, Abi>)Pair.of((Object)((Object)toolchain), (Object)((Object)abi)), bestVersionString);
        if (bestRevision == null) {
            throw new RuntimeException("Unable to find a valid toolchain in " + toolchains);
        }
        return bestVersionString;
    }

    @Override
    public StlNativeToolSpecification getStlNativeToolSpecification(Stl stl, String stlVersion, Abi abi) {
        StlSpecification spec = new DefaultStlSpecificationFactory().create(stl, (String)MoreObjects.firstNonNull((Object)stlVersion, (Object)this.getDefaultToolchainVersion(Toolchain.GCC, abi)), abi);
        return new DefaultStlNativeToolSpecification(this, spec, stl);
    }

    @Override
    public Collection<Abi> getDefault32BitsAbis() {
        return this.abiInfoList.stream().filter(abiInfo -> abiInfo.isDefault() && !abiInfo.isDeprecated()).map(AbiInfo::getAbi).filter(abi -> !abi.supports64Bits()).collect(Collectors.toList());
    }

    @Override
    public Collection<Abi> getDefaultAbis() {
        return this.abiInfoList.stream().filter(abiInfo -> abiInfo.isDefault() && !abiInfo.isDeprecated()).map(AbiInfo::getAbi).collect(Collectors.toList());
    }

    @Override
    public Collection<Abi> getSupported32BitsAbis() {
        return this.abiInfoList.stream().map(AbiInfo::getAbi).filter(abi -> !abi.supports64Bits()).collect(Collectors.toList());
    }

    @Override
    public Collection<Abi> getSupportedAbis() {
        return this.abiInfoList.stream().map(AbiInfo::getAbi).collect(Collectors.toList());
    }
}

