/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.packaging.GradleKeystoreHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.builder.model.SigningConfig;
import com.android.builder.utils.ExceptionConsumer;
import com.android.builder.utils.SynchronizedFile;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0007J\u0018\u0010\u0013\u001a\u00020\u0010*\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00048\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/ValidateSigningTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "defaultDebugKeystoreLocation", "Ljava/io/File;", "<set-?>", "dummyOutputDirectory", "getDummyOutputDirectory", "()Ljava/io/File;", "setDummyOutputDirectory", "(Ljava/io/File;)V", "signingConfig", "Lcom/android/builder/model/SigningConfig;", "createDefaultDebugKeystoreIfNeeded", "", "forceRerun", "", "isSigningConfigUsingTheDefaultDebugKeystore", "validate", "isSameFile", "other", "ConfigAction", "gradle"})
public class ValidateSigningTask
extends AndroidVariantTask {
    @NotNull
    private File dummyOutputDirectory;
    private SigningConfig signingConfig;
    private File defaultDebugKeystoreLocation;

    @OutputDirectory
    @NotNull
    public final File getDummyOutputDirectory() {
        File file = this.dummyOutputDirectory;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dummyOutputDirectory");
        }
        return file;
    }

    private final void setDummyOutputDirectory(File file) {
        this.dummyOutputDirectory = file;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TaskAction
    public final void validate() throws ExecutionException, IOException {
        SigningConfig signingConfig = this.signingConfig;
        if (signingConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        if (signingConfig.getStoreFile() == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Keystore file not set for signing config ");
            SigningConfig signingConfig2 = this.signingConfig;
            if (signingConfig2 != null) throw (Throwable)new InvalidUserDataException(stringBuilder.append(signingConfig2.getName()).toString());
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
            throw (Throwable)new InvalidUserDataException(stringBuilder.append(signingConfig2.getName()).toString());
        }
        if (this.isSigningConfigUsingTheDefaultDebugKeystore()) {
            this.createDefaultDebugKeystoreIfNeeded();
            return;
        }
        SigningConfig signingConfig3 = this.signingConfig;
        if (signingConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        File file = signingConfig3.getStoreFile();
        if (file != null && file.isFile()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Keystore file '");
        SigningConfig signingConfig4 = this.signingConfig;
        if (signingConfig4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        File file2 = signingConfig4.getStoreFile();
        StringBuilder stringBuilder2 = stringBuilder.append(file2 != null ? file2.getAbsolutePath() : null).append("' ").append("not found for signing config '");
        SigningConfig signingConfig5 = this.signingConfig;
        if (signingConfig5 != null) throw (Throwable)new InvalidUserDataException(stringBuilder2.append(signingConfig5.getName()).append("'.").toString());
        Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        throw (Throwable)new InvalidUserDataException(stringBuilder2.append(signingConfig5.getName()).append("'.").toString());
    }

    private final void createDefaultDebugKeystoreIfNeeded() throws ExecutionException, IOException {
        SigningConfig signingConfig = this.signingConfig;
        if (signingConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        Preconditions.checkState((boolean)signingConfig.isSigningReady(), (String)"Debug signing config not ready.", (Object[])new Object[0]);
        File file = this.defaultDebugKeystoreLocation;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultDebugKeystoreLocation");
        }
        if (!file.getParentFile().canWrite()) {
            StringBuilder stringBuilder = new StringBuilder().append("Unable to create debug keystore in ").append("");
            File file2 = this.defaultDebugKeystoreLocation;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"defaultDebugKeystoreLocation");
            }
            File file3 = file2.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"defaultDebugKeystoreLocation.parentFile");
            throw (Throwable)new IOException(stringBuilder.append(file3.getAbsolutePath()).append(" because it is not writable.").toString());
        }
        File file4 = this.defaultDebugKeystoreLocation;
        if (file4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultDebugKeystoreLocation");
        }
        boolean bl = FileUtils.parentDirExists((File)file4);
        File file5 = this.defaultDebugKeystoreLocation;
        if (file5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultDebugKeystoreLocation");
        }
        Preconditions.checkState((boolean)bl, (String)"Parent directory of the default debug keystore '%s' does not exist", (Object)file5);
        File file6 = this.defaultDebugKeystoreLocation;
        if (file6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultDebugKeystoreLocation");
        }
        SynchronizedFile.getInstanceWithMultiProcessLocking((File)file6).createIfAbsent((ExceptionConsumer)new ExceptionConsumer<File>(this){
            final /* synthetic */ ValidateSigningTask this$0;

            public final void accept(File it) {
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                Logger logger = this.this$0.getLogger();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"this.logger");
                GradleKeystoreHelper.createDefaultDebugStore(file, logger);
            }
            {
                this.this$0 = validateSigningTask;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSigningConfigUsingTheDefaultDebugKeystore() {
        SigningConfig signingConfig = this.signingConfig;
        if (signingConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        if (!Intrinsics.areEqual((Object)signingConfig.getName(), (Object)"debug")) return false;
        SigningConfig signingConfig2 = this.signingConfig;
        if (signingConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        if (!Intrinsics.areEqual((Object)signingConfig2.getKeyAlias(), (Object)"AndroidDebugKey")) return false;
        SigningConfig signingConfig3 = this.signingConfig;
        if (signingConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        if (!Intrinsics.areEqual((Object)signingConfig3.getKeyPassword(), (Object)"android")) return false;
        SigningConfig signingConfig4 = this.signingConfig;
        if (signingConfig4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        if (!Intrinsics.areEqual((Object)signingConfig4.getStorePassword(), (Object)"android")) return false;
        SigningConfig signingConfig5 = this.signingConfig;
        if (signingConfig5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        if (!Intrinsics.areEqual((Object)signingConfig5.getStoreType(), (Object)KeyStore.getDefaultType())) return false;
        SigningConfig signingConfig6 = this.signingConfig;
        if (signingConfig6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        File file = signingConfig6.getStoreFile();
        File file2 = this.defaultDebugKeystoreLocation;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultDebugKeystoreLocation");
        }
        if (!this.isSameFile(file, file2)) return false;
        return true;
    }

    private final boolean isSameFile(@Nullable File $receiver, File other) {
        return $receiver != null && other != null && FileUtils.isSameFile((File)$receiver, (File)other);
    }

    public final boolean forceRerun() {
        SigningConfig signingConfig = this.signingConfig;
        if (signingConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        File file = signingConfig.getStoreFile();
        return file == null || !file.isFile();
    }

    @NotNull
    public static final /* synthetic */ SigningConfig access$getSigningConfig$p(ValidateSigningTask $this) {
        SigningConfig signingConfig = $this.signingConfig;
        if (signingConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        return signingConfig;
    }

    @NotNull
    public static final /* synthetic */ File access$getDefaultDebugKeystoreLocation$p(ValidateSigningTask $this) {
        File file = $this.defaultDebugKeystoreLocation;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultDebugKeystoreLocation");
        }
        return file;
    }

    @NotNull
    public static final /* synthetic */ File access$getDummyOutputDirectory$p(ValidateSigningTask $this) {
        File file = $this.dummyOutputDirectory;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dummyOutputDirectory");
        }
        return file;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/ValidateSigningTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/tasks/ValidateSigningTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "defaultDebugKeystoreLocation", "Ljava/io/File;", "(Lcom/android/build/gradle/internal/scope/VariantScope;Ljava/io/File;)V", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle"})
    public static final class ConfigAction
    implements TaskConfigAction<ValidateSigningTask> {
        private final VariantScope variantScope;
        private final File defaultDebugKeystoreLocation;

        @Override
        @NotNull
        public String getName() {
            return this.variantScope.getTaskName("validateSigning");
        }

        @Override
        @NotNull
        public Class<ValidateSigningTask> getType() {
            return ValidateSigningTask.class;
        }

        @Override
        public void execute(@NotNull ValidateSigningTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            task.setVariantName(this.variantScope.getFullVariantName());
            GradleVariantConfiguration gradleVariantConfiguration = this.variantScope.getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            CoreSigningConfig coreSigningConfig = gradleVariantConfiguration.getSigningConfig();
            if (coreSigningConfig == null) {
                throw (Throwable)new IllegalStateException("No signing config configured for variant " + this.variantScope.getFullVariantName());
            }
            task.signingConfig = coreSigningConfig;
            task.defaultDebugKeystoreLocation = this.defaultDebugKeystoreLocation;
            File file = this.variantScope.getIncrementalDir(this.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"variantScope.getIncrementalDir(name)");
            task.dummyOutputDirectory = file;
            task.getOutputs().upToDateWhen((Spec)new Spec<Task>(task){
                final /* synthetic */ ValidateSigningTask $task;

                public final boolean isSatisfiedBy(Task it) {
                    return !this.$task.forceRerun();
                }
                {
                    this.$task = validateSigningTask;
                }
            });
        }

        public ConfigAction(@NotNull VariantScope variantScope, @NotNull File defaultDebugKeystoreLocation) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            Intrinsics.checkParameterIsNotNull((Object)defaultDebugKeystoreLocation, (String)"defaultDebugKeystoreLocation");
            this.variantScope = variantScope;
            this.defaultDebugKeystoreLocation = defaultDebugKeystoreLocation;
        }
    }
}

