/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.external.cmake.server.BuildFiles;
import com.android.build.gradle.external.cmake.server.CmakeInputsResult;
import com.android.build.gradle.external.cmake.server.CodeModel;
import com.android.build.gradle.external.cmake.server.CompileCommand;
import com.android.build.gradle.external.cmake.server.ComputeResult;
import com.android.build.gradle.external.cmake.server.Configuration;
import com.android.build.gradle.external.cmake.server.ConfigureCommandResult;
import com.android.build.gradle.external.cmake.server.FileGroup;
import com.android.build.gradle.external.cmake.server.HandshakeRequest;
import com.android.build.gradle.external.cmake.server.HandshakeResult;
import com.android.build.gradle.external.cmake.server.Project;
import com.android.build.gradle.external.cmake.server.ProtocolVersion;
import com.android.build.gradle.external.cmake.server.Server;
import com.android.build.gradle.external.cmake.server.ServerFactory;
import com.android.build.gradle.external.cmake.server.ServerUtils;
import com.android.build.gradle.external.cmake.server.Target;
import com.android.build.gradle.external.cmake.server.receiver.InteractiveMessage;
import com.android.build.gradle.external.cmake.server.receiver.ServerReceiver;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.cxx.configure.JsonGenerationAbiConfiguration;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.CompilationDatabaseIndexingVisitorKt;
import com.android.build.gradle.internal.cxx.json.CompilationDatabaseToolchain;
import com.android.build.gradle.internal.cxx.json.CompilationDatabaseToolchainVisitorKt;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValue;
import com.android.build.gradle.internal.cxx.json.NativeSourceFileValue;
import com.android.build.gradle.internal.cxx.json.NativeToolchainValue;
import com.android.build.gradle.internal.cxx.json.StringTable;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.ProcessException;
import com.android.utils.ILogger;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.UnsignedInts;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

class CmakeServerExternalNativeJsonGenerator
extends CmakeExternalNativeJsonGenerator {
    private static final String CMAKE_SERVER_LOG_PREFIX = "CMAKE SERVER: ";

    public CmakeServerExternalNativeJsonGenerator(NdkHandler ndkHandler, String variantName, List<JsonGenerationAbiConfiguration> abis, AndroidBuilder androidBuilder, File sdkFolder, File ndkFolder, File soFolder, File objFolder, File jsonFolder, File makeFile, File cmakeFolder, boolean debuggable, List<String> buildArguments, List<String> cFlags, List<String> cppFlags, List<File> nativeBuildConfigurationsJsons, GradleBuildVariant.Builder stats) {
        super(ndkHandler, variantName, abis, androidBuilder, sdkFolder, ndkFolder, soFolder, objFolder, jsonFolder, makeFile, cmakeFolder, debuggable, buildArguments, cFlags, cppFlags, nativeBuildConfigurationsJsons, stats);
        CmakeServerExternalNativeJsonGenerator.logPreviewWarning(androidBuilder);
    }

    private static void logPreviewWarning(AndroidBuilder androidBuilder) {
        String previewWarning = "Support for CMake 3.7 and higher is a preview feature. To report a bug, see https://developer.android.com/studio/report-bugs.html";
        androidBuilder.getLogger().warning(previewWarning, new Object[0]);
    }

    private static String getOnlyToolchainName(Map<String, NativeToolchainValue> toolchains) {
        if (toolchains.size() != 1) {
            throw new RuntimeException(String.format("Invalid number %d of toolchains. Only one toolchain should be present.", toolchains.size()));
        }
        return toolchains.keySet().iterator().next();
    }

    private static String getCmakeInfoString(Server cmakeServer) throws IOException {
        return String.format("Cmake path: %s, version: %s", cmakeServer.getCmakePath(), CmakeUtils.getVersion(new File(cmakeServer.getCmakePath())).toString());
    }

    @Override
    List<String> getCacheArguments(String abi, int abiPlatformVersion) {
        List<String> cacheArguments = this.getCommonCacheArguments(abi, abiPlatformVersion);
        cacheArguments.add("-DCMAKE_SYSTEM_NAME=Android");
        cacheArguments.add(String.format("-DCMAKE_ANDROID_ARCH_ABI=%s", abi));
        cacheArguments.add(String.format("-DCMAKE_SYSTEM_VERSION=%s", abiPlatformVersion));
        cacheArguments.add("-DCMAKE_EXPORT_COMPILE_COMMANDS=ON");
        cacheArguments.add(String.format("-DCMAKE_ANDROID_NDK=%s", this.getNdkFolder()));
        cacheArguments.add(String.format("-DCMAKE_TOOLCHAIN_FILE=%s", this.getToolchainFile(abi).getAbsolutePath()));
        cacheArguments.add("-G Ninja");
        return cacheArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeProcessAndGetOutput(String abi, int abiPlatformVersion, File outputJsonDir) throws ProcessException, IOException {
        try (PrintWriter serverLogWriter = null;){
            serverLogWriter = CmakeServerExternalNativeJsonGenerator.getCmakeServerLogWriter(ExternalNativeBuildTaskUtils.getOutputFolder(this.getJsonFolder(), abi));
            LoggerWrapper logger = LoggerWrapper.getLogger(CmakeServerExternalNativeJsonGenerator.class);
            Server cmakeServer = this.createServerAndConnect(serverLogWriter, logger);
            this.doHandshake(outputJsonDir, cmakeServer);
            ConfigureCommandResult configureCommandResult = this.doConfigure(abi, abiPlatformVersion, cmakeServer);
            if (!ServerUtils.isConfigureResultValid(configureCommandResult.configureResult)) {
                throw new ProcessException("Error configuring");
            }
            ComputeResult computeResult = CmakeServerExternalNativeJsonGenerator.doCompute(cmakeServer);
            if (!ServerUtils.isComputedResultValid(computeResult)) {
                throw new ProcessException("Error computing");
            }
            this.generateAndroidGradleBuild(abi, cmakeServer);
            String string = configureCommandResult.interactiveMessages;
            return string;
        }
    }

    private static PrintWriter getCmakeServerLogWriter(File outputFolder) throws IOException {
        return new PrintWriter(CmakeServerExternalNativeJsonGenerator.getCmakeServerLog(outputFolder).getAbsoluteFile(), "UTF-8");
    }

    private static File getCmakeServerLog(File outputFolder) {
        return new File(outputFolder, "cmake_server_log.txt");
    }

    private Server createServerAndConnect(PrintWriter serverLogWriter, ILogger logger) throws IOException {
        ServerReceiver serverReceiver = new ServerReceiver().setMessageReceiver(message -> CmakeServerExternalNativeJsonGenerator.receiveInteractiveMessage(serverLogWriter, logger, message, this.getMakefile().getParentFile())).setDiagnosticReceiver(message -> CmakeServerExternalNativeJsonGenerator.receiveDiagnosticMessage(serverLogWriter, logger, message));
        Server cmakeServer = ServerFactory.create(this.getCmakeBinFolder(), serverReceiver);
        if (cmakeServer == null) {
            throw new RuntimeException("Unable to create a Cmake server located at: " + this.getCmakeBinFolder().getAbsolutePath());
        }
        if (!cmakeServer.connect()) {
            throw new RuntimeException("Unable to connect to Cmake server located at: " + this.getCmakeBinFolder().getAbsolutePath());
        }
        return cmakeServer;
    }

    static void receiveInteractiveMessage(PrintWriter writer, ILogger logger, InteractiveMessage message, File makeFileDirectory) {
        writer.println(CMAKE_SERVER_LOG_PREFIX + message.message);
        CmakeServerExternalNativeJsonGenerator.logInteractiveMessage(logger, message, makeFileDirectory);
    }

    static void logInteractiveMessage(ILogger logger, InteractiveMessage message, File makeFileDirectory) {
        String CMAKE_ERROR_PREFIX = "CMake Error";
        String CMAKE_WARNING_PREFIX = "CMake Warning";
        if (message.type != null && message.type.equals("error")) {
            logger.error(null, CmakeServerExternalNativeJsonGenerator.correctMakefilePaths(message.errorMessage, makeFileDirectory), new Object[0]);
            return;
        }
        String correctedMessage = CmakeServerExternalNativeJsonGenerator.correctMakefilePaths(message.message, makeFileDirectory);
        if (message.title != null && message.title.equals("Error") || message.message.startsWith("CMake Error")) {
            logger.error(null, correctedMessage, new Object[0]);
            return;
        }
        if (message.title != null && message.title.equals("Warning") || message.message.startsWith("CMake Warning")) {
            logger.warning(correctedMessage, new Object[0]);
            return;
        }
        logger.info(correctedMessage, new Object[0]);
    }

    static void receiveDiagnosticMessage(PrintWriter writer, ILogger logger, String message) {
        writer.println(CMAKE_SERVER_LOG_PREFIX + message);
        logger.info(message, new Object[0]);
    }

    private void doHandshake(File outputDir, Server cmakeServer) throws IOException {
        List<ProtocolVersion> supportedProtocolVersions = cmakeServer.getSupportedVersion();
        if (supportedProtocolVersions == null || supportedProtocolVersions.isEmpty()) {
            throw new RuntimeException(String.format("Gradle does not support the Cmake server version. %s", CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
        HandshakeResult handshakeResult = cmakeServer.handshake(this.getHandshakeRequest(supportedProtocolVersions.get(0), outputDir));
        if (!ServerUtils.isHandshakeResultValid(handshakeResult)) {
            throw new RuntimeException(String.format("Invalid handshake result from Cmake server: \n%s\n%s", CmakeUtils.getObjectToString(handshakeResult), CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
    }

    private HandshakeRequest getHandshakeRequest(ProtocolVersion cmakeServerProtocolVersion, File outputDir) {
        HandshakeRequest handshakeRequest = new HandshakeRequest();
        handshakeRequest.cookie = "gradle-cmake-cookie";
        handshakeRequest.generator = CmakeServerExternalNativeJsonGenerator.getGenerator(this.getBuildArguments());
        handshakeRequest.protocolVersion = cmakeServerProtocolVersion;
        handshakeRequest.buildDirectory = CmakeServerExternalNativeJsonGenerator.normalizeFilePath(outputDir.getParentFile());
        handshakeRequest.sourceDirectory = CmakeServerExternalNativeJsonGenerator.normalizeFilePath(this.getMakefile().getParentFile());
        return handshakeRequest;
    }

    private ConfigureCommandResult doConfigure(String abi, int abiPlatformVersion, Server cmakeServer) throws IOException {
        List<String> cacheArgumentsList = this.getCacheArguments(abi, abiPlatformVersion);
        cacheArgumentsList.addAll(this.getBuildArguments());
        return cmakeServer.configure(cacheArgumentsList.toArray(new String[cacheArgumentsList.size()]));
    }

    private static ComputeResult doCompute(Server cmakeServer) throws IOException {
        return cmakeServer.compute();
    }

    private static String getGenerator(List<String> buildArguments) {
        String generatorArgument = "-G ";
        for (String argument : buildArguments) {
            if (!argument.startsWith(generatorArgument)) continue;
            int startIndex = argument.indexOf(generatorArgument) + generatorArgument.length();
            return argument.substring(startIndex, argument.length());
        }
        return "Ninja";
    }

    private void generateAndroidGradleBuild(String abi, Server cmakeServer) throws IOException {
        NativeBuildConfigValue nativeBuildConfigValue = this.getNativeBuildConfigValue(abi, cmakeServer);
        AndroidBuildGradleJsons.writeNativeBuildConfigValueToJsonFile(ExternalNativeBuildTaskUtils.getOutputJson(this.getJsonFolder(), abi), nativeBuildConfigValue);
    }

    protected NativeBuildConfigValue getNativeBuildConfigValue(String abi, Server cmakeServer) throws IOException {
        NativeBuildConfigValue nativeBuildConfigValue = CmakeServerExternalNativeJsonGenerator.createDefaultNativeBuildConfigValue();
        assert (nativeBuildConfigValue.stringTable != null);
        StringTable strings = new StringTable(nativeBuildConfigValue.stringTable);
        assert (nativeBuildConfigValue.buildFiles != null);
        nativeBuildConfigValue.buildFiles.addAll(this.getBuildFiles(abi, cmakeServer));
        assert (nativeBuildConfigValue.cleanCommands != null);
        nativeBuildConfigValue.cleanCommands.add(CmakeUtils.getCleanCommand(this.getCmakeExecutable(), ExternalNativeBuildTaskUtils.getOutputFolder(this.getJsonFolder(), abi)));
        CodeModel codeModel = cmakeServer.codemodel();
        if (!ServerUtils.isCodeModelValid(codeModel)) {
            throw new RuntimeException(String.format("Invalid code model received from Cmake server: \n%s\n%s", CmakeUtils.getObjectToString(codeModel), CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
        assert (nativeBuildConfigValue.cFileExtensions != null);
        nativeBuildConfigValue.cFileExtensions.addAll(CmakeUtils.getCExtensionSet(codeModel));
        assert (nativeBuildConfigValue.cppFileExtensions != null);
        nativeBuildConfigValue.cppFileExtensions.addAll(CmakeUtils.getCppExtensionSet(codeModel));
        nativeBuildConfigValue.toolchains = this.getNativeToolchains(abi, cmakeServer, nativeBuildConfigValue.cppFileExtensions, nativeBuildConfigValue.cFileExtensions);
        String toolchainHashString = CmakeServerExternalNativeJsonGenerator.getOnlyToolchainName(nativeBuildConfigValue.toolchains);
        for (Configuration config2 : codeModel.configurations) {
            for (Project project : config2.projects) {
                for (Target target : project.targets) {
                    if (!CmakeServerExternalNativeJsonGenerator.canAddTargetToNativeLibrary(target)) continue;
                    NativeLibraryValue nativeLibraryValue = this.getNativeLibraryValue(abi, target, strings);
                    nativeLibraryValue.toolchain = toolchainHashString;
                    String libraryName = target.name + "-" + config2.name + "-" + abi;
                    assert (nativeBuildConfigValue.libraries != null);
                    nativeBuildConfigValue.libraries.put(libraryName, nativeLibraryValue);
                }
            }
        }
        return nativeBuildConfigValue;
    }

    protected NativeLibraryValue getNativeLibraryValue(String abi, Target target, StringTable strings) {
        NativeLibraryValue nativeLibraryValue = new NativeLibraryValue();
        nativeLibraryValue.abi = abi;
        nativeLibraryValue.buildCommand = CmakeUtils.getBuildCommand(this.getCmakeExecutable(), ExternalNativeBuildTaskUtils.getOutputFolder(this.getJsonFolder(), abi), target.name);
        nativeLibraryValue.artifactName = target.name;
        String string = nativeLibraryValue.buildType = this.isDebuggable() ? "debug" : "release";
        if (target.artifacts.length > 0) {
            nativeLibraryValue.output = new File(target.artifacts[0]);
        }
        nativeLibraryValue.files = new ArrayList<NativeSourceFileValue>();
        Map<Object, Object> compilationDatabaseFlags = Maps.newHashMap();
        for (FileGroup fileGroup : target.fileGroups) {
            for (String source : fileGroup.sources) {
                File sourceFile;
                NativeSourceFileValue nativeSourceFileValue = new NativeSourceFileValue();
                nativeSourceFileValue.workingDirectoryOrdinal = strings.intern(target.buildDirectory);
                nativeSourceFileValue.src = sourceFile = new File(target.sourceDirectory, source);
                if (Strings.isNullOrEmpty((String)fileGroup.compileFlags)) {
                    if (compilationDatabaseFlags.isEmpty()) {
                        compilationDatabaseFlags = CompilationDatabaseIndexingVisitorKt.indexCompilationDatabase(this.getCompileCommandsJson(abi), strings);
                    }
                    if (compilationDatabaseFlags.containsKey(sourceFile.toString())) {
                        nativeSourceFileValue.flagsOrdinal = (Integer)compilationDatabaseFlags.get(sourceFile.toString());
                    }
                } else {
                    nativeSourceFileValue.flagsOrdinal = strings.intern(fileGroup.compileFlags);
                }
                nativeLibraryValue.files.add(nativeSourceFileValue);
            }
        }
        return nativeLibraryValue;
    }

    private static boolean canAddTargetToNativeLibrary(Target target) {
        return target.artifacts != null && target.fileGroups != null;
    }

    private List<File> getBuildFiles(String abi, Server cmakeServer) throws IOException {
        CmakeInputsResult cmakeInputsResult = cmakeServer.cmakeInputs();
        if (!ServerUtils.isCmakeInputsResultValid(cmakeInputsResult)) {
            throw new RuntimeException(String.format("Invalid cmakeInputs result received from Cmake server: \n%s\n%s", CmakeUtils.getObjectToString(cmakeInputsResult), CmakeServerExternalNativeJsonGenerator.getCmakeInfoString(cmakeServer)));
        }
        if (cmakeInputsResult.buildFiles == null) {
            ArrayList buildFiles = Lists.newArrayList();
            buildFiles.add(this.getMakefile());
            return buildFiles;
        }
        HashSet buildSources = Sets.newHashSet();
        for (BuildFiles buildFile : cmakeInputsResult.buildFiles) {
            if (buildFile.isTemporary || buildFile.isCMake || buildFile.sources == null) continue;
            Collections.addAll(buildSources, buildFile.sources);
        }
        File sourceDirectory = null;
        if (cmakeInputsResult.sourceDirectory != null) {
            sourceDirectory = new File(cmakeInputsResult.sourceDirectory);
        }
        ArrayList buildFiles = Lists.newArrayList();
        File preNDKr15ToolchainFile = CmakeServerExternalNativeJsonGenerator.getTempToolchainFile(ExternalNativeBuildTaskUtils.getOutputFolder(this.getJsonFolder(), abi));
        for (String source : buildSources) {
            File sourceFile = new File(source);
            if (!sourceFile.isAbsolute() && sourceDirectory != null) {
                sourceFile = new File(sourceDirectory, source);
            }
            if (!sourceFile.exists()) {
                LoggerWrapper logger = LoggerWrapper.getLogger(CmakeServerExternalNativeJsonGenerator.class);
                logger.error(null, "Build file " + sourceFile + " provided by CMake does not exists. This might lead to incorrect Android Studio behavior.", new Object[0]);
                continue;
            }
            if (preNDKr15ToolchainFile.getName().equals(sourceFile.getName())) continue;
            buildFiles.add(sourceFile);
        }
        return buildFiles;
    }

    private static NativeBuildConfigValue createDefaultNativeBuildConfigValue() {
        NativeBuildConfigValue nativeBuildConfigValue = new NativeBuildConfigValue();
        nativeBuildConfigValue.buildFiles = new ArrayList<File>();
        nativeBuildConfigValue.cleanCommands = new ArrayList<String>();
        nativeBuildConfigValue.libraries = new HashMap<String, NativeLibraryValue>();
        nativeBuildConfigValue.toolchains = new HashMap<String, NativeToolchainValue>();
        nativeBuildConfigValue.cFileExtensions = new ArrayList<String>();
        nativeBuildConfigValue.cppFileExtensions = new ArrayList<String>();
        nativeBuildConfigValue.stringTable = Maps.newHashMap();
        return nativeBuildConfigValue;
    }

    private Map<String, NativeToolchainValue> getNativeToolchains(String abi, Server cmakeServer, Collection<String> cppExtensionSet, Collection<String> cExtensionSet) {
        NativeToolchainValue toolchainValue = new NativeToolchainValue();
        File cCompilerExecutable = null;
        File cppCompilerExecutable = null;
        File compilationDatabase = this.getCompileCommandsJson(abi);
        if (compilationDatabase.exists()) {
            CompilationDatabaseToolchain toolchain = CompilationDatabaseToolchainVisitorKt.populateCompilationDatabaseToolchains(compilationDatabase, cppExtensionSet, cExtensionSet);
            cppCompilerExecutable = toolchain.getCppCompilerExecutable();
            cCompilerExecutable = toolchain.getCCompilerExecutable();
        } else {
            if (!cmakeServer.getCCompilerExecutable().isEmpty()) {
                cCompilerExecutable = new File(cmakeServer.getCCompilerExecutable());
            }
            if (!cmakeServer.getCppCompilerExecutable().isEmpty()) {
                cppCompilerExecutable = new File(cmakeServer.getCppCompilerExecutable());
            }
        }
        if (cCompilerExecutable != null) {
            toolchainValue.cCompilerExecutable = cCompilerExecutable;
        }
        if (cppCompilerExecutable != null) {
            toolchainValue.cppCompilerExecutable = cppCompilerExecutable;
        }
        int toolchainHash = CmakeUtils.getToolchainHash(toolchainValue);
        String toolchainHashString = UnsignedInts.toString((int)toolchainHash);
        HashMap<String, NativeToolchainValue> toolchains = new HashMap<String, NativeToolchainValue>();
        toolchains.put(toolchainHashString, toolchainValue);
        return toolchains;
    }

    static String getAndroidGradleFileLibFlags(String fileName, List<CompileCommand> compileCommands) {
        String flags = null;
        Path fileNamePath = Paths.get(fileName, new String[0]);
        for (CompileCommand compileCommand : compileCommands) {
            if (compileCommand.command == null || compileCommand.file == null || fileNamePath.compareTo(Paths.get(compileCommand.file, new String[0])) != 0) continue;
            flags = compileCommand.command.substring(compileCommand.command.indexOf(32) + 1, compileCommand.command.indexOf(fileName));
            break;
        }
        return flags;
    }

    private File getToolchainFile(String abi) {
        if (this.getNdkHandler().getRevision() != null && this.getNdkHandler().getRevision().getMajor() >= 15) {
            return this.getToolChainFile();
        }
        return this.getPreNDKr15WrapperToolchainFile(ExternalNativeBuildTaskUtils.getOutputFolder(this.getJsonFolder(), abi));
    }

    private File getPreNDKr15WrapperToolchainFile(File outputFolder) {
        StringBuilder tempAndroidToolchain = new StringBuilder("# This toolchain file was generated by Gradle to support NDK versions r14 and below.\n");
        tempAndroidToolchain.append(String.format("include(%s)", CmakeServerExternalNativeJsonGenerator.normalizeFilePath(this.getToolChainFile()))).append(System.lineSeparator());
        tempAndroidToolchain.append("set(CMAKE_SYSTEM_VERSION 1)").append(System.lineSeparator());
        File toolchainFile = CmakeServerExternalNativeJsonGenerator.getTempToolchainFile(outputFolder);
        try {
            FileUtils.writeStringToFile((File)toolchainFile, (String)tempAndroidToolchain.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to write to file: %s.Please upgrade NDK to version 15 or above.", toolchainFile.getAbsolutePath()));
        }
        return toolchainFile;
    }

    private static File getTempToolchainFile(File outputFolder) {
        String tempAndroidToolchainFile = "pre-ndk-r15-wrapper-android.toolchain.cmake";
        return new File(outputFolder, tempAndroidToolchainFile);
    }

    private static String normalizeFilePath(File file) {
        if (CmakeServerExternalNativeJsonGenerator.isWindows()) {
            return file.getPath().replace("\\", "/");
        }
        return file.getPath();
    }
}

