/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.wireless.android.sdk.stats.AnnotationProcessorInfo;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.List;
import org.gradle.api.JavaVersion;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

@CacheableTask
public class AndroidJavaCompile
extends JavaCompile {
    String compileSdkVersion;
    InstantRunBuildContext mInstantRunBuildContext;
    File annotationProcessorOutputFolder;
    BuildableArtifact processorListFile;
    String variantName;
    BuildableArtifact dataBindingDependencyArtifacts;
    File dataBindingArtifactOutputDirectory;

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFiles
    public BuildableArtifact getProcessorListFile() {
        return this.processorListFile;
    }

    @OutputDirectory
    public File getAnnotationProcessorOutputFolder() {
        return this.annotationProcessorOutputFolder;
    }

    @OutputDirectory
    @Optional
    public File getDataBindingArtifactOutputDirectory() {
        return this.dataBindingArtifactOutputDirectory;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @Optional
    public BuildableArtifact getDataBindingDependencyArtifacts() {
        return this.dataBindingDependencyArtifacts;
    }

    protected void compile(IncrementalTaskInputs inputs) {
        this.getLogger().info("Compiling with source level {} and target level {}.", (Object)this.getSourceCompatibility(), (Object)this.getTargetCompatibility());
        if (this.isPostN() && !JavaVersion.current().isJava8Compatible()) {
            throw new RuntimeException("compileSdkVersion '" + this.compileSdkVersion + "' requires JDK 1.8 or later to compile.");
        }
        this.processAnalytics();
        FileUtils.mkdirs((File)this.annotationProcessorOutputFolder);
        this.mInstantRunBuildContext.startRecording(InstantRunBuildContext.TaskType.JAVAC);
        super.compile(inputs);
        this.mInstantRunBuildContext.stopRecording(InstantRunBuildContext.TaskType.JAVAC);
    }

    void processAnalytics() {
        List classNames;
        Gson gson = new GsonBuilder().create();
        try (FileReader reader = new FileReader(BuildableArtifactUtil.singleFile(this.processorListFile));){
            classNames = (List)gson.fromJson((Reader)reader, new TypeToken<List<String>>(){}.getType());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String projectPath = this.getProject().getPath();
        GradleBuildVariant.Builder variant = ProcessProfileWriter.getOrCreateVariant((String)projectPath, (String)this.variantName);
        for (String processorName : classNames) {
            AnnotationProcessorInfo.Builder builder = AnnotationProcessorInfo.newBuilder();
            builder.setSpec(processorName);
            variant.addAnnotationProcessors(builder);
        }
    }

    @Internal
    private boolean isPostN() {
        AndroidVersion hash = AndroidTargetHash.getVersionFromHash((String)this.compileSdkVersion);
        return hash != null && hash.getApiLevel() >= 24;
    }
}

