/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.ide.common.repository.GradleVersion;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"CRASHLYTICS_PLUGIN_DEPENDENCY_GROUP_AND_NAME", "", "CRASHLYTICS_PLUGIN_MINIMUM_VERSION", "CRASHLYTICS_PLUGIN_MINIMUM_VERSION_REASON", "CRASHLYTICS_PLUGIN_NAME", "INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS", "enforceMinimumVersionOfPlugin", "", "project", "Lorg/gradle/api/Project;", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "pluginName", "dependencyGroupAndName", "minimumVersion", "reason", "enforceMinimumVersionsOfPlugins", "gradle"})
@JvmName(name="GradlePluginUtils")
public final class GradlePluginUtils {
    private static final String INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS = "INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS";
    private static final String CRASHLYTICS_PLUGIN_NAME = "Crashlytics";
    private static final String CRASHLYTICS_PLUGIN_DEPENDENCY_GROUP_AND_NAME = "io.fabric.tools:gradle";
    private static final String CRASHLYTICS_PLUGIN_MINIMUM_VERSION = "1.25.4";
    private static final String CRASHLYTICS_PLUGIN_MINIMUM_VERSION_REASON = "See https://issuetracker.google.com/79997489 for details.";

    public static final void enforceMinimumVersionsOfPlugins(@NotNull Project project, @NotNull EvalIssueReporter issueReporter) {
        boolean alreadyChecked;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        ExtensionContainer extensionContainer = project2.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer, (String)"project.rootProject.extensions");
        ExtraPropertiesExtension extraPropertiesExtension = extensionContainer.getExtraProperties();
        Intrinsics.checkExpressionValueIsNotNull((Object)extraPropertiesExtension, (String)"project.rootProject.extensions.extraProperties");
        boolean bl = alreadyChecked = extraPropertiesExtension.getProperties().putIfAbsent(INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS, true) != null;
        if (alreadyChecked) {
            return;
        }
        project.getGradle().projectsEvaluated((Action)new Action<Gradle>(issueReporter){
            final /* synthetic */ EvalIssueReporter $issueReporter;

            public final void execute(Gradle gradle) {
                gradle.allprojects((Action)new Action<Project>(this){
                    final /* synthetic */ enforceMinimumVersionsOfPlugins.1 this$0;

                    public final void execute(Project it) {
                        Project project = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                        GradlePluginUtils.access$enforceMinimumVersionOfPlugin(project, this.this$0.$issueReporter, "Crashlytics", "io.fabric.tools:gradle", "1.25.4", "See https://issuetracker.google.com/79997489 for details.");
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$issueReporter = evalIssueReporter;
            }
        });
    }

    private static final void enforceMinimumVersionOfPlugin(Project project, EvalIssueReporter issueReporter, String pluginName, String dependencyGroupAndName, String minimumVersion, String reason) {
        ScriptHandler scriptHandler = project.getBuildscript();
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.buildscript");
        Configuration configuration = scriptHandler.getConfigurations().getByName("classpath");
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"project.buildscript.conf\u2026(CLASSPATH_CONFIGURATION)");
        ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedConfiguration, (String)"project.buildscript.conf\u2026   .resolvedConfiguration");
        Iterator iterator = resolvedConfiguration.getResolvedArtifacts().iterator();
        while (iterator.hasNext()) {
            GradleVersion currentVersion;
            ResolvedArtifact artifact;
            ResolvedArtifact resolvedArtifact = artifact = (ResolvedArtifact)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"artifact");
            ResolvedModuleVersion resolvedModuleVersion = resolvedArtifact.getModuleVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedModuleVersion, (String)"artifact.moduleVersion");
            ModuleVersionIdentifier artifactId = resolvedModuleVersion.getId();
            StringBuilder stringBuilder = new StringBuilder().append("");
            ModuleVersionIdentifier moduleVersionIdentifier = artifactId;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleVersionIdentifier, (String)"artifactId");
            if (Intrinsics.areEqual((Object)stringBuilder.append(moduleVersionIdentifier.getGroup()).append(':').append(artifactId.getName()).toString(), (Object)dependencyGroupAndName) ^ true) continue;
            if (GradleVersion.tryParse((String)artifactId.getVersion()) == null) {
                continue;
            }
            if (currentVersion.compareTo(minimumVersion) >= 0) continue;
            String string = "The minimum supported version of the " + pluginName + " plugin" + " (" + dependencyGroupAndName + ") is " + minimumVersion + '.' + " Project '" + project.getName() + "' is using version " + currentVersion + '.' + ' ' + reason;
            File file = project.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
            issueReporter.reportError(EvalIssueReporter.Type.THIRD_PARTY_GRADLE_PLUGIN_TOO_OLD, new EvalIssueException(string, file.getPath(), null));
        }
    }

    public static final /* synthetic */ void access$enforceMinimumVersionOfPlugin(@NotNull Project project, @NotNull EvalIssueReporter issueReporter, @NotNull String pluginName, @NotNull String dependencyGroupAndName, @NotNull String minimumVersion, @NotNull String reason) {
        GradlePluginUtils.enforceMinimumVersionOfPlugin(project, issueReporter, pluginName, dependencyGroupAndName, minimumVersion, reason);
    }
}

