/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.errors;

import com.android.build.gradle.internal.errors.MessageReceiverImpl$WhenMappings;
import com.android.build.gradle.internal.errors.MessageReceiverImplKt;
import com.android.build.gradle.options.SyncOptions;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageJsonSerializer;
import com.android.ide.common.blame.MessageReceiver;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/errors/MessageReceiverImpl;", "Lcom/android/ide/common/blame/MessageReceiver;", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;Lorg/gradle/api/logging/Logger;)V", "mGson", "Lcom/google/gson/Gson;", "machineReadableMessage", "", "message", "Lcom/android/ide/common/blame/Message;", "receiveMessage", "", "gradle"})
public final class MessageReceiverImpl
implements MessageReceiver {
    private final Gson mGson;
    private final SyncOptions.ErrorFormatMode errorFormatMode;
    private final Logger logger;

    public void receiveMessage(@NotNull Message message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        switch (MessageReceiverImpl$WhenMappings.$EnumSwitchMapping$0[message.getKind().ordinal()]) {
            case 1: {
                if (Intrinsics.areEqual((Object)((Object)this.errorFormatMode), (Object)((Object)SyncOptions.ErrorFormatMode.MACHINE_PARSABLE))) {
                    this.logger.error(this.machineReadableMessage(message));
                    break;
                }
                this.logger.error(MessageReceiverImplKt.humanReadableMessage(message));
                break;
            }
            case 2: {
                if (Intrinsics.areEqual((Object)((Object)this.errorFormatMode), (Object)((Object)SyncOptions.ErrorFormatMode.MACHINE_PARSABLE))) {
                    this.logger.warn(this.machineReadableMessage(message));
                    break;
                }
                this.logger.warn(MessageReceiverImplKt.humanReadableMessage(message));
                break;
            }
            case 3: {
                this.logger.info(MessageReceiverImplKt.humanReadableMessage(message));
                break;
            }
            case 4: {
                this.logger.trace(MessageReceiverImplKt.humanReadableMessage(message));
                break;
            }
            case 5: {
                this.logger.warn(MessageReceiverImplKt.humanReadableMessage(message));
                break;
            }
            case 6: {
                this.logger.warn(MessageReceiverImplKt.humanReadableMessage(message));
            }
        }
    }

    private final String machineReadableMessage(Message message) {
        StringBuilder stringBuilder = new StringBuilder().append("AGPBI: ");
        Gson gson = this.mGson;
        if (gson == null) {
            Intrinsics.throwNpe();
        }
        return stringBuilder.append(gson.toJson((Object)message)).toString();
    }

    public MessageReceiverImpl(@NotNull SyncOptions.ErrorFormatMode errorFormatMode, @NotNull Logger logger) {
        Gson gson;
        Intrinsics.checkParameterIsNotNull((Object)((Object)errorFormatMode), (String)"errorFormatMode");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.errorFormatMode = errorFormatMode;
        this.logger = logger;
        if (Intrinsics.areEqual((Object)((Object)this.errorFormatMode), (Object)((Object)SyncOptions.ErrorFormatMode.MACHINE_PARSABLE))) {
            GsonBuilder gsonBuilder = new GsonBuilder();
            MessageJsonSerializer.registerTypeAdapters((GsonBuilder)gsonBuilder);
            gson = gsonBuilder.create();
        } else {
            gson = null;
        }
        this.mGson = gson;
    }
}

