/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.cxx.configure.JsonGenerationVariantConfiguration;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.ProcessException;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.IOException;
import java.util.List;

class CmakeAndroidNinjaExternalNativeJsonGenerator
extends CmakeExternalNativeJsonGenerator {
    CmakeAndroidNinjaExternalNativeJsonGenerator(JsonGenerationVariantConfiguration config2, AndroidBuilder androidBuilder, File cmakeInstallFolder, GradleBuildVariant.Builder stats) {
        super(config2, androidBuilder, cmakeInstallFolder, stats);
    }

    @Override
    List<String> getCacheArguments(String abi, int abiPlatformVersion) {
        List<String> cacheArguments = this.getCommonCacheArguments(abi, abiPlatformVersion);
        cacheArguments.add(String.format("-DCMAKE_TOOLCHAIN_FILE=%s", this.getToolChainFile().getAbsolutePath()));
        cacheArguments.add(String.format("-DCMAKE_MAKE_PROGRAM=%s", this.getNinjaExecutable().getAbsolutePath()));
        cacheArguments.add("-GAndroid Gradle - Ninja");
        return cacheArguments;
    }

    @Override
    public String executeProcessAndGetOutput(String abi, int abiPlatformVersion, File outputJsonDir) throws ProcessException, IOException {
        String logPrefix = "Variant=" + this.config.variantName + " ABI=" + abi + " :";
        return ExternalNativeBuildTaskUtils.executeBuildProcessAndLogError(this.androidBuilder, this.getProcessBuilder(abi, abiPlatformVersion, outputJsonDir), true, logPrefix);
    }

    private File getNinjaExecutable() {
        if (CmakeAndroidNinjaExternalNativeJsonGenerator.isWindows()) {
            return new File(this.getCmakeBinFolder(), "ninja.exe");
        }
        return new File(this.getCmakeBinFolder(), "ninja");
    }
}

