/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.gradle.shrinker.parser.BytecodeVersion;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Predicate;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;

public class RewriteOutputVisitor
extends ClassVisitor {
    private final Set<String> mMembers;
    private final Predicate<String> mClassKeptPredicate;
    private final Remapper mRemapper;
    private final BytecodeVersion mBytecodeVersion;

    public RewriteOutputVisitor(Set<String> members, Predicate<String> classKeptPredicate, BytecodeVersion bytecodeVersion, ClassVisitor cv) {
        super(327680, cv);
        this.mMembers = members;
        this.mClassKeptPredicate = classKeptPredicate;
        this.mBytecodeVersion = bytecodeVersion;
        this.mRemapper = new ToObjectRemapper();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        ArrayList interfacesToKeep = Lists.newArrayList();
        for (String iface : interfaces) {
            if (!this.mClassKeptPredicate.test(iface)) continue;
            interfacesToKeep.add(iface);
        }
        if (this.mBytecodeVersion != null) {
            version = this.mBytecodeVersion.getBytes();
        }
        signature = this.mRemapper.mapSignature(signature, false);
        super.visit(version, access, name, signature, superName, (String[])Iterables.toArray((Iterable)interfacesToKeep, String.class));
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        signature = this.mRemapper.mapSignature(signature, true);
        if (this.mMembers.contains(name + ":" + desc)) {
            return super.visitField(access, name, desc, signature, value);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        signature = this.mRemapper.mapSignature(signature, false);
        if (!this.mMembers.contains(name + ":" + desc)) {
            return null;
        }
        return new MethodVisitor(327680, super.visitMethod(access, name, desc, signature, exceptions)){

            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                signature = RewriteOutputVisitor.this.mRemapper.mapSignature(signature, true);
                super.visitLocalVariable(name, desc, signature, start, end, index);
            }
        };
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.mClassKeptPredicate.test(name)) {
            super.visitInnerClass(name, outerName, innerName, access);
        }
    }

    private class ToObjectRemapper
    extends Remapper {
        private ToObjectRemapper() {
        }

        public String map(String type) {
            if (RewriteOutputVisitor.this.mClassKeptPredicate.test(type)) {
                return type;
            }
            return "java/lang/Object";
        }
    }
}

