/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.android.utils.StringHelper;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.Task;
import org.gradle.api.tasks.bundling.Zip;

public class LibraryVariantData
extends BaseVariantData
implements TestedVariantData {
    private final Map<VariantType, TestVariantData> testVariants = Maps.newHashMap();
    public Zip packageLibTask;
    public ExtractAnnotations generateAnnotationsTask = null;

    public LibraryVariantData(GlobalScope globalScope, AndroidConfig androidConfig, TaskManager taskManager, GradleVariantConfiguration config2, Recorder recorder) {
        super(globalScope, androidConfig, taskManager, config2, recorder);
        this.getOutputFactory().addMainOutput(globalScope.getProjectBaseName() + "-" + this.getVariantConfiguration().getBaseName() + "." + "aar");
    }

    @Override
    public String getDescription() {
        VariantConfiguration config2 = this.getVariantConfiguration();
        if (config2.hasFlavors()) {
            StringBuilder sb = new StringBuilder(50);
            StringHelper.appendCapitalized((StringBuilder)sb, (String)((CoreBuildType)config2.getBuildType()).getName());
            sb.append(" build for flavor ");
            StringHelper.appendCapitalized((StringBuilder)sb, (String)config2.getFlavorName());
            return sb.toString();
        }
        return StringHelper.capitalizeWithSuffix((String)((CoreBuildType)config2.getBuildType()).getName(), (String)" build");
    }

    @Override
    public TestVariantData getTestVariantData(VariantType type) {
        return this.testVariants.get(type);
    }

    @Override
    public void setTestVariantData(TestVariantData testVariantData, VariantType type) {
        this.testVariants.put(type, testVariantData);
    }

    @Override
    public void registerJavaGeneratingTask(Task task, File ... generatedSourceFolders) {
        super.registerJavaGeneratingTask(task, generatedSourceFolders);
        if (this.generateAnnotationsTask != null) {
            for (File f : generatedSourceFolders) {
                this.generateAnnotationsTask.source(new Object[]{f});
            }
        }
    }

    @Override
    public void registerJavaGeneratingTask(Task task, Collection<File> generatedSourceFolders) {
        super.registerJavaGeneratingTask(task, generatedSourceFolders);
        if (this.generateAnnotationsTask != null) {
            for (File f : generatedSourceFolders) {
                this.generateAnnotationsTask.source(new Object[]{f});
            }
        }
    }
}

