/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.ide.DefaultAppBundleProjectBuildOutput;
import com.android.build.gradle.internal.ide.DefaultAppBundleVariantBuildOutput;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001aH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/AppModelBuilder;", "Lcom/android/build/gradle/internal/ide/ModelBuilder;", "Lcom/android/build/gradle/internal/dsl/BaseAppModuleExtension;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "variantManager", "Lcom/android/build/gradle/internal/VariantManager;", "taskManager", "Lcom/android/build/gradle/internal/TaskManager;", "config", "extraModelInfo", "Lcom/android/build/gradle/internal/ExtraModelInfo;", "nativeLibraryFactory", "Lcom/android/build/gradle/internal/model/NativeLibraryFactory;", "projectType", "", "generation", "(Lcom/android/build/gradle/internal/scope/GlobalScope;Lcom/android/build/gradle/internal/VariantManager;Lcom/android/build/gradle/internal/TaskManager;Lcom/android/build/gradle/internal/dsl/BaseAppModuleExtension;Lcom/android/build/gradle/internal/ExtraModelInfo;Lcom/android/build/gradle/internal/model/NativeLibraryFactory;II)V", "buildAll", "", "modelName", "", "project", "Lorg/gradle/api/Project;", "buildMinimalisticModel", "canBuild", "", "getDynamicFeatures", "", "isBaseSplit", "gradle"})
public final class AppModelBuilder
extends ModelBuilder<BaseAppModuleExtension> {
    private final VariantManager variantManager;

    @Override
    protected boolean isBaseSplit() {
        return true;
    }

    @Override
    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        return super.canBuild(modelName) || Intrinsics.areEqual((Object)modelName, (Object)AppBundleProjectBuildOutput.class.getName());
    }

    @Override
    @NotNull
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (Intrinsics.areEqual((Object)modelName, (Object)AppBundleProjectBuildOutput.class.getName())) {
            object = this.buildMinimalisticModel();
        } else {
            Object object2 = super.buildAll(modelName, project);
            object = object2;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"super.buildAll(modelName, project)");
        }
        return object;
    }

    @Override
    @NotNull
    protected Collection<String> getDynamicFeatures() {
        return ((BaseAppModuleExtension)this.extension).getDynamicFeatures();
    }

    private final Object buildMinimalisticModel() {
        ImmutableList.Builder variantsOutput = ImmutableList.builder();
        Iterator<VariantScope> iterator = this.variantManager.getVariantScopes().iterator();
        while (iterator.hasNext()) {
            VariantScope variantScope;
            VariantScope variantScope2 = variantScope = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)variantScope2, (String)"variantScope");
            BuildArtifactsHolder artifacts = variantScope2.getArtifacts();
            if (!artifacts.hasArtifact(InternalArtifactType.BUNDLE)) continue;
            File bundleFile = BuildableArtifactUtil.singleFile(artifacts.getFinalArtifactFiles(InternalArtifactType.BUNDLE));
            File apkFolder = BuildableArtifactUtil.singleFile(artifacts.getFinalArtifactFiles(InternalArtifactType.EXTRACTED_APKS));
            variantsOutput.add((Object)new DefaultAppBundleVariantBuildOutput(variantScope.getFullVariantName(), bundleFile, apkFolder));
        }
        return new DefaultAppBundleProjectBuildOutput((ImmutableList<AppBundleVariantBuildOutput>)variantsOutput.build());
    }

    public AppModelBuilder(@NotNull GlobalScope globalScope, @NotNull VariantManager variantManager, @NotNull TaskManager taskManager, @NotNull BaseAppModuleExtension config2, @NotNull ExtraModelInfo extraModelInfo, @NotNull NativeLibraryFactory nativeLibraryFactory, int projectType, int generation) {
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        Intrinsics.checkParameterIsNotNull((Object)variantManager, (String)"variantManager");
        Intrinsics.checkParameterIsNotNull((Object)taskManager, (String)"taskManager");
        Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)extraModelInfo, (String)"extraModelInfo");
        Intrinsics.checkParameterIsNotNull((Object)nativeLibraryFactory, (String)"nativeLibraryFactory");
        super(globalScope, variantManager, taskManager, (AndroidConfig)config2, extraModelInfo, nativeLibraryFactory, projectType, generation);
        this.variantManager = variantManager;
    }
}

